/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.jaxb.referencing.CC_OperationParameterGroup;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractSingleOperationType", propOrder={"method", "parameters"})
@XmlRootElement(name="AbstractSingleOperation")
@XmlSeeAlso(value={DefaultConversion.class, DefaultTransformation.class})
class AbstractSingleOperation
extends AbstractCoordinateOperation
implements SingleOperation,
Parameterized {
    private static final long serialVersionUID = -2635450075620911309L;
    private OperationMethod method;
    ParameterValueGroup parameters;

    public AbstractSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, interpolationCRS, transform);
        ArgumentChecks.ensureNonNull("method", method);
        ArgumentChecks.ensureNonNull("transform", transform);
        AbstractSingleOperation.checkDimensions(method, ReferencingUtilities.getDimension(interpolationCRS), transform, properties);
        this.method = method;
        this.parameters = Parameters.unmodifiable(Containers.property(properties, "parameters", ParameterValueGroup.class));
    }

    AbstractSingleOperation(Map<String, ?> properties, OperationMethod method) {
        super(properties);
        ArgumentChecks.ensureNonNull("method", method);
        this.method = method;
    }

    protected AbstractSingleOperation(SingleOperation operation) {
        super(operation);
        this.method = operation.getMethod();
        this.parameters = Parameters.unmodifiable(operation.getParameterValues());
    }

    static void checkDimensions(OperationMethod method, int interpDim, MathTransform transform, Map<String, ?> properties) throws IllegalArgumentException {
        int actual = transform.getSourceDimensions();
        Integer expected = method.getSourceDimensions();
        if (expected != null && actual > expected + interpDim) {
            MathTransform subTransform = null;
            for (MathTransform step : MathTransforms.getSteps(transform)) {
                if (AbstractSingleOperation.isIgnorable(step)) continue;
                if (subTransform == null && step instanceof PassThroughTransform) {
                    subTransform = ((PassThroughTransform)step).getSubTransform();
                    continue;
                }
                subTransform = null;
                break;
            }
            if (subTransform != null) {
                transform = subTransform;
                actual = transform.getSourceDimensions();
            }
        }
        int isTarget = 0;
        if (expected == null || actual == expected || actual == expected + interpDim) {
            actual = transform.getTargetDimensions();
            expected = method.getTargetDimensions();
            if (expected == null || actual == expected || actual == expected + interpDim) {
                return;
            }
            isTarget = 1;
        }
        if (!IdentifiedObjects.isHeuristicMatchForName(method, "Affine")) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)178, isTarget, expected, actual));
        }
    }

    private static boolean isIgnorable(MathTransform transform) {
        Matrix matrix = MathTransforms.getMatrix(transform);
        if (matrix != null) {
            int size = matrix.getNumRow();
            if (matrix.getNumCol() == size) {
                for (int j = 0; j < size; ++j) {
                    int n1 = 0;
                    int n2 = 0;
                    for (int i = 0; i < size; ++i) {
                        if (matrix.getElement(j, i) != 0.0) {
                            ++n1;
                        }
                        if (matrix.getElement(i, j) == 0.0) continue;
                        ++n2;
                    }
                    if (n1 == 1 && n2 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @XmlElement(name="method", required=true)
    public OperationMethod getMethod() {
        return this.method;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.parameters != null ? this.parameters.getDescriptor() : super.getParameterDescriptors();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.parameters != null ? this.parameters : super.getParameterValues();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractSingleOperation that = (AbstractSingleOperation)object;
                return Objects.equals(this.method, that.method) && Objects.equals(this.parameters, that.parameters);
            }
            case BY_CONTRACT: {
                SingleOperation that = (SingleOperation)object;
                return Utilities.deepEquals(this.getMethod(), that.getMethod(), mode) && Utilities.deepEquals(this.getParameterValues(), that.getParameterValues(), mode);
            }
        }
        return true;
    }

    AbstractSingleOperation() {
    }

    private void setMethod(OperationMethod value) {
        if (this.method == null) {
            this.method = value;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, "setMethod", "method");
        }
    }

    @XmlElement(name="parameterValue")
    private GeneralParameterValue[] getParameters() {
        List<GeneralParameterValue> values;
        if (this.parameters != null && (values = this.parameters.values()) != null) {
            return CC_OperationMethod.filterImplicit(values.toArray(new GeneralParameterValue[values.size()]));
        }
        return null;
    }

    private void setParameters(GeneralParameterValue[] values) {
        if (this.parameters == null) {
            if (!(this.method instanceof DefaultOperationMethod)) {
                throw new IllegalStateException(Errors.format((short)64, "method"));
            }
            IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements = new IdentityHashMap<GeneralParameterDescriptor, GeneralParameterDescriptor>(4);
            GeneralParameterDescriptor[] merged = CC_OperationParameterGroup.merge(this.method.getParameters().descriptors(), Parameters.getDescriptors(values), replacements);
            for (int i = 0; i < merged.length; ++i) {
                if (merged[i] == values[i].getDescriptor()) continue;
                ((DefaultOperationMethod)this.method).updateDescriptors(merged);
                break;
            }
            this.parameters = new DefaultParameterValueGroup(this.method.getParameters());
            CC_OperationMethod.store(values, this.parameters.values(), replacements);
            this.parameters = Parameters.unmodifiable(this.parameters);
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractSingleOperation.class, "setParameters", "parameterValue");
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        CoordinateReferenceSystem sourceCRS = super.getSourceCRS();
        CoordinateReferenceSystem targetCRS = super.getTargetCRS();
        if (this.transform == null && sourceCRS != null && targetCRS != null && this.parameters != null) {
            try {
                this.transform = DefaultFactories.forBuildin(MathTransformFactory.class).createBaseToDerived(sourceCRS, this.parameters, targetCRS.getCoordinateSystem());
            }
            catch (FactoryException e) {
                Context.warningOccured(Context.current(), AbstractSingleOperation.class, "afterUnmarshal", e, true);
            }
        }
    }
}

