/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import org.apache.sis.internal.jdk8.Predicate;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.CoordinateOperation;

public class CoordinateOperationContext
implements Serializable {
    private static final long serialVersionUID = -6944460471653277973L;
    private Extent areaOfInterest;
    private double desiredAccuracy;

    public CoordinateOperationContext() {
    }

    public CoordinateOperationContext(Extent area, double accuracy) {
        ArgumentChecks.ensurePositive("accuracy", accuracy);
        this.areaOfInterest = area;
        this.desiredAccuracy = accuracy;
    }

    public Extent getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public void setAreaOfInterest(Extent area) {
        if (area != null) {
            area = new DefaultExtent(area);
        }
        this.areaOfInterest = area;
    }

    public void setAreaOfInterest(GeographicBoundingBox area) {
        this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, area);
    }

    static Extent setGeographicBoundingBox(Extent areaOfInterest, GeographicBoundingBox bbox) {
        if (areaOfInterest != null) {
            DefaultExtent ex = DefaultExtent.castOrCopy(areaOfInterest);
            ex.setGeographicElements(CollectionsExt.singletonOrEmpty(bbox));
            areaOfInterest = ex;
        } else if (bbox != null) {
            areaOfInterest = new DefaultExtent(null, bbox, null, null);
        }
        return areaOfInterest;
    }

    public double getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public void setDesiredAccuracy(double accuracy) {
        ArgumentChecks.ensurePositive("accuracy", accuracy);
        this.desiredAccuracy = accuracy;
    }

    Predicate<CoordinateOperation> getOperationFilter() {
        return null;
    }
}

