/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.metadata.VerticalDatumTypes;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeocentricToGeographic;
import org.apache.sis.internal.referencing.provider.Geographic2Dto3D;
import org.apache.sis.internal.referencing.provider.Geographic3Dto2D;
import org.apache.sis.internal.referencing.provider.GeographicToGeocentric;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.parameter.TensorParameters;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPassThroughOperation;
import org.apache.sis.referencing.operation.MathTransformContext;
import org.apache.sis.referencing.operation.SubOperationInfo;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class CoordinateOperationFinder
extends CoordinateOperationRegistry {
    private static final double MOLODENSKY_ACCURACY = 5.0;
    private final Map<Identifier, Object> identifierOfStepCRS = new HashMap<Identifier, Object>(8);
    private final Map<CRSPair, Boolean> previousSearches = new HashMap<CRSPair, Boolean>(8);
    private final boolean useCache;

    public CoordinateOperationFinder(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        super(registry, factory, context);
        this.useCache = context == null && factory == this.factorySIS;
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        SingleCRS source;
        CoordinateOperation op;
        CoordinateOperation op2;
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        if (Utilities.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            try {
                return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem()));
            }
            catch (IllegalArgumentException e) {
                throw new FactoryException(Errors.format((short)5, new CRSPair(sourceCRS, targetCRS)), e);
            }
            catch (ConversionException e) {
                throw new FactoryException(Errors.format((short)5, new CRSPair(sourceCRS, targetCRS)), e);
            }
        }
        CRSPair key = new CRSPair(sourceCRS, targetCRS);
        if (this.useCache && !this.previousSearches.isEmpty() && (op2 = this.factorySIS.cache.peek(key)) != null) {
            return op2;
        }
        if (this.previousSearches.put(key, Boolean.TRUE) != null) {
            throw new FactoryException(Errors.format((short)210, CoordinateOperation.class, key));
        }
        GeographicBoundingBox bbox = Extents.getGeographicBoundingBox(this.areaOfInterest);
        if (bbox == null) {
            bbox = Extents.intersection(CRS.getGeographicBoundingBox(sourceCRS), CRS.getGeographicBoundingBox(targetCRS));
            this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, bbox);
        }
        if (this.registry != null && (op = super.createOperation(sourceCRS, targetCRS)) != null) {
            return op;
        }
        if (sourceCRS instanceof GeneralDerivedCRS) {
            source = (GeneralDerivedCRS)sourceCRS;
            if (targetCRS instanceof GeneralDerivedCRS) {
                return this.createOperationStep((GeneralDerivedCRS)source, (GeneralDerivedCRS)targetCRS);
            }
            if (targetCRS instanceof SingleCRS) {
                return this.createOperationStep((GeneralDerivedCRS)source, (SingleCRS)targetCRS);
            }
        }
        if (targetCRS instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS target = (GeneralDerivedCRS)targetCRS;
            if (sourceCRS instanceof SingleCRS) {
                return this.createOperationStep((SingleCRS)sourceCRS, target);
            }
        }
        if (sourceCRS instanceof GeodeticCRS) {
            source = (GeodeticCRS)sourceCRS;
            if (targetCRS instanceof GeodeticCRS) {
                return this.createOperationStep((GeodeticCRS)source, (GeodeticCRS)targetCRS);
            }
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((GeodeticCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof VerticalCRS) {
            source = (VerticalCRS)sourceCRS;
            if (targetCRS instanceof VerticalCRS) {
                return this.createOperationStep((VerticalCRS)source, (VerticalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof TemporalCRS) {
            source = (TemporalCRS)sourceCRS;
            if (targetCRS instanceof TemporalCRS) {
                return this.createOperationStep((TemporalCRS)source, (TemporalCRS)targetCRS);
            }
        }
        if (sourceCRS instanceof CompoundCRS || targetCRS instanceof CompoundCRS) {
            return this.createOperationStep(sourceCRS, CRS.getSingleComponents(sourceCRS), targetCRS, CRS.getSingleComponents(targetCRS));
        }
        throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS));
    }

    protected CoordinateOperation createOperationStep(SingleCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        CoordinateOperation step1 = this.createOperation(sourceCRS, targetCRS.getBaseCRS());
        Conversion step2 = targetCRS.getConversionFromBase();
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(GeneralDerivedCRS sourceCRS, SingleCRS targetCRS) throws FactoryException {
        CoordinateOperation step1;
        CoordinateOperation step2 = this.createOperation(sourceCRS.getBaseCRS(), targetCRS);
        try {
            step1 = this.inverse(sourceCRS.getConversionFromBase());
        }
        catch (NoninvertibleTransformException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        return this.concatenate(step1, step2);
    }

    protected CoordinateOperation createOperationStep(GeneralDerivedCRS sourceCRS, GeneralDerivedCRS targetCRS) throws FactoryException {
        CoordinateOperation step1;
        CoordinateOperation step2 = this.createOperation(sourceCRS.getBaseCRS(), targetCRS.getBaseCRS());
        Conversion step3 = targetCRS.getConversionFromBase();
        try {
            step1 = this.inverse(sourceCRS.getConversionFromBase());
        }
        catch (NoninvertibleTransformException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(GeodeticCRS sourceCRS, GeodeticCRS targetCRS) throws FactoryException {
        ParameterValueGroup parameters;
        Identifier identifier;
        GeodeticDatum sourceDatum = sourceCRS.getDatum();
        GeodeticDatum targetDatum = targetCRS.getDatum();
        Matrix datumShift = null;
        DefaultMathTransformFactory.Context context = ReferencingUtilities.createTransformContext(sourceCRS, targetCRS, new MathTransformContext(sourceDatum, targetDatum));
        boolean isGeographicToGeocentric = false;
        CoordinateSystem sourceCS = context.getSourceCS();
        CoordinateSystem targetCS = context.getTargetCS();
        if (Utilities.equalsIgnoreMetadata(sourceDatum, targetDatum)) {
            boolean isGeocentricToGeographic;
            isGeographicToGeocentric = sourceCS instanceof EllipsoidalCS && targetCS instanceof CartesianCS;
            boolean bl = isGeocentricToGeographic = sourceCS instanceof CartesianCS && targetCS instanceof EllipsoidalCS;
            identifier = isGeocentricToGeographic ^ isGeographicToGeocentric ? GEOCENTRIC_CONVERSION : AXIS_CHANGES;
        } else {
            identifier = ELLIPSOID_CHANGE;
            if (sourceDatum instanceof DefaultGeodeticDatum && (datumShift = ((DefaultGeodeticDatum)sourceDatum).getPositionVectorTransformation(targetDatum, this.areaOfInterest)) != null) {
                identifier = DATUM_SHIFT;
            }
        }
        DefaultMathTransformFactory mtFactory = this.factorySIS.getDefaultMathTransformFactory();
        MathTransform before = null;
        MathTransform after = null;
        if (datumShift != null) {
            parameters = GeocentricAffine.createParameters(sourceCS, targetCS, datumShift, this.desiredAccuracy >= 5.0);
            if (parameters == null) {
                parameters = TensorParameters.WKT1.createValueGroup(CoordinateOperationFinder.properties("Affine"), datumShift);
                CoordinateSystem normalized = CommonCRS.WGS84.geocentric().getCoordinateSystem();
                before = mtFactory.createCoordinateSystemChange(sourceCS, normalized);
                after = mtFactory.createCoordinateSystemChange(normalized, targetCS);
                context.setSource(normalized);
                context.setTarget(normalized);
            }
        } else if (identifier == GEOCENTRIC_CONVERSION) {
            parameters = (isGeographicToGeocentric ? GeographicToGeocentric.PARAMETERS : GeocentricToGeographic.PARAMETERS).createValue();
        } else {
            int sourceDim = sourceCS.getDimension();
            int targetDim = targetCS.getDimension();
            if ((sourceDim & 0xFFFFFFFE) == 2 && (sourceDim ^ targetDim) == 1 && sourceCS instanceof EllipsoidalCS && targetCS instanceof EllipsoidalCS) {
                parameters = (sourceDim == 2 ? Geographic2Dto3D.PARAMETERS : Geographic3Dto2D.PARAMETERS).createValue();
            } else {
                parameters = TensorParameters.WKT1.createValueGroup(CoordinateOperationFinder.properties("Affine"));
                parameters.parameter("num_col").setValue(targetDim + 1);
                parameters.parameter("num_row").setValue(targetDim + 1);
                before = mtFactory.createCoordinateSystemChange(sourceCS, targetCS);
                context.setSource(targetCS);
            }
        }
        MathTransform transform = mtFactory.createParameterizedTransform(parameters, context);
        OperationMethod method = mtFactory.getLastMethodUsed();
        if (before != null) {
            transform = mtFactory.createConcatenatedTransform(before, transform);
            if (after != null) {
                transform = mtFactory.createConcatenatedTransform(transform, after);
            }
        }
        return this.createFromMathTransform(CoordinateOperationFinder.properties(identifier), sourceCRS, targetCRS, transform, method, parameters, null);
    }

    protected CoordinateOperation createOperationStep(GeodeticCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        boolean isEllipsoidalHeight;
        int i;
        EllipsoidalCS cs;
        CoordinateOperation step1 = null;
        CoordinateOperation step3 = null;
        CoordinateReferenceSystem interpolationCRS = sourceCRS;
        CoordinateSystem interpolationCS = interpolationCRS.getCoordinateSystem();
        if (!(interpolationCS instanceof EllipsoidalCS) && !Utilities.equalsIgnoreMetadata(interpolationCS, cs = CommonCRS.WGS84.geographic3D().getCoordinateSystem())) {
            GeographicCRS stepCRS = this.factorySIS.getCRSFactory().createGeographicCRS(this.derivedFrom(sourceCRS), sourceCRS.getDatum(), cs);
            step1 = this.createOperation(sourceCRS, this.toAuthorityDefinition(GeographicCRS.class, stepCRS));
            interpolationCRS = step1.getTargetCRS();
            interpolationCS = interpolationCRS.getCoordinateSystem();
        }
        if ((i = AxisDirections.indexOfColinear(interpolationCS, AxisDirection.UP)) < 0) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS));
        }
        CoordinateSystemAxis expectedAxis = interpolationCS.getAxis(i);
        VerticalCRS heightCRS = targetCRS;
        VerticalCS heightCS = heightCRS.getCoordinateSystem();
        if (Utilities.equalsIgnoreMetadata(heightCS.getAxis(0), expectedAxis)) {
            isEllipsoidalHeight = VerticalDatumTypes.ELLIPSOIDAL.equals(heightCRS.getDatum().getVerticalDatumType());
        } else {
            heightCRS = CommonCRS.Vertical.ELLIPSOIDAL.crs();
            heightCS = heightCRS.getCoordinateSystem();
            isEllipsoidalHeight = Utilities.equalsIgnoreMetadata(heightCS.getAxis(0), expectedAxis);
            if (!isEllipsoidalHeight) {
                heightCS = this.toAuthorityDefinition(VerticalCS.class, this.factorySIS.getCSFactory().createVerticalCS(this.derivedFrom(heightCS), expectedAxis));
            }
        }
        if (!isEllipsoidalHeight) {
            heightCRS = this.toAuthorityDefinition(VerticalCRS.class, this.factorySIS.getCRSFactory().createVerticalCRS(this.derivedFrom(heightCRS), CommonCRS.Vertical.ELLIPSOIDAL.datum(), heightCS));
        }
        if (heightCRS != targetCRS) {
            step3 = this.createOperation(heightCRS, targetCRS);
            heightCRS = (VerticalCRS)step3.getSourceCRS();
            heightCS = heightCRS.getCoordinateSystem();
        }
        int srcDim = interpolationCS.getDimension();
        int tgtDim = heightCS.getDimension();
        MatrixSIS matrix = Matrices.createZero(tgtDim + 1, srcDim + 1);
        matrix.setElement(0, i, 1.0);
        matrix.setElement(tgtDim, srcDim, 1.0);
        CoordinateOperation step2 = this.createFromAffineTransform(AXIS_CHANGES, interpolationCRS, heightCRS, matrix);
        return this.concatenate(step1, step2, step3);
    }

    protected CoordinateOperation createOperationStep(VerticalCRS sourceCRS, VerticalCRS targetCRS) throws FactoryException {
        Matrix matrix;
        VerticalDatum targetDatum;
        VerticalDatum sourceDatum = sourceCRS.getDatum();
        if (!Utilities.equalsIgnoreMetadata(sourceDatum, targetDatum = targetCRS.getDatum())) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceDatum, targetDatum));
        }
        VerticalCS sourceCS = sourceCRS.getCoordinateSystem();
        VerticalCS targetCS = targetCRS.getCoordinateSystem();
        try {
            matrix = CoordinateSystems.swapAndScaleAxes(sourceCS, targetCS);
        }
        catch (IllegalArgumentException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        catch (ConversionException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(TemporalCRS sourceCRS, TemporalCRS targetCRS) throws FactoryException {
        Matrix matrix;
        TemporalDatum sourceDatum = sourceCRS.getDatum();
        TemporalDatum targetDatum = targetCRS.getDatum();
        TimeCS sourceCS = sourceCRS.getCoordinateSystem();
        TimeCS targetCS = targetCRS.getCoordinateSystem();
        Unit<Duration> targetUnit = targetCS.getAxis(0).getUnit().asType(Duration.class);
        double epochShift = sourceDatum.getOrigin().getTime() - targetDatum.getOrigin().getTime();
        epochShift = Units.MILLISECOND.getConverterTo(targetUnit).convert(epochShift);
        try {
            matrix = CoordinateSystems.swapAndScaleAxes(sourceCS, targetCS);
        }
        catch (IllegalArgumentException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        catch (ConversionException exception) {
            throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS), exception);
        }
        int translationColumn = matrix.getNumCol() - 1;
        double translation = matrix.getElement(0, translationColumn);
        matrix.setElement(0, translationColumn, translation + epochShift);
        return this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, targetCRS, matrix);
    }

    protected CoordinateOperation createOperationStep(CoordinateReferenceSystem sourceCRS, List<? extends SingleCRS> sourceComponents, CoordinateReferenceSystem targetCRS, List<? extends SingleCRS> targetComponents) throws FactoryException {
        CoordinateOperation operation;
        CoordinateReferenceSystem stepSourceCRS;
        SubOperationInfo[] infos = new SubOperationInfo[targetComponents.size()];
        boolean[] sourceIsUsed = new boolean[sourceComponents.size()];
        CoordinateReferenceSystem[] stepComponents = new CoordinateReferenceSystem[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = SubOperationInfo.create(this, sourceIsUsed, sourceComponents, targetComponents.get(i));
            if (infos[i] == null) {
                throw new OperationNotFoundException(CoordinateOperationFinder.notFoundMessage(sourceCRS, targetCRS));
            }
            stepComponents[i] = infos[i].operation.getSourceCRS();
        }
        int remainingSourceDimensions = 0;
        for (SubOperationInfo component : infos) {
            remainingSourceDimensions += component.endAtDimension - component.startAtDimension;
        }
        Matrix select = SubOperationInfo.sourceToSelected(sourceCRS.getCoordinateSystem().getDimension(), remainingSourceDimensions, infos);
        if (select.isIdentity()) {
            stepSourceCRS = sourceCRS;
            operation = null;
        } else {
            stepSourceCRS = stepComponents.length == 1 ? stepComponents[0] : (CoordinateReferenceSystem)this.toAuthorityDefinition(CoordinateReferenceSystem.class, this.factorySIS.getCRSFactory().createCompoundCRS(this.derivedFrom(sourceCRS), stepComponents));
            operation = this.createFromAffineTransform(AXIS_CHANGES, sourceCRS, stepSourceCRS, select);
        }
        int endAtDimension = 0;
        int startOfIdentity = SubOperationInfo.startOfIdentity(infos);
        for (int i = 0; i < stepComponents.length; ++i) {
            CoordinateReferenceSystem source = stepComponents[i];
            CoordinateReferenceSystem target = targetComponents.get(i);
            CoordinateOperation subOperation = infos[i].operation;
            MathTransform subTransform = subOperation.getMathTransform();
            stepComponents[i] = target;
            CoordinateReferenceSystem stepTargetCRS = i >= startOfIdentity ? targetCRS : (subTransform.isIdentity() ? stepSourceCRS : (stepComponents.length == 1 ? target : this.toAuthorityDefinition(CoordinateReferenceSystem.class, ReferencingServices.getInstance().createCompoundCRS(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), this.derivedFrom(target), stepComponents))));
            int delta = source.getCoordinateSystem().getDimension();
            int startAtDimension = endAtDimension;
            if (startAtDimension != 0 || (endAtDimension += delta) != remainingSourceDimensions) {
                Map<String, ?> properties = IdentifiedObjects.getProperties(subOperation, new String[0]);
                SingleOperation op = SubTypes.isSingleOperation(subOperation) ? (SingleOperation)subOperation : this.factorySIS.createSingleOperation(properties, subOperation.getSourceCRS(), subOperation.getTargetCRS(), null, new DefaultOperationMethod(subTransform), subTransform);
                subOperation = new DefaultPassThroughOperation(properties, stepSourceCRS, stepTargetCRS, op, startAtDimension, remainingSourceDimensions - endAtDimension);
            }
            operation = this.concatenate(operation, subOperation);
            stepSourceCRS = stepTargetCRS;
            endAtDimension -= (delta -= target.getCoordinateSystem().getDimension());
            remainingSourceDimensions -= delta;
        }
        return operation;
    }

    private CoordinateOperation createFromAffineTransform(Identifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Matrix matrix) throws FactoryException {
        MathTransform transform = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
        return this.createFromMathTransform(CoordinateOperationFinder.properties(name), sourceCRS, targetCRS, transform, null, null, null);
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2) throws FactoryException {
        boolean isAxisChange2;
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return step2;
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return step1;
        }
        MathTransform mt1 = step1.getMathTransform();
        MathTransform mt2 = step2.getMathTransform();
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step2.getTargetCRS();
        CoordinateOperation main = null;
        boolean isAxisChange1 = step1.getName() == AXIS_CHANGES;
        boolean bl = isAxisChange2 = step2.getName() == AXIS_CHANGES;
        if (isAxisChange1 && isAxisChange2 && CoordinateOperationFinder.isAffine(step1) && CoordinateOperationFinder.isAffine(step2)) {
            main = step2;
        } else {
            if (isAxisChange1 && mt1.getSourceDimensions() == mt1.getTargetDimensions()) {
                main = step2;
            }
            if (isAxisChange2 && mt2.getSourceDimensions() == mt2.getTargetDimensions()) {
                main = step1;
            }
        }
        if (SubTypes.isSingleOperation(main)) {
            SingleOperation op = (SingleOperation)main;
            MathTransform mt = this.factorySIS.getMathTransformFactory().createConcatenatedTransform(mt1, mt2);
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties(main, new String[0])), sourceCRS, targetCRS, mt, op.getMethod(), op.getParameterValues(), main instanceof Transformation ? Transformation.class : (main instanceof Conversion ? Conversion.class : SingleOperation.class));
        } else {
            main = this.factory.createConcatenatedOperation(CoordinateOperationFinder.defaultName(sourceCRS, targetCRS), step1, step2);
        }
        if (main instanceof ConcatenatedOperation && main.getMathTransform().isIdentity()) {
            Class<Transformation> type = null;
            for (CoordinateOperation coordinateOperation : ((ConcatenatedOperation)main).getOperations()) {
                if (!(coordinateOperation instanceof Transformation)) continue;
                type = Transformation.class;
                break;
            }
            main = this.createFromMathTransform(new HashMap<String, Object>(IdentifiedObjects.getProperties(main, new String[0])), main.getSourceCRS(), main.getTargetCRS(), main.getMathTransform(), null, null, type);
        }
        return main;
    }

    private CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2, CoordinateOperation step3) throws FactoryException {
        if (CoordinateOperationFinder.isIdentity(step1)) {
            return this.concatenate(step2, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step2)) {
            return this.concatenate(step1, step3);
        }
        if (CoordinateOperationFinder.isIdentity(step3)) {
            return this.concatenate(step1, step2);
        }
        if (step1.getName() == AXIS_CHANGES) {
            return this.concatenate(this.concatenate(step1, step2), step3);
        }
        if (step3.getName() == AXIS_CHANGES) {
            return this.concatenate(step1, this.concatenate(step2, step3));
        }
        Map<String, ?> properties = CoordinateOperationFinder.defaultName(step1.getSourceCRS(), step3.getTargetCRS());
        return this.factory.createConcatenatedOperation(properties, step1, step2, step3);
    }

    private static boolean isAffine(CoordinateOperation operation) {
        return operation instanceof SingleOperation && IdentifiedObjects.isHeuristicMatchForName(((SingleOperation)operation).getMethod(), "Affine");
    }

    private static boolean isIdentity(CoordinateOperation operation) {
        return operation == null || operation instanceof Conversion && operation.getMathTransform().isIdentity();
    }

    private static Map<String, ?> properties(String name) {
        return Collections.singletonMap("name", name);
    }

    private Map<String, ?> derivedFrom(IdentifiedObject object) {
        Identifier oldID = object.getName();
        Object p = this.identifierOfStepCRS.get(oldID);
        if (p instanceof Identifier) {
            oldID = (Identifier)p;
            p = this.identifierOfStepCRS.get(oldID);
        }
        int count = p != null ? (Integer)p + 1 : 1;
        NamedIdentifier newID = new NamedIdentifier(Citations.SIS, oldID.getCode() + " (step " + count + ')');
        this.identifierOfStepCRS.put(newID, oldID);
        this.identifierOfStepCRS.put(oldID, count);
        HashMap<String, Comparable<GenericName>> properties = new HashMap<String, Comparable<GenericName>>(4);
        properties.put("name", newID);
        properties.put("remarks", Vocabulary.formatInternational((short)108, (Object)CRSPair.label(object)));
        return properties;
    }

    private static Map<String, ?> defaultName(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        return CoordinateOperationFinder.properties(new CRSPair(source, target).toString());
    }

    private static String notFoundMessage(IdentifiedObject source, IdentifiedObject target) {
        return Errors.format((short)219, CRSPair.label(source), CRSPair.label(target));
    }
}

