/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.converter.ConversionException;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.jdk8.Predicate;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class CoordinateOperationRegistry {
    private static final Identifier IDENTITY = CoordinateOperationRegistry.createIdentifier((short)105);
    static final Identifier AXIS_CHANGES = CoordinateOperationRegistry.createIdentifier((short)98);
    static final Identifier ELLIPSOID_CHANGE = CoordinateOperationRegistry.createIdentifier((short)101);
    static final Identifier DATUM_SHIFT = CoordinateOperationRegistry.createIdentifier((short)100);
    static final Identifier GEOCENTRIC_CONVERSION = CoordinateOperationRegistry.createIdentifier((short)103);
    private static final Identifier INVERSE_OPERATION = CoordinateOperationRegistry.createIdentifier((short)106);
    private final IdentifiedObjectFinder codeFinder;
    protected final CoordinateOperationAuthorityFactory registry;
    protected final CoordinateOperationFactory factory;
    final DefaultCoordinateOperationFactory factorySIS;
    protected Extent areaOfInterest;
    protected double desiredAccuracy;
    private Predicate<CoordinateOperation> filter;

    private static Identifier createIdentifier(short key) {
        return new NamedIdentifier(Citations.SIS, Vocabulary.formatInternational(key));
    }

    CoordinateOperationRegistry(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        ArgumentChecks.ensureNonNull("factory", factory);
        this.registry = registry;
        this.factory = factory;
        this.factorySIS = factory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)factory : CoordinateOperations.factory();
        IdentifiedObjectFinder codeFinder = null;
        if (registry != null) {
            if (registry instanceof GeodeticAuthorityFactory) {
                codeFinder = ((GeodeticAuthorityFactory)((Object)registry)).newIdentifiedObjectFinder();
            } else {
                try {
                    codeFinder = IdentifiedObjects.newFinder(org.apache.sis.internal.util.Citations.getIdentifier(registry.getAuthority(), false));
                }
                catch (NoSuchAuthorityFactoryException e) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationRegistry.class, "<init>", e);
                }
            }
            if (codeFinder != null) {
                codeFinder.setIgnoringAxes(true);
            }
        }
        this.codeFinder = codeFinder;
        if (context != null) {
            this.areaOfInterest = context.getAreaOfInterest();
            this.desiredAccuracy = context.getDesiredAccuracy();
            this.filter = context.getOperationFilter();
        }
    }

    final <T extends IdentifiedObject> T toAuthorityDefinition(Class<T> type, T object) throws FactoryException {
        if (this.codeFinder != null) {
            this.codeFinder.setIgnoringAxes(false);
            IdentifiedObject candidate = this.codeFinder.findSingleton(object);
            this.codeFinder.setIgnoringAxes(true);
            if (Utilities.equalsIgnoreMetadata(object, candidate)) {
                return (T)((IdentifiedObject)type.cast(candidate));
            }
        }
        return object;
    }

    private String findCode(CoordinateReferenceSystem crs) throws FactoryException {
        Identifier identifier;
        if (this.codeFinder != null && (identifier = IdentifiedObjects.getIdentifier(this.codeFinder.findSingleton(crs), null)) != null) {
            return identifier.getCode();
        }
        return null;
    }

    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        CoordinateReferenceSystem source = sourceCRS;
        CoordinateReferenceSystem target = targetCRS;
        int combine = 0;
        while (true) {
            block16: {
                switch (combine) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        target = CRS.getHorizontalComponent(targetCRS);
                        if (target != targetCRS) break;
                        break block16;
                    }
                    case 2: {
                        source = CRS.getHorizontalComponent(sourceCRS);
                        if (source != sourceCRS) break;
                        break block16;
                    }
                    case 3: {
                        if (source != sourceCRS && target != targetCRS) {
                            target = targetCRS;
                            break;
                        }
                        break block16;
                    }
                    default: {
                        return null;
                    }
                }
                if (source != null && target != null) {
                    try {
                        CoordinateOperation operation = this.search(source, target);
                        if (operation == null) break block16;
                        if (combine != 0) {
                            operation = this.propagateVertical(sourceCRS, source != sourceCRS, targetCRS, target != targetCRS, operation);
                            if (operation == null) break block16;
                            operation = this.complete(operation, sourceCRS, targetCRS);
                        }
                        return operation;
                    }
                    catch (IllegalArgumentException e) {
                        String message = Errors.format((short)5, new CRSPair(sourceCRS, targetCRS));
                        String details = e.getLocalizedMessage();
                        if (details != null) {
                            message = message + ' ' + details;
                        }
                        throw new FactoryException(message, e);
                    }
                    catch (ConversionException e) {
                        throw new FactoryException(Errors.format((short)5, new CRSPair(sourceCRS, targetCRS)), e);
                    }
                }
            }
            ++combine;
        }
    }

    private CoordinateOperation search(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IllegalArgumentException, ConversionException, FactoryException {
        boolean inverse;
        Set<CoordinateOperation> operations;
        String sourceID = this.findCode(sourceCRS);
        if (sourceID == null) {
            return null;
        }
        String targetID = this.findCode(targetCRS);
        if (targetID == null) {
            return null;
        }
        if (sourceID.equals(targetID)) {
            return null;
        }
        try {
            operations = this.registry.createFromCoordinateReferenceSystemCodes(sourceID, targetID);
            inverse = Containers.isNullOrEmpty(operations);
            if (inverse && Containers.isNullOrEmpty(operations = this.registry.createFromCoordinateReferenceSystemCodes(targetID, sourceID))) {
                return null;
            }
        }
        catch (NoSuchAuthorityCodeException exception) {
            CoordinateOperationRegistry.log(exception);
            return null;
        }
        catch (MissingFactoryResourceException exception) {
            CoordinateOperationRegistry.log(exception);
            return null;
        }
        double largestArea = 0.0;
        double finestAccuracy = Double.POSITIVE_INFINITY;
        CoordinateOperation bestChoice = null;
        boolean stopAtFirstDeprecated = false;
        Iterator<CoordinateOperation> it = operations.iterator();
        while (it.hasNext()) {
            boolean isDeprecated;
            CoordinateOperation candidate;
            try {
                candidate = it.next();
            }
            catch (BackingStoreException exception) {
                FactoryException cause = exception.unwrapOrRethrow(FactoryException.class);
                if (cause instanceof MissingFactoryResourceException) {
                    CoordinateOperationRegistry.log(cause);
                    continue;
                }
                throw cause;
            }
            if (candidate == null) continue;
            boolean bl = isDeprecated = candidate instanceof Deprecable && ((Deprecable)((Object)candidate)).isDeprecated();
            if (isDeprecated && stopAtFirstDeprecated) break;
            double area = Extents.area(Extents.intersection(Extents.getGeographicBoundingBox(this.areaOfInterest), Extents.getGeographicBoundingBox(candidate.getDomainOfValidity())));
            if (bestChoice != null && !(area >= largestArea)) continue;
            double accuracy = CRS.getLinearAccuracy(candidate);
            if (bestChoice != null && area == largestArea && !(accuracy < finestAccuracy)) continue;
            if (inverse) {
                try {
                    candidate = this.inverse(candidate);
                }
                catch (NoninvertibleTransformException exception) {
                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationRegistry.class, "createOperation", exception);
                    continue;
                }
                catch (MissingFactoryResourceException e) {
                    CoordinateOperationRegistry.log(e);
                    continue;
                }
            }
            candidate = this.complete(candidate, sourceCRS, targetCRS);
            if (this.filter != null && !this.filter.test(candidate)) continue;
            bestChoice = candidate;
            if (!Double.isNaN(area)) {
                largestArea = area;
            }
            finestAccuracy = Double.isNaN(accuracy) ? Double.POSITIVE_INFINITY : accuracy;
            stopAtFirstDeprecated = !isDeprecated;
        }
        return bestChoice;
    }

    final CoordinateOperation inverse(SingleOperation op) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem sourceCRS = op.getSourceCRS();
        CoordinateReferenceSystem targetCRS = op.getTargetCRS();
        MathTransform transform = op.getMathTransform().inverse();
        Class type = null;
        if (op instanceof Transformation) {
            type = Transformation.class;
        } else if (op instanceof Conversion) {
            type = Conversion.class;
        }
        Map<String, Object> properties = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
        InverseOperationMethod.putMetadata(op, properties);
        InverseOperationMethod.putParameters(op, properties);
        return this.createFromMathTransform(properties, targetCRS, sourceCRS, transform, InverseOperationMethod.create(op.getMethod()), null, type);
    }

    private CoordinateOperation inverse(CoordinateOperation operation) throws NoninvertibleTransformException, FactoryException {
        if (SubTypes.isSingleOperation(operation)) {
            return this.inverse((SingleOperation)operation);
        }
        if (operation instanceof ConcatenatedOperation) {
            List<SingleOperation> operations = ((ConcatenatedOperation)operation).getOperations();
            CoordinateOperation[] inverted = new CoordinateOperation[operations.size()];
            int i = 0;
            while (i < inverted.length) {
                CoordinateOperation op = this.inverse((CoordinateOperation)operations.get(i));
                if (op == null) {
                    return null;
                }
                inverted[inverted.length - ++i] = op;
            }
            return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.properties(INVERSE_OPERATION), inverted);
        }
        return null;
    }

    private CoordinateOperation complete(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IllegalArgumentException, ConversionException, FactoryException {
        CoordinateReferenceSystem source = operation.getSourceCRS();
        CoordinateReferenceSystem target = operation.getTargetCRS();
        MathTransformFactory mtFactory = this.factorySIS.getMathTransformFactory();
        MathTransform prepend = CoordinateOperationRegistry.swapAndScaleAxes(sourceCRS, source, mtFactory);
        MathTransform append = CoordinateOperationRegistry.swapAndScaleAxes(target, targetCRS, mtFactory);
        if (prepend != null) {
            source = sourceCRS;
        }
        if (append != null) {
            target = targetCRS;
        }
        return this.transform(source, prepend, operation, append, target, mtFactory);
    }

    private static MathTransform swapAndScaleAxes(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws IllegalArgumentException, ConversionException, FactoryException {
        assert (ReferencingUtilities.getDimension(sourceCRS) != ReferencingUtilities.getDimension(targetCRS) || Utilities.deepEquals(sourceCRS, targetCRS, ComparisonMode.ALLOW_VARIANT));
        Matrix m = CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
        return m.isIdentity() ? null : mtFactory.createAffineTransform(m);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem sourceCRS, MathTransform prepend, CoordinateOperation operation, MathTransform append, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws IllegalArgumentException, FactoryException {
        if ((prepend == null || prepend.isIdentity()) && (append == null || append.isIdentity())) {
            return operation;
        }
        if (operation instanceof ConcatenatedOperation) {
            List<SingleOperation> c = ((ConcatenatedOperation)operation).getOperations();
            CoordinateOperation[] op = c.toArray(new CoordinateOperation[c.size()]);
            switch (op.length) {
                case 0: {
                    break;
                }
                case 1: {
                    operation = op[0];
                    break;
                }
                default: {
                    int n = op.length - 1;
                    CoordinateOperation first = op[0];
                    CoordinateOperation last = op[n];
                    op[0] = this.transform(sourceCRS, prepend, first, null, first.getTargetCRS(), mtFactory);
                    op[n] = this.transform(last.getSourceCRS(), null, last, append, targetCRS, mtFactory);
                    return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom(operation), op);
                }
            }
        }
        MathTransform transform = operation.getMathTransform();
        if (prepend != null) {
            transform = mtFactory.createConcatenatedTransform(prepend, transform);
        }
        if (append != null) {
            transform = mtFactory.createConcatenatedTransform(transform, append);
        }
        assert (!transform.equals(operation.getMathTransform())) : transform;
        return this.recreate(operation, sourceCRS, targetCRS, transform, null);
    }

    private CoordinateOperation recreate(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem crs = operation.getSourceCRS();
        if (Utilities.equalsApproximatively(sourceCRS, crs)) {
            sourceCRS = crs;
        }
        if (Utilities.equalsApproximatively(targetCRS, crs = operation.getTargetCRS())) {
            targetCRS = crs;
        }
        HashMap properties = new HashMap(CoordinateOperationRegistry.derivedFrom(operation));
        Class<? extends IdentifiedObject> type = operation instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)((Object)operation)).getInterface() : Classes.getLeafInterfaces(operation.getClass(), CoordinateOperation.class)[0];
        properties.put("operationType", type);
        if (SubTypes.isSingleOperation(operation)) {
            SingleOperation single = (SingleOperation)operation;
            properties.put("parameters", single.getParameterValues());
            if (method == null) {
                int sourceDimensions = transform.getSourceDimensions();
                int targetDimensions = transform.getTargetDimensions();
                method = single.getMethod();
                try {
                    method = DefaultOperationMethod.redimension(method, sourceDimensions, targetDimensions);
                }
                catch (IllegalArgumentException ex) {
                    try {
                        method = this.factorySIS.getOperationMethod(method.getName().getCode());
                        method = DefaultOperationMethod.redimension(method, sourceDimensions, targetDimensions);
                    }
                    catch (NoSuchIdentifierException se) {
                        throw ex;
                    }
                    catch (IllegalArgumentException se) {
                        throw ex;
                    }
                }
            }
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, AbstractCoordinateOperation.getInterpolationCRS(operation), method, transform);
    }

    private CoordinateOperation propagateVertical(CoordinateReferenceSystem sourceCRS, boolean source3D, CoordinateReferenceSystem targetCRS, boolean target3D, CoordinateOperation operation) throws IllegalArgumentException, FactoryException {
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>();
        if (operation instanceof ConcatenatedOperation) {
            operations.addAll(((ConcatenatedOperation)operation).getOperations());
        } else {
            operations.add(operation);
        }
        if (source3D && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(), true) || target3D && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(operations.size()), false)) {
            return null;
        }
        switch (operations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CoordinateOperation)operations.get(0);
            }
        }
        return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom(operation), operations.toArray(new CoordinateOperation[operations.size()]));
    }

    private boolean propagateVertical(CoordinateReferenceSystem source3D, CoordinateReferenceSystem target3D, ListIterator<CoordinateOperation> operations, boolean forward) throws IllegalArgumentException, FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateOperation op;
        CoordinateReferenceSystem sourceCRS;
        while ((forward ? operations.hasNext() : operations.hasPrevious()) && (sourceCRS = (op = forward ? operations.next() : operations.previous()).getSourceCRS()) instanceof GeodeticCRS && (targetCRS = op.getTargetCRS()) instanceof GeodeticCRS && sourceCRS.getCoordinateSystem() instanceof EllipsoidalCS && targetCRS.getCoordinateSystem() instanceof EllipsoidalCS) {
            boolean is2D;
            Matrix matrix = MathTransforms.getMatrix(op.getMathTransform());
            if (matrix == null) {
                MathTransform mt;
                MathTransformFactory mtFactory;
                if (!SubTypes.isSingleOperation(op) || !((mtFactory = this.factorySIS.getMathTransformFactory()) instanceof DefaultMathTransformFactory)) break;
                if (forward) {
                    sourceCRS = this.toGeodetic3D(sourceCRS, source3D);
                } else {
                    targetCRS = this.toGeodetic3D(targetCRS, target3D);
                }
                try {
                    mt = ((DefaultMathTransformFactory)mtFactory).createParameterizedTransform(((SingleOperation)op).getParameterValues(), ReferencingUtilities.createTransformContext(sourceCRS, targetCRS, null));
                }
                catch (InvalidGeodeticParameterException e) {
                    CoordinateOperationRegistry.log(e);
                    break;
                }
                operations.set(this.recreate(op, sourceCRS, targetCRS, mt, mtFactory.getLastMethodUsed()));
                return true;
            }
            int numRow = matrix.getNumRow();
            int numCol = matrix.getNumCol();
            boolean bl = is2D = numCol == 3 && numRow == 3;
            if (!is2D && !(forward ? numCol == 3 && numRow == 4 : numCol == 4 && numRow == 3)) break;
            if ((matrix = Matrices.resizeAffine(matrix, 4, 4)).isIdentity()) {
                operations.remove();
            } else {
                MathTransform mt = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
                operations.set(this.recreate(op, this.toGeodetic3D(sourceCRS, source3D), this.toGeodetic3D(targetCRS, target3D), mt, null));
            }
            if (is2D) continue;
            return true;
        }
        return false;
    }

    private CoordinateReferenceSystem toGeodetic3D(CoordinateReferenceSystem crs, CoordinateReferenceSystem candidate) throws FactoryException {
        assert (crs instanceof GeodeticCRS && crs.getCoordinateSystem() instanceof EllipsoidalCS) : crs;
        if (crs.getCoordinateSystem().getDimension() != 2) {
            return crs;
        }
        if (crs.getClass() == candidate.getClass() && candidate.getCoordinateSystem().getDimension() == 3 && Utilities.equalsIgnoreMetadata(((SingleCRS)crs).getDatum(), ((SingleCRS)candidate).getDatum())) {
            return candidate;
        }
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, ReferencingServices.getInstance().createCompoundCRS(this.factorySIS.getCRSFactory(), this.factorySIS.getCSFactory(), CoordinateOperationRegistry.derivedFrom(crs), crs, CommonCRS.Vertical.ELLIPSOIDAL.crs()));
    }

    private static Map<String, ?> derivedFrom(IdentifiedObject object) {
        return IdentifiedObjects.getProperties(object, "identifiers");
    }

    static Map<String, Object> properties(Identifier name) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        if (name == DATUM_SHIFT || name == ELLIPSOID_CHANGE) {
            properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{name == DATUM_SHIFT ? PositionalAccuracyConstant.DATUM_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED});
        }
        return properties;
    }

    final CoordinateOperation createFromMathTransform(Map<String, Object> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, ParameterValueGroup parameters, Class<? extends CoordinateOperation> type) throws FactoryException {
        CoordinateOperation operation;
        if (transform instanceof CoordinateOperation && Objects.equals((operation = (CoordinateOperation)((Object)transform)).getSourceCRS(), sourceCRS) && Objects.equals(operation.getTargetCRS(), targetCRS) && Objects.equals(operation.getMathTransform(), transform) && (method == null || !(operation instanceof SingleOperation) || Objects.equals(((SingleOperation)operation).getMethod(), method))) {
            return operation;
        }
        if (type == null) {
            Class clazz = type = properties.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        }
        if (method == null) {
            Matrix matrix = MathTransforms.getMatrix(transform);
            if (matrix != null) {
                method = Affine.getProvider(transform.getSourceDimensions(), transform.getTargetDimensions(), Matrices.isAffine(matrix));
            } else {
                ParameterDescriptorGroup descriptor = AbstractCoordinateOperation.getParameterDescriptors(transform);
                if (descriptor != null) {
                    ReferenceIdentifier name = descriptor.getName();
                    if (name != null) {
                        method = this.factorySIS.getOperationMethod(name.getCode());
                    }
                    if (method == null) {
                        method = this.factorySIS.createOperationMethod(properties, sourceCRS.getCoordinateSystem().getDimension(), targetCRS.getCoordinateSystem().getDimension(), descriptor);
                    }
                }
            }
        }
        if (parameters != null) {
            properties.put("parameters", parameters);
        }
        properties.put("operationType", type);
        if (Conversion.class.isAssignableFrom(type) && transform.isIdentity()) {
            JDK8.replace(properties, "name", AXIS_CHANGES, IDENTITY);
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, null, method, transform);
    }

    private static void log(FactoryException exception) {
        LogRecord record = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
        record.setLoggerName("org.apache.sis.referencing.operation");
        Logging.log(CoordinateOperationFinder.class, "createOperation", record);
    }
}

