/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.MismatchedDatumException;
import org.apache.sis.referencing.operation.SubTypes;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@XmlType(name="ConversionType")
@XmlRootElement(name="Conversion")
public class DefaultConversion
extends AbstractSingleOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
    }

    public DefaultConversion(Map<String, ?> properties, OperationMethod method, MathTransform transform, ParameterValueGroup parameters) {
        super(properties, method);
        if (transform != null) {
            this.transform = transform;
            DefaultConversion.checkDimensions(method, 0, transform, properties);
        } else if (parameters == null) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)185));
        }
        if (parameters != null) {
            this.parameters = Parameters.unmodifiable(parameters);
        }
        this.checkDimensions(properties);
    }

    DefaultConversion(Conversion definition, CoordinateReferenceSystem source, CoordinateReferenceSystem target, MathTransformFactory factory, OperationMethod[] actual) throws FactoryException {
        super(definition);
        int interpDim = ReferencingUtilities.getDimension(super.getInterpolationCRS());
        if (this.transform == null) {
            if (this.parameters == null) {
                throw new IllegalArgumentException(Errors.format((short)185));
            }
            if (factory instanceof DefaultMathTransformFactory) {
                DefaultMathTransformFactory.Context context;
                if (target instanceof GeneralDerivedCRS) {
                    context = ReferencingUtilities.createTransformContext(source, null, null);
                    context.setTarget(target.getCoordinateSystem());
                } else {
                    context = ReferencingUtilities.createTransformContext(source, target, null);
                }
                this.transform = ((DefaultMathTransformFactory)factory).createParameterizedTransform(this.parameters, context);
                this.parameters = Parameters.unmodifiable(context.getCompletedParameters());
            } else {
                this.transform = factory.createBaseToDerived(source, this.parameters, target.getCoordinateSystem());
            }
            actual[0] = factory.getLastMethodUsed();
        } else if (this.sourceCRS == null && this.targetCRS == null && factory instanceof DefaultMathTransformFactory) {
            DefaultMathTransformFactory.Context context = new DefaultMathTransformFactory.Context();
            context.setSource(source.getCoordinateSystem());
            context.setTarget(target.getCoordinateSystem());
            this.transform = ((DefaultMathTransformFactory)factory).swapAndScaleAxes(this.transform, context);
        } else {
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, source, this.sourceCRS, interpDim, true, factory);
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, this.targetCRS, target, interpDim, false, factory);
            interpDim = 0;
        }
        if (interpDim != 0) {
            this.transform = factory.createPassThroughTransform(interpDim, this.transform, 0);
        }
        this.sourceCRS = source;
        this.targetCRS = target;
    }

    protected DefaultConversion(Conversion operation) {
        super(operation);
    }

    public static DefaultConversion castOrCopy(Conversion object) {
        return SubTypes.forConversion(object);
    }

    public Class<? extends Conversion> getInterface() {
        return Conversion.class;
    }

    public <T extends Conversion> T specialize(Class<T> baseType, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransformFactory factory) throws FactoryException {
        ArgumentChecks.ensureNonNull("baseType", baseType);
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        ArgumentChecks.ensureNonNull("factory", factory);
        DefaultConversion.ensureCompatibleDatum("sourceCRS", super.getSourceCRS(), sourceCRS);
        if (!(targetCRS instanceof GeneralDerivedCRS)) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", super.getTargetCRS(), targetCRS);
        } else if (super.getTargetCRS() != null) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", sourceCRS, super.getTargetCRS());
        }
        return SubTypes.create(baseType, this, sourceCRS, targetCRS, factory);
    }

    private static void ensureCompatibleDatum(String param, CoordinateReferenceSystem expected, CoordinateReferenceSystem actual) {
        Datum datum;
        if (expected instanceof SingleCRS && actual instanceof SingleCRS && (datum = ((SingleCRS)expected).getDatum()) != null && !Utilities.equalsIgnoreMetadata(datum, ((SingleCRS)actual).getDatum())) {
            throw new MismatchedDatumException(Errors.format((short)186, datum.getName(), param));
        }
    }

    private static MathTransform swapAndScaleAxes(MathTransform transform, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, int interpDim, boolean isSource, MathTransformFactory factory) throws FactoryException {
        if (sourceCRS != null && targetCRS != null && sourceCRS != targetCRS) {
            try {
                Matrix m = CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
                if (!m.isIdentity()) {
                    if (interpDim != 0) {
                        m = Matrices.createPassThrough(interpDim, m, 0);
                    }
                    MathTransform s = factory.createAffineTransform(m);
                    transform = factory.createConcatenatedTransform(isSource ? s : transform, isSource ? transform : s);
                }
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException(Errors.format((short)31, isSource ? "sourceCRS" : "targetCRS", (isSource ? sourceCRS : targetCRS).getName()), e);
            }
        }
        return transform;
    }

    private DefaultConversion() {
    }
}

