/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.MergedProperties;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultConicProjection;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCylindricalProjection;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPlanarProjection;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultCoordinateOperationFactory
extends AbstractFactory
implements CoordinateOperationFactory {
    static final boolean USE_EPSG_FACTORY = true;
    private final Map<String, ?> defaultProperties;
    private volatile CRSFactory crsFactory;
    private volatile CSFactory csFactory;
    private volatile MathTransformFactory mtFactory;
    private final WeakHashSet<IdentifiedObject> pool;
    final Cache<CRSPair, CoordinateOperation> cache;

    public DefaultCoordinateOperationFactory() {
        this(null, null);
    }

    public DefaultCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory factory) {
        if (properties == null || properties.isEmpty()) {
            properties = Collections.emptyMap();
        } else {
            String key = null;
            Object value = null;
            properties = new HashMap(properties);
            try {
                key = "crsFactory";
                value = properties.remove("crsFactory");
                this.crsFactory = (CRSFactory)value;
                key = "csFactory";
                value = properties.remove("csFactory");
                this.csFactory = (CSFactory)value;
                key = "mtFactory";
                value = properties.remove("mtFactory");
                this.mtFactory = (MathTransformFactory)value;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(Errors.getResources(properties).getString((short)40, key, Classes.getClass(value)));
            }
            properties = CollectionsExt.compact(properties);
        }
        this.defaultProperties = properties;
        if (factory != null) {
            this.mtFactory = factory;
        }
        this.pool = new WeakHashSet<IdentifiedObject>(IdentifiedObject.class);
        this.cache = new Cache(12, 50L, true);
    }

    protected Map<String, ?> complete(Map<String, ?> properties) {
        ArgumentChecks.ensureNonNull("properties", properties);
        return new MergedProperties(properties, this.defaultProperties);
    }

    final CRSFactory getCRSFactory() {
        CRSFactory factory = this.crsFactory;
        if (factory == null) {
            this.crsFactory = factory = DefaultFactories.forBuildin(CRSFactory.class);
        }
        return factory;
    }

    final CSFactory getCSFactory() {
        CSFactory factory = this.csFactory;
        if (factory == null) {
            this.csFactory = factory = DefaultFactories.forBuildin(CSFactory.class);
        }
        return factory;
    }

    final MathTransformFactory getMathTransformFactory() {
        MathTransformFactory factory = this.mtFactory;
        if (factory == null) {
            this.mtFactory = factory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return factory;
    }

    final DefaultMathTransformFactory getDefaultMathTransformFactory() {
        MathTransformFactory factory = this.getMathTransformFactory();
        if (factory instanceof DefaultMathTransformFactory) {
            return (DefaultMathTransformFactory)factory;
        }
        return DefaultFactories.forBuildin(MathTransformFactory.class, DefaultMathTransformFactory.class);
    }

    public OperationMethod getOperationMethod(String name) throws FactoryException {
        name = CharSequences.trimWhitespaces(name);
        ArgumentChecks.ensureNonEmpty("name", name);
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).getOperationMethod(name);
        }
        OperationMethod method = ReferencingServices.getInstance().getOperationMethod(mtFactory.getAvailableMethods(SingleOperation.class), name);
        if (method != null) {
            return method;
        }
        throw new NoSuchIdentifierException(Errors.getResources(this.defaultProperties).getString((short)179, name), name);
    }

    public OperationMethod createOperationMethod(Map<String, ?> properties, Integer sourceDimensions, Integer targetDimensions, ParameterDescriptorGroup parameters) throws FactoryException {
        DefaultOperationMethod method;
        try {
            method = new DefaultOperationMethod(properties, sourceDimensions, targetDimensions, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.pool.unique(method);
    }

    @Override
    public Conversion createDefiningConversion(Map<String, ?> properties, OperationMethod method, ParameterValueGroup parameters) throws FactoryException {
        DefaultConversion conversion;
        try {
            conversion = new DefaultConversion(properties, method, null, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return conversion;
    }

    private static boolean isConversion(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        int i;
        List<SingleCRS> components = CRS.getSingleComponents(sourceCRS);
        int n = components.size();
        Datum[] datum = new Datum[n];
        for (i = 0; i < n; ++i) {
            datum[i] = components.get(i).getDatum();
        }
        components = CRS.getSingleComponents(targetCRS);
        i = components.size();
        block1: while (--i >= 0) {
            Datum d = components.get(i).getDatum();
            int j = n;
            while (--j >= 0) {
                if (!Utilities.equalsIgnoreMetadata(d, datum[j])) continue;
                System.arraycopy(datum, j + 1, datum, j, --n - j);
                continue block1;
            }
            return false;
        }
        return true;
    }

    public SingleOperation createSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) throws FactoryException {
        AbstractSingleOperation op;
        Class<? extends SingleOperation> c;
        Class baseType;
        ArgumentChecks.ensureNonNull("sourceCRS", sourceCRS);
        ArgumentChecks.ensureNonNull("targetCRS", targetCRS);
        ArgumentChecks.ensureNonNull("method", method);
        if (transform == null) {
            ParameterValueGroup parameters = Containers.property(properties, "parameters", ParameterValueGroup.class);
            if (parameters == null) {
                throw new NullArgumentException(Errors.format((short)95, "transform"));
            }
            transform = this.mtFactory.createBaseToDerived(sourceCRS, parameters, targetCRS.getCoordinateSystem());
        }
        if ((baseType = Containers.property(properties, "operationType", Class.class)) == null) {
            baseType = SingleOperation.class;
        }
        if (method instanceof DefaultOperationMethod && (c = ((DefaultOperationMethod)method).getOperationType()) != null) {
            if (baseType.isAssignableFrom(c)) {
                baseType = c;
            } else if (!c.isAssignableFrom(baseType)) {
                throw new IllegalArgumentException(Errors.format((short)45, "operationType"));
            }
        }
        if (baseType == SingleOperation.class) {
            baseType = DefaultCoordinateOperationFactory.isConversion(sourceCRS, targetCRS) ? (interpolationCRS == null && sourceCRS instanceof GeographicCRS && targetCRS instanceof ProjectedCRS ? Projection.class : Conversion.class) : Transformation.class;
        }
        if (Transformation.class.isAssignableFrom(baseType)) {
            op = new DefaultTransformation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        } else if (Projection.class.isAssignableFrom(baseType)) {
            ArgumentChecks.ensureCanCast("sourceCRS", GeographicCRS.class, sourceCRS);
            ArgumentChecks.ensureCanCast("targetCRS", ProjectedCRS.class, targetCRS);
            if (interpolationCRS != null) {
                throw new IllegalArgumentException(Errors.format((short)26, "interpolationCRS", baseType));
            }
            GeographicCRS baseCRS = (GeographicCRS)sourceCRS;
            ProjectedCRS crs = (ProjectedCRS)targetCRS;
            op = CylindricalProjection.class.isAssignableFrom(baseType) ? new DefaultCylindricalProjection(properties, baseCRS, crs, method, transform) : (ConicProjection.class.isAssignableFrom(baseType) ? new DefaultConicProjection(properties, baseCRS, crs, method, transform) : (PlanarProjection.class.isAssignableFrom(baseType) ? new DefaultPlanarProjection(properties, baseCRS, crs, method, transform) : new DefaultProjection(properties, baseCRS, crs, method, transform)));
        } else {
            op = Conversion.class.isAssignableFrom(baseType) ? new DefaultConversion(properties, sourceCRS, targetCRS, interpolationCRS, method, transform) : new AbstractSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        }
        if (!baseType.isInstance(op)) {
            throw new FactoryException(Errors.format((short)215, baseType, op.getName()));
        }
        return this.pool.unique(op);
    }

    @Override
    public CoordinateOperation createConcatenatedOperation(Map<String, ?> properties, CoordinateOperation ... operations) throws FactoryException {
        DefaultConcatenatedOperation op;
        if (operations != null && operations.length == 1) {
            return operations[0];
        }
        try {
            op = new DefaultConcatenatedOperation(properties, operations, this.getMathTransformFactory());
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.pool.unique(op);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperationContext context) throws OperationNotFoundException, FactoryException {
        Cache.Handler<CoordinateOperation> handler;
        CoordinateOperation op;
        if (context == null) {
            CRSPair key = new CRSPair(sourceCRS, targetCRS);
            op = this.cache.peek(key);
            if (op != null) {
                return op;
            }
            handler = this.cache.lock(key);
        } else {
            handler = null;
            op = null;
        }
        try {
            if (handler == null || (op = (CoordinateOperation)handler.peek()) == null) {
                CRSAuthorityFactory registry = CRS.getAuthorityFactory("EPSG");
                op = new CoordinateOperationFinder(registry instanceof CoordinateOperationAuthorityFactory ? (CoordinateOperationAuthorityFactory)((Object)registry) : null, this, context).createOperation(sourceCRS, targetCRS);
            }
        }
        finally {
            if (handler != null) {
                handler.putAndUnlock(op);
            }
        }
        return op;
    }

    @Override
    @Deprecated
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws FactoryException {
        ArgumentChecks.ensureNonNull("method", method);
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }
}

