/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.DefaultFormula;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;

@XmlType(name="OperationMethodType", propOrder={"formulaCitation", "formulaDescription", "sourceDimensions", "targetDimensions", "descriptors"})
@XmlRootElement(name="OperationMethod")
public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = 2870579345991143357L;
    private Formula formula;
    private Integer sourceDimensions;
    private Integer targetDimensions;
    private ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(Map<String, ?> properties, Integer sourceDimensions, Integer targetDimensions, ParameterDescriptorGroup parameters) {
        super(properties);
        if (sourceDimensions != null) {
            ArgumentChecks.ensurePositive("sourceDimensions", sourceDimensions);
        }
        if (targetDimensions != null) {
            ArgumentChecks.ensurePositive("targetDimensions", targetDimensions);
        }
        ArgumentChecks.ensureNonNull("parameters", parameters);
        Object value = properties.get("formula");
        if (value == null || value instanceof Formula) {
            this.formula = (Formula)value;
        } else if (value instanceof Citation) {
            this.formula = new DefaultFormula((Citation)value);
        } else if (value instanceof CharSequence) {
            this.formula = new DefaultFormula((CharSequence)value);
        } else {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)40, "formula", value.getClass()));
        }
        this.parameters = parameters;
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
    }

    public DefaultOperationMethod(MathTransform transform) {
        super(DefaultOperationMethod.getProperties(transform));
        this.sourceDimensions = transform.getSourceDimensions();
        this.targetDimensions = transform.getTargetDimensions();
        this.parameters = transform instanceof Parameterized ? ((Parameterized)((Object)transform)).getParameterDescriptors() : null;
        this.formula = null;
    }

    private static Map<String, ?> getProperties(MathTransform transform) {
        ParameterDescriptorGroup parameters;
        ArgumentChecks.ensureNonNull("transform", transform);
        if (transform instanceof Parameterized && (parameters = ((Parameterized)((Object)transform)).getParameterDescriptors()) != null) {
            return DefaultOperationMethod.getProperties(parameters, null);
        }
        return Collections.singletonMap("name", NilReferencingObject.UNNAMED);
    }

    private static Map<String, Object> getProperties(IdentifiedObject info, Citation authority) {
        HashMap<String, Object> properties = new HashMap<String, Object>(IdentifiedObjects.getProperties(info, new String[0]));
        properties.put("name", new NamedIdentifier(authority, info.getName().getCode()));
        properties.remove("identifiers");
        return properties;
    }

    protected DefaultOperationMethod(OperationMethod method) {
        super(method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = method.getSourceDimensions();
        this.targetDimensions = method.getTargetDimensions();
    }

    public static DefaultOperationMethod castOrCopy(OperationMethod object) {
        return object == null || object instanceof DefaultOperationMethod ? (DefaultOperationMethod)object : new DefaultOperationMethod(object);
    }

    private DefaultOperationMethod(OperationMethod method, Integer sourceDimensions, Integer targetDimensions) {
        super(method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
        this.sourceDimensions = sourceDimensions;
        this.targetDimensions = targetDimensions;
    }

    private static OperationMethod redimension(OperationMethod method, int sourceDimensions, Integer methodSource, int targetDimensions, Integer methodTarget) {
        boolean targetValids;
        boolean sourceValids = methodSource != null && methodSource == sourceDimensions;
        boolean bl = targetValids = methodTarget != null && methodTarget == targetDimensions;
        if (sourceValids && targetValids) {
            return method;
        }
        boolean bl2 = methodSource == null;
        boolean bl3 = methodTarget == null;
        ArgumentChecks.ensurePositive("sourceDimensions", sourceDimensions);
        ArgumentChecks.ensurePositive("targetDimensions", targetDimensions);
        if (!(sourceValids |= bl2) || !(targetValids |= bl3)) {
            throw new IllegalArgumentException(Errors.format((short)180, method.getName().getCode(), sourceDimensions, targetDimensions));
        }
        return new DefaultOperationMethod(method, sourceDimensions, targetDimensions);
    }

    public static OperationMethod redimension(OperationMethod method, int sourceDimensions, int targetDimensions) {
        if (method != null) {
            if (method instanceof DefaultOperationMethod) {
                return ((DefaultOperationMethod)method).redimension(sourceDimensions, targetDimensions);
            }
            method = DefaultOperationMethod.redimension(method, sourceDimensions, method.getSourceDimensions(), targetDimensions, method.getTargetDimensions());
        }
        return method;
    }

    public OperationMethod redimension(int sourceDimensions, int targetDimensions) {
        return DefaultOperationMethod.redimension(this, sourceDimensions, this.sourceDimensions, targetDimensions, this.targetDimensions);
    }

    public Class<? extends OperationMethod> getInterface() {
        return OperationMethod.class;
    }

    public Class<? extends SingleOperation> getOperationType() {
        return SingleOperation.class;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    @Override
    @XmlElement(name="sourceDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getSourceDimensions() {
        return this.sourceDimensions;
    }

    @Override
    @XmlElement(name="targetDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getTargetDimensions() {
        return this.targetDimensions;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            OperationMethod that;
            switch (mode) {
                case STRICT: {
                    DefaultOperationMethod that2 = (DefaultOperationMethod)object;
                    return Objects.equals(this.formula, that2.formula) && Objects.equals(this.sourceDimensions, that2.sourceDimensions) && Objects.equals(this.targetDimensions, that2.targetDimensions) && Objects.equals(this.parameters, that2.parameters);
                }
                case BY_CONTRACT: {
                    if (Objects.equals(this.getFormula(), ((OperationMethod)object).getFormula())) break;
                    return false;
                }
                default: {
                    that = (OperationMethod)object;
                    Boolean match = Citations.hasCommonIdentifier(this.getIdentifiers(), that.getIdentifiers());
                    if (!(match != null ? match == false : !this.isHeuristicMatchForName(that.getName().getCode()) && !IdentifiedObjects.isHeuristicMatchForName(that, this.getName().getCode()))) break;
                    return false;
                }
            }
            that = (OperationMethod)object;
            return Objects.equals(this.getSourceDimensions(), that.getSourceDimensions()) && Objects.equals(this.getTargetDimensions(), that.getTargetDimensions()) && Utilities.deepEquals(this.getParameters(), that.getParameters(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.sourceDimensions, this.targetDimensions, this.parameters);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1 = formatter.getConvention().majorVersion() == 1;
        Citation authority = formatter.getNameAuthority();
        String name = IdentifiedObjects.getName(this, authority);
        ElementKind kind = ElementKind.METHOD;
        if (name == null) {
            Conversion conversion;
            FormattableObject parent = formatter.getEnclosingElement(isWKT1 ? 1 : 2);
            if (parent instanceof GeneralDerivedCRS && (conversion = ((GeneralDerivedCRS)((Object)parent)).getConversionFromBase()) != null) {
                ParameterDescriptorGroup descriptor = conversion instanceof Parameterized ? ((Parameterized)((Object)conversion)).getParameterDescriptors() : conversion.getParameterValues().getDescriptor();
                name = IdentifiedObjects.getName(descriptor, authority);
            }
            if (name == null && (name = IdentifiedObjects.getName(this, null)) == null) {
                name = Vocabulary.getResources(formatter.getLocale()).getString((short)65);
                kind = ElementKind.NAME;
            }
        }
        formatter.append(name, kind);
        if (isWKT1) {
            Class<? extends SingleOperation> type = this.getOperationType();
            if (Projection.class.isAssignableFrom(type) || type.isAssignableFrom(Projection.class)) {
                return "Projection";
            }
            formatter.setInvalidWKT(this, null);
        }
        return "Method";
    }

    private DefaultOperationMethod() {
        super(NilReferencingObject.INSTANCE);
    }

    private void setSourceDimensions(Integer value) {
        if (this.sourceDimensions == null) {
            this.sourceDimensions = value;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setSourceDimensions", "sourceDimensions");
        }
    }

    private void setTargetDimensions(Integer value) {
        if (this.targetDimensions == null) {
            this.targetDimensions = value;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setTargetDimensions", "targetDimensions");
        }
    }

    @XmlElement(name="formulaCitation")
    private Citation getFormulaCitation() {
        Formula formula = this.getFormula();
        return formula != null ? formula.getCitation() : null;
    }

    @XmlElement(name="formula")
    private String getFormulaDescription() {
        Formula formula = this.getFormula();
        return formula != null ? StringAdapter.toString(formula.getFormula()) : null;
    }

    private void setFormulaCitation(Citation citation) {
        if (this.formula == null || this.formula.getCitation() == null) {
            this.formula = this.formula == null ? new DefaultFormula(citation) : new DefaultFormula(this.formula.getFormula(), citation);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setFormulaCitation", "formulaCitation");
        }
    }

    private void setFormulaDescription(String description) {
        if (this.formula == null || this.formula.getFormula() == null) {
            this.formula = this.formula == null ? new DefaultFormula(description) : new DefaultFormula(new SimpleInternationalString(description), this.formula.getCitation());
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setFormulaDescription", "formula");
        }
    }

    @XmlElement(name="parameter")
    private GeneralParameterDescriptor[] getDescriptors() {
        List<GeneralParameterDescriptor> descriptors;
        if (this.parameters != null && (descriptors = this.parameters.descriptors()) != null) {
            return CC_OperationMethod.filterImplicit(descriptors.toArray(new GeneralParameterDescriptor[descriptors.size()]));
        }
        return null;
    }

    private void setDescriptors(GeneralParameterDescriptor[] descriptors) {
        if (this.parameters == null) {
            this.parameters = CC_OperationMethod.group(super.getName(), descriptors);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setDescriptors", "parameter");
        }
    }

    final void updateDescriptors(GeneralParameterDescriptor[] descriptors) {
        ParameterDescriptorGroup previous = this.parameters;
        this.parameters = new DefaultParameterDescriptorGroup(IdentifiedObjects.getProperties(previous, new String[0]), previous.getMinimumOccurs(), previous.getMaximumOccurs(), descriptors);
    }
}

