/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;

@XmlType(name="PassThroughOperationType", propOrder={"indices", "operation"})
@XmlRootElement(name="PassThroughOperation")
public class DefaultPassThroughOperation
extends AbstractCoordinateOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    private SingleOperation operation;

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, SingleOperation operation, int firstAffectedOrdinate, int numTrailingOrdinates) {
        super(properties, sourceCRS, targetCRS, null, PassThroughTransform.create(firstAffectedOrdinate, operation.getMathTransform(), numTrailingOrdinates));
        ArgumentChecks.ensureNonNull("operation", operation);
        this.operation = operation;
    }

    protected DefaultPassThroughOperation(PassThroughOperation operation) {
        super(operation);
        this.operation = operation.getOperation();
    }

    public static DefaultPassThroughOperation castOrCopy(PassThroughOperation object) {
        return object == null || object instanceof DefaultPassThroughOperation ? (DefaultPassThroughOperation)object : new DefaultPassThroughOperation(object);
    }

    public Class<? extends PassThroughOperation> getInterface() {
        return PassThroughOperation.class;
    }

    @Override
    @Deprecated
    public OperationMethod getMethod() {
        return null;
    }

    @Override
    @Deprecated
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @Override
    @XmlElement(name="coordOperation", required=true)
    public SingleOperation getOperation() {
        return this.operation;
    }

    @Override
    public int[] getModifiedCoordinates() {
        MathTransform transform = super.getMathTransform();
        if (transform instanceof PassThroughTransform) {
            return ((PassThroughTransform)transform).getModifiedCoordinates();
        }
        CoordinateReferenceSystem sourceCRS = super.getSourceCRS();
        if (sourceCRS instanceof CompoundCRS) {
            int firstAffectedOrdinate = 0;
            CoordinateReferenceSystem search = this.operation.getSourceCRS();
            for (CoordinateReferenceSystem c : ((CompoundCRS)sourceCRS).getComponents()) {
                int dim = ReferencingUtilities.getDimension(c);
                if (c == search) {
                    int[] indices = new int[dim];
                    for (int i = 0; i < dim; ++i) {
                        indices[i] = firstAffectedOrdinate + i;
                    }
                    return indices;
                }
                firstAffectedOrdinate += dim;
            }
        }
        throw new UnsupportedImplementationException(transform.getClass());
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                return Objects.equals(this.operation, ((DefaultPassThroughOperation)object).operation);
            }
            return Utilities.deepEquals(this.getOperation(), ((PassThroughOperation)object).getOperation(), mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.operation.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                for (int i : DefaultPassThroughOperation.this.getModifiedCoordinates()) {
                    formatter.append(i);
                }
                return "ModifiedCoordinates";
            }
        });
        formatter.newLine();
        formatter.append(DefaultPassThroughOperation.castOrCopy(this.getOperation()));
        formatter.setInvalidWKT(this, null);
        return "PassThroughOperation";
    }

    private DefaultPassThroughOperation() {
    }

    private void setOperation(SingleOperation op) {
        if (this.operation == null) {
            this.operation = op;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultPassThroughOperation.class, "setOperation", "coordOperation");
        }
    }

    @XmlElement(name="modifiedCoordinate", required=true)
    private int[] getIndices() {
        int[] indices = this.getModifiedCoordinates();
        int i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    private void setIndices(int[] ordinates) {
        String missing = "sourceCRS";
        CoordinateReferenceSystem sourceCRS = super.getSourceCRS();
        if (sourceCRS != null) {
            missing = "modifiedCoordinate";
            if (ordinates != null && ordinates.length != 0) {
                missing = "coordOperation";
                if (this.operation != null) {
                    for (int i = 1; i < ordinates.length; ++i) {
                        int previous = ordinates[i - 1];
                        if (previous >= 1 && ordinates[i] == previous + 1) continue;
                        throw new IllegalArgumentException(Errors.format((short)167, missing, Arrays.toString(ordinates)));
                    }
                    this.transform = PassThroughTransform.create(ordinates[0] - 1, this.operation.getMathTransform(), ReferencingUtilities.getDimension(sourceCRS) - ordinates[ordinates.length - 1]);
                    return;
                }
            }
        }
        throw new IllegalStateException(Errors.format((short)189, missing, "PassThroughOperation"));
    }
}

