/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.SignReversalComment;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.InternationalString;

@XmlTransient
final class InverseOperationMethod
extends DefaultOperationMethod {
    private static final long serialVersionUID = 6395008927817202180L;
    private final OperationMethod inverse;

    private InverseOperationMethod(Map<String, ?> properties, OperationMethod method) {
        super(properties, method.getTargetDimensions(), method.getSourceDimensions(), method.getParameters());
        this.inverse = method;
    }

    private static boolean isInvertible(OperationMethod method) {
        return method instanceof AbstractProvider && ((AbstractProvider)method).isInvertible();
    }

    static OperationMethod create(OperationMethod method) {
        if (method instanceof InverseOperationMethod) {
            return ((InverseOperationMethod)method).inverse;
        }
        if (!InverseOperationMethod.isInvertible(method)) {
            GeneralParameterDescriptor descriptor;
            boolean useSameParameters = false;
            Iterator<GeneralParameterDescriptor> iterator = method.getParameters().descriptors().iterator();
            while (iterator.hasNext() && (useSameParameters = (descriptor = iterator.next()).getRemarks() instanceof SignReversalComment)) {
            }
            if (!useSameParameters) {
                ReferenceIdentifier name = method.getName();
                name = new ImmutableIdentifier(null, null, "Inverse of " + name.getCode());
                HashMap<String, Object> properties = new HashMap<String, Object>(6);
                properties.put("name", name);
                properties.put("formula", method.getFormula());
                properties.put("remarks", method.getRemarks());
                if (method instanceof Deprecable) {
                    properties.put("deprecated", ((Deprecable)((Object)method)).isDeprecated());
                }
                return new InverseOperationMethod(properties, method);
            }
        }
        return method;
    }

    static void putMetadata(SingleOperation source, Map<String, Object> target) {
        target.put("domainOfValidity", source.getDomainOfValidity());
        Collection<PositionalAccuracy> accuracy = source.getCoordinateOperationAccuracy();
        if (!Containers.isNullOrEmpty(accuracy)) {
            target.put("coordinateOperationAccuracy", accuracy.toArray(new PositionalAccuracy[accuracy.size()]));
        }
    }

    static void putParameters(SingleOperation source, Map<String, Object> target) {
        boolean isInvertible = InverseOperationMethod.isInvertible(source.getMethod());
        ParameterValueGroup parameters = source.getParameterValues();
        ParameterValueGroup copy = parameters.getDescriptor().createValue();
        for (GeneralParameterValue gp : parameters.values()) {
            ParameterDescriptor descriptor;
            InternationalString remarks;
            ParameterValue src;
            Object value;
            if (gp instanceof ParameterValue && (value = (src = (ParameterValue)gp).getValue()) instanceof Number && (remarks = (descriptor = src.getDescriptor()).getRemarks()) != SignReversalComment.SAME) {
                boolean isOpposite;
                boolean bl = isOpposite = remarks == SignReversalComment.OPPOSITE;
                if (!isOpposite) {
                    if (!isInvertible) {
                        return;
                    }
                    Comparable minimum = descriptor.getMinimumValue();
                    boolean bl2 = isOpposite = minimum == null || minimum instanceof Number && ((Number)((Object)minimum)).doubleValue() < 0.0;
                }
                if (isOpposite) {
                    ParameterValue<?> tgt = copy.parameter(descriptor.getName().getCode());
                    Unit<?> unit = src.getUnit();
                    if (unit != null) {
                        tgt.setValue(-src.doubleValue(), unit);
                        continue;
                    }
                    if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
                        tgt.setValue(-src.intValue());
                        continue;
                    }
                    tgt.setValue(-src.doubleValue());
                    continue;
                }
            }
            copy.values().add(gp);
        }
        target.put("parameters", copy);
    }
}

