/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Line;
import org.apache.sis.math.Plane;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;

public class LinearTransformBuilder {
    private double[][] sources;
    private double[][] targets;
    private LinearTransform transform;
    private double[] correlation;

    private static double[][] toArrays(DirectPosition[] points, int dimension) {
        int length = points.length;
        double[][] ordinates = new double[dimension][length];
        for (int j = 0; j < length; ++j) {
            DirectPosition p = points[j];
            int d = p.getDimension();
            if (d != dimension) {
                throw new MismatchedDimensionException(Errors.format((short)59, "points[" + j + ']', dimension, d));
            }
            for (int i = 0; i < dimension; ++i) {
                ordinates[i][j] = p.getOrdinate(i);
            }
        }
        return ordinates;
    }

    public void setSourcePoints(DirectPosition ... points) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("points", points);
        this.sources = points.length != 0 ? LinearTransformBuilder.toArrays(points, points[0].getDimension() == 1 ? 1 : 2) : (double[][])null;
        this.transform = null;
        this.correlation = null;
    }

    public void setTargetPoints(DirectPosition ... points) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("points", points);
        this.targets = points.length != 0 ? LinearTransformBuilder.toArrays(points, points[0].getDimension()) : (double[][])null;
        this.transform = null;
        this.correlation = null;
    }

    public LinearTransform create() {
        if (this.transform == null) {
            double[][] sources = this.sources;
            double[][] targets = this.targets;
            if (sources == null || targets == null) {
                throw new IllegalStateException(Errors.format((short)64, sources == null ? "sources" : "targets"));
            }
            int sourceDim = sources.length;
            int targetDim = targets.length;
            this.correlation = new double[targetDim];
            MatrixSIS matrix = Matrices.createZero(targetDim + 1, sourceDim + 1);
            matrix.setElement(targetDim, sourceDim, 1.0);
            switch (sourceDim) {
                case 1: {
                    Line line = new Line();
                    for (int j = 0; j < targets.length; ++j) {
                        this.correlation[j] = line.fit(sources[0], targets[j]);
                        matrix.setElement(j, 0, line.slope());
                        matrix.setElement(j, 1, line.y0());
                    }
                    break;
                }
                case 2: {
                    Plane plan = new Plane();
                    for (int j = 0; j < targets.length; ++j) {
                        this.correlation[j] = plan.fit(sources[0], sources[1], targets[j]);
                        matrix.setElement(j, 0, plan.slopeX());
                        matrix.setElement(j, 1, plan.slopeY());
                        matrix.setElement(j, 2, plan.z0());
                    }
                    break;
                }
                default: {
                    throw new AssertionError(sourceDim);
                }
            }
            this.transform = MathTransforms.linear(matrix);
        }
        return this.transform;
    }

    public double[] correlation() {
        return this.correlation != null ? (double[])this.correlation.clone() : null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append('[');
        if (this.sources != null) {
            buffer.append(this.sources[0].length).append(" points");
        }
        buffer.append(']');
        if (this.transform != null) {
            String lineSeparator = JDK7.lineSeparator();
            buffer.append(':').append(lineSeparator);
            TableAppender table = new TableAppender(buffer, " ");
            table.setMultiLinesCells(true);
            table.append(Matrices.toString(this.transform.getMatrix()));
            table.nextColumn();
            table.append(lineSeparator);
            table.append("  ");
            table.append(Vocabulary.format((short)83));
            table.append(" =");
            table.nextColumn();
            table.append(Matrices.create(this.correlation.length, 1, this.correlation).toString());
            try {
                table.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return buffer.toString();
    }
}

