/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.referencing.operation.matrix.UnmodifiableMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public final class Matrices
extends Static {
    private static final int SPACING = 2;

    private Matrices() {
    }

    public static MatrixSIS createIdentity(int size) {
        switch (size) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(size, size, true, 1);
    }

    public static MatrixSIS createDiagonal(int numRow, int numCol) {
        if (numRow == numCol) {
            return Matrices.createIdentity(numRow);
        }
        return new NonSquareMatrix(numRow, numCol, true, 1);
    }

    public static MatrixSIS createZero(int numRow, int numCol) {
        if (numRow == numCol) {
            switch (numRow) {
                case 1: {
                    return new Matrix1(false);
                }
                case 2: {
                    return new Matrix2(false);
                }
                case 3: {
                    return new Matrix3(false);
                }
                case 4: {
                    return new Matrix4(false);
                }
            }
            return new GeneralMatrix(numRow, numCol, false, 1);
        }
        return new NonSquareMatrix(numRow, numCol, false, 1);
    }

    static MatrixSIS createZero(int numRow, int numCol, boolean precision) {
        return precision ? GeneralMatrix.createExtendedPrecision(numRow, numCol, false) : Matrices.createZero(numRow, numCol);
    }

    public static MatrixSIS create(int numRow, int numCol, double[] elements) {
        if (numRow == numCol) {
            switch (numRow) {
                case 1: {
                    return new Matrix1(elements);
                }
                case 2: {
                    return new Matrix2(elements);
                }
                case 3: {
                    return new Matrix3(elements);
                }
                case 4: {
                    return new Matrix4(elements);
                }
            }
            return new GeneralMatrix(numRow, numCol, elements);
        }
        return new NonSquareMatrix(numRow, numCol, elements);
    }

    public static MatrixSIS create(int numRow, int numCol, Number[] elements) {
        ArgumentChecks.ensureNonNull("elements", elements);
        if (elements == ExtendedPrecisionMatrix.IDENTITY) {
            return GeneralMatrix.createExtendedPrecision(numRow, numCol, true);
        }
        GeneralMatrix matrix = GeneralMatrix.createExtendedPrecision(numRow, numCol, false);
        if (matrix.setElements(elements)) {
            return matrix;
        }
        return Matrices.create(numRow, numCol, matrix.getElements());
    }

    private static MatrixSIS createTransform(Envelope srcEnvelope, AxisDirection[] srcAxes, Envelope dstEnvelope, AxisDirection[] dstAxes, boolean useEnvelopes) {
        DirectPosition srcOppositeCorner;
        DirectPosition srcCorner;
        DirectPosition dstCorner;
        if (useEnvelopes) {
            dstCorner = dstEnvelope.getLowerCorner();
            srcCorner = srcEnvelope.getLowerCorner();
            srcOppositeCorner = srcEnvelope.getUpperCorner();
        } else {
            srcOppositeCorner = null;
            srcCorner = null;
            dstCorner = null;
        }
        MatrixSIS matrix = Matrices.createZero(dstAxes.length + 1, srcAxes.length + 1);
        for (int dstIndex = 0; dstIndex < dstAxes.length; ++dstIndex) {
            boolean hasFound = false;
            AxisDirection dstDir = dstAxes[dstIndex];
            AxisDirection search = AxisDirections.absolute(dstDir);
            for (int srcIndex = 0; srcIndex < srcAxes.length; ++srcIndex) {
                AxisDirection srcDir = srcAxes[srcIndex];
                if (!search.equals(AxisDirections.absolute(srcDir))) continue;
                if (hasFound) {
                    throw new IllegalArgumentException(Errors.format((short)14, srcDir, dstDir));
                }
                hasFound = true;
                boolean same = srcDir.equals(dstDir);
                double scale = same ? 1.0 : -1.0;
                double translate = 0.0;
                if (useEnvelopes) {
                    translate = dstCorner.getOrdinate(dstIndex);
                    translate -= (scale *= dstEnvelope.getSpan(dstIndex) / srcEnvelope.getSpan(srcIndex)) * (same ? srcCorner : srcOppositeCorner).getOrdinate(srcIndex);
                }
                matrix.setElement(dstIndex, srcIndex, scale);
                matrix.setElement(dstIndex, srcAxes.length, translate);
            }
            if (hasFound) continue;
            throw new IllegalArgumentException(Errors.format((short)6, "srcAxes", dstAxes[dstIndex]));
        }
        matrix.setElement(dstAxes.length, srcAxes.length, 1.0);
        return matrix;
    }

    public static MatrixSIS createTransform(Envelope srcEnvelope, Envelope dstEnvelope) {
        ArgumentChecks.ensureNonNull("srcEnvelope", srcEnvelope);
        ArgumentChecks.ensureNonNull("dstEnvelope", dstEnvelope);
        int srcDim = srcEnvelope.getDimension();
        int dstDim = dstEnvelope.getDimension();
        DirectPosition srcCorner = srcEnvelope.getLowerCorner();
        DirectPosition dstCorner = dstEnvelope.getLowerCorner();
        MatrixSIS matrix = Matrices.createZero(dstDim + 1, srcDim + 1);
        int i = Math.min(srcDim, dstDim);
        while (--i >= 0) {
            double scale = dstEnvelope.getSpan(i) / srcEnvelope.getSpan(i);
            double translate = dstCorner.getOrdinate(i) - srcCorner.getOrdinate(i) * scale;
            matrix.setElement(i, i, scale);
            matrix.setElement(i, srcDim, translate);
        }
        matrix.setElement(dstDim, srcDim, 1.0);
        return matrix;
    }

    public static MatrixSIS createTransform(AxisDirection[] srcAxes, AxisDirection[] dstAxes) {
        ArgumentChecks.ensureNonNull("srcAxes", srcAxes);
        ArgumentChecks.ensureNonNull("dstAxes", dstAxes);
        return Matrices.createTransform(null, srcAxes, null, dstAxes, false);
    }

    public static MatrixSIS createTransform(Envelope srcEnvelope, AxisDirection[] srcAxes, Envelope dstEnvelope, AxisDirection[] dstAxes) {
        ArgumentChecks.ensureNonNull("srcEnvelope", srcEnvelope);
        ArgumentChecks.ensureNonNull("dstEnvelope", dstEnvelope);
        ArgumentChecks.ensureDimensionMatches("srcEnvelope", srcAxes.length, srcEnvelope);
        ArgumentChecks.ensureDimensionMatches("dstEnvelope", dstAxes.length, dstEnvelope);
        return Matrices.createTransform(srcEnvelope, srcAxes, dstEnvelope, dstAxes, true);
    }

    public static MatrixSIS createDimensionSelect(int sourceDimensions, int[] selectedDimensions) {
        int numTargetDim = selectedDimensions.length;
        MatrixSIS matrix = Matrices.createZero(numTargetDim + 1, sourceDimensions + 1);
        for (int j = 0; j < numTargetDim; ++j) {
            int i = selectedDimensions[j];
            ArgumentChecks.ensureValidIndex(sourceDimensions, i);
            matrix.setElement(j, i, 1.0);
        }
        matrix.setElement(numTargetDim, sourceDimensions, 1.0);
        return matrix;
    }

    public static MatrixSIS createPassThrough(int firstAffectedOrdinate, Matrix subMatrix, int numTrailingOrdinates) {
        ArgumentChecks.ensureNonNull("subMatrix", subMatrix);
        ArgumentChecks.ensurePositive("firstAffectedOrdinate", firstAffectedOrdinate);
        ArgumentChecks.ensurePositive("numTrailingOrdinates", numTrailingOrdinates);
        int expansion = firstAffectedOrdinate + numTrailingOrdinates;
        int sourceDimensions = subMatrix.getNumCol();
        int targetDimensions = subMatrix.getNumRow();
        int stride = sourceDimensions;
        int length = sourceDimensions * targetDimensions;
        double[] sources = Matrices.getExtendedElements(subMatrix);
        DoubleDouble transfer = sources.length > length ? new DoubleDouble() : null;
        MatrixSIS matrix = Matrices.createZero(targetDimensions-- + expansion, sourceDimensions-- + expansion, transfer != null);
        for (int j = 0; j < firstAffectedOrdinate; ++j) {
            matrix.setElement(j, j, 1.0);
        }
        int lastColumn = sourceDimensions + expansion;
        matrix.setElements(sources, length, stride, transfer, 0, 0, firstAffectedOrdinate, firstAffectedOrdinate, targetDimensions, sourceDimensions);
        matrix.setElements(sources, length, stride, transfer, 0, sourceDimensions, firstAffectedOrdinate, lastColumn, targetDimensions, 1);
        int diff = targetDimensions - sourceDimensions;
        for (int i = lastColumn - numTrailingOrdinates; i < lastColumn; ++i) {
            matrix.setElement(diff + i, i, 1.0);
        }
        int lastRow = targetDimensions + expansion;
        matrix.setElements(sources, length, stride, transfer, targetDimensions, 0, lastRow, firstAffectedOrdinate, 1, sourceDimensions);
        matrix.setElements(sources, length, stride, transfer, targetDimensions, sourceDimensions, lastRow, lastColumn, 1, 1);
        return matrix;
    }

    public static Matrix resizeAffine(Matrix matrix, int numRow, int numCol) {
        ArgumentChecks.ensureNonNull("matrix", matrix);
        ArgumentChecks.ensureStrictlyPositive("numRow", numRow);
        ArgumentChecks.ensureStrictlyPositive("numCol", numCol);
        int srcRow = matrix.getNumRow();
        int srcCol = matrix.getNumCol();
        if (numRow == srcRow && numCol == srcCol) {
            return matrix;
        }
        int stride = srcCol;
        int length = srcCol * srcRow;
        double[] sources = Matrices.getExtendedElements(matrix);
        DoubleDouble transfer = sources.length > length ? new DoubleDouble() : null;
        MatrixSIS resized = Matrices.createZero(numRow, numCol, transfer != null);
        int copyRow = Math.min(--numRow, --srcRow);
        int copyCol = Math.min(--numCol, --srcCol);
        for (int j = copyRow; j < numRow; ++j) {
            resized.setElement(j, j, 1.0);
        }
        resized.setElements(sources, length, stride, transfer, 0, 0, 0, 0, copyRow, copyCol);
        resized.setElements(sources, length, stride, transfer, 0, srcCol, 0, numCol, copyRow, 1);
        resized.setElements(sources, length, stride, transfer, srcRow, 0, numRow, 0, 1, copyCol);
        resized.setElements(sources, length, stride, transfer, srcRow, srcCol, numRow, numCol, 1, 1);
        return resized;
    }

    private static boolean isExtendedPrecision(Matrix matrix) {
        return matrix instanceof MatrixSIS ? ((MatrixSIS)matrix).isExtendedPrecision() : matrix instanceof ExtendedPrecisionMatrix;
    }

    private static double[] getExtendedElements(Matrix matrix) {
        if (matrix instanceof ExtendedPrecisionMatrix) {
            return ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
        }
        return MatrixSIS.castOrCopy(matrix).getElements();
    }

    public static MatrixSIS copy(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        int size = matrix.getNumRow();
        if (size != matrix.getNumCol()) {
            return new NonSquareMatrix(matrix);
        }
        if (!Matrices.isExtendedPrecision(matrix)) {
            switch (size) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }

    public static MatrixSIS unmodifiable(Matrix matrix) {
        if (matrix == null || matrix instanceof UnmodifiableMatrix) {
            return (MatrixSIS)matrix;
        }
        return new UnmodifiableMatrix(matrix);
    }

    public static MatrixSIS multiply(Matrix m1, Matrix m2) throws MismatchedMatrixSizeException {
        if (m1 instanceof MatrixSIS) {
            return ((MatrixSIS)m1).multiply(m2);
        }
        int nc = m2.getNumCol();
        MatrixSIS.ensureNumRowMatch(m1.getNumCol(), m2.getNumRow(), nc);
        GeneralMatrix result = GeneralMatrix.createExtendedPrecision(m1.getNumRow(), nc, false);
        result.setToProduct(m1, m2);
        return result;
    }

    public static MatrixSIS inverse(Matrix matrix) throws NoninvertibleMatrixException {
        if (matrix == null) {
            return null;
        }
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).inverse();
        }
        if (matrix.getNumRow() != matrix.getNumCol()) {
            return new NonSquareMatrix(matrix).inverse();
        }
        return Solver.inverse(matrix, true);
    }

    public static boolean isAffine(Matrix matrix) {
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).isAffine();
        }
        return MatrixSIS.isAffine(matrix);
    }

    public static boolean isTranslation(Matrix matrix) {
        if (!Matrices.isAffine(matrix)) {
            return false;
        }
        int numRow = matrix.getNumRow() - 1;
        int numCol = matrix.getNumCol() - 1;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (matrix.getElement(j, i) == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentity(Matrix matrix, double tolerance) {
        int numCol;
        int numRow = matrix.getNumRow();
        if (numRow != (numCol = matrix.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double e = matrix.getElement(j, i);
                if (i == j) {
                    e -= 1.0;
                }
                if (Math.abs(e) <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Matrix m1, Matrix m2, double epsilon, boolean relative) {
        if (m1 != m2) {
            if (m1 == null || m2 == null) {
                return false;
            }
            int numRow = m1.getNumRow();
            if (numRow != m2.getNumRow()) {
                return false;
            }
            int numCol = m1.getNumCol();
            if (numCol != m2.getNumCol()) {
                return false;
            }
            for (int j = 0; j < numRow; ++j) {
                for (int i = 0; i < numCol; ++i) {
                    double v1 = m1.getElement(j, i);
                    double v2 = m2.getElement(j, i);
                    double tolerance = epsilon;
                    if (relative) {
                        tolerance *= Math.max(Math.abs(v1), Math.abs(v2));
                    }
                    if (Math.abs(v1 - v2) <= tolerance || Numerics.equals(v1, v2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean equals(Matrix m1, Matrix m2, ComparisonMode mode) {
        switch (mode) {
            case STRICT: {
                return Objects.equals(m1, m2);
            }
            case BY_CONTRACT: 
            case IGNORE_METADATA: {
                return Matrices.equals(m1, m2, 0.0, false);
            }
            case DEBUG: 
            case ALLOW_VARIANT: 
            case APPROXIMATIVE: {
                return Matrices.equals(m1, m2, 1.0E-13, true);
            }
        }
        throw new IllegalArgumentException(Errors.format((short)114, ComparisonMode.class, (Object)mode));
    }

    public static String toString(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        String[] elements = new String[numCol * numRow];
        boolean[] noFractionDigits = new boolean[numCol * numRow];
        boolean[] hasDecimalSeparator = new boolean[numCol];
        byte[] maximumFractionDigits = new byte[numCol];
        byte[] maximumPaddingZeros = new byte[numCol * numRow];
        byte[] widthBeforeFraction = new byte[numCol];
        byte[] columnWidth = new byte[numCol];
        int totalWidth = 1;
        int spacing = 1;
        for (int i = 0; i < numCol; ++i) {
            for (int j = 0; j < numRow; ++j) {
                int width;
                int flatIndex = j * numCol + i;
                double value = matrix.getElement(j, i);
                String element = Double.toString(value);
                if (value == -1.0 || value == 0.0 || value == 1.0) {
                    noFractionDigits[flatIndex] = true;
                    width = spacing + element.length() - 2;
                    widthBeforeFraction[i] = (byte)Math.max(widthBeforeFraction[i], width);
                } else {
                    int s = element.lastIndexOf(46);
                    if (s < 0) {
                        element = CharSequences.replace(element, "Infinity", "\u221e").toString();
                        width = spacing + element.length();
                        widthBeforeFraction[i] = (byte)Math.max(widthBeforeFraction[i], width);
                    } else {
                        hasDecimalSeparator[i] = true;
                        int numFractionDigits = element.length() - ++s;
                        widthBeforeFraction[i] = (byte)Math.max(widthBeforeFraction[i], spacing + s);
                        maximumFractionDigits[i] = (byte)Math.max(maximumFractionDigits[i], numFractionDigits);
                        width = widthBeforeFraction[i] + maximumFractionDigits[i];
                        if (element.indexOf(69) < 0) {
                            int accuracy = (int)Math.ceil(-Math.log10(Math.ulp(value)));
                            maximumPaddingZeros[flatIndex] = (byte)(accuracy - numFractionDigits);
                        }
                    }
                }
                columnWidth[i] = (byte)Math.max(columnWidth[i], width);
                elements[flatIndex] = element;
            }
            totalWidth += columnWidth[i];
            spacing = 2;
        }
        String lineSeparator = JDK7.lineSeparator();
        CharSequence whiteLine = CharSequences.spaces(totalWidth);
        StringBuilder buffer = new StringBuilder((totalWidth + 2 + lineSeparator.length()) * (numRow + 2));
        buffer.append('\u250c').append(whiteLine).append('\u2510').append(lineSeparator);
        int flatIndex = 0;
        for (int j = 0; j < numRow; ++j) {
            buffer.append('\u2502');
            for (int i = 0; i < numCol; ++i) {
                int spaces;
                String element = elements[flatIndex];
                int width = element.length();
                int s = element.lastIndexOf(46);
                if (s >= 0) {
                    if (hasDecimalSeparator[i]) {
                        ++s;
                    }
                    spaces = widthBeforeFraction[i] - s;
                } else {
                    spaces = columnWidth[i] - width;
                }
                buffer.append(CharSequences.spaces(spaces)).append(element);
                if (s >= 0) {
                    s += maximumFractionDigits[i] - width;
                    if (noFractionDigits[flatIndex]) {
                        buffer.setLength(buffer.length() - 2);
                        s += 2;
                    } else {
                        int n = Math.min(s, maximumPaddingZeros[flatIndex]);
                        s -= n;
                        while (--n >= 0) {
                            buffer.append('0');
                        }
                    }
                    buffer.append(CharSequences.spaces(s));
                }
                ++flatIndex;
            }
            buffer.append(" \u2502").append(lineSeparator);
        }
        return buffer.append('\u2514').append(whiteLine).append('\u2518').append(lineSeparator).toString();
    }
}

