/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix1
extends MatrixSIS {
    private static final long serialVersionUID = -4829171016106097031L;
    public static final int SIZE = 1;
    public double m00;

    public Matrix1() {
        this.m00 = 1.0;
    }

    Matrix1(boolean ignore) {
    }

    public Matrix1(double m00) {
        this.m00 = m00;
    }

    public Matrix1(double[] elements) throws IllegalArgumentException {
        this.setElements(elements);
    }

    Matrix1(Matrix matrix) {
        this.m00 = matrix.getElement(0, 0);
    }

    public static Matrix1 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix1) {
            return (Matrix1)matrix;
        }
        Matrix1.ensureSizeMatch(1, 1, matrix);
        return new Matrix1(matrix);
    }

    @Override
    public final int getNumRow() {
        return 1;
    }

    @Override
    public final int getNumCol() {
        return 1;
    }

    @Override
    public final double getElement(int row, int column) {
        if (row == 0 && column == 0) {
            return this.m00;
        }
        throw Matrix1.indexOutOfBounds(row, column);
    }

    @Override
    public final void setElement(int row, int column, double value) {
        if (row != 0 || column != 0) {
            throw Matrix1.indexOutOfBounds(row, column);
        }
        this.m00 = value;
    }

    @Override
    public final double[] getElements() {
        double[] elements = new double[1];
        this.getElements(elements);
        return elements;
    }

    @Override
    final void getElements(double[] elements) {
        elements[0] = this.m00;
    }

    @Override
    public final void setElements(double[] elements) {
        Matrix1.ensureLengthMatch(1, elements);
        this.m00 = elements[0];
    }

    @Override
    public final boolean isAffine() {
        return this.m00 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0;
    }

    @Override
    public void transpose() {
    }

    @Override
    public void normalizeColumns() {
        this.m00 = 1.0;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Matrix1) {
            Matrix1 that = (Matrix1)object;
            return Numerics.equals(this.m00, that.m00);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Numerics.hashCode(Double.doubleToLongBits(this.m00) ^ 0xBCFB568C01624679L);
    }
}

