/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix3
extends MatrixSIS {
    private static final long serialVersionUID = 8902061778871586611L;
    public static final int SIZE = 3;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix3(boolean ignore) {
    }

    public Matrix3(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3(double[] elements) throws IllegalArgumentException {
        this.setElements(elements);
    }

    Matrix3(Matrix matrix) {
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public static Matrix3 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix3) {
            return (Matrix3)matrix;
        }
        Matrix3.ensureSizeMatch(3, 3, matrix);
        return new Matrix3(matrix);
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public final double getElement(int row, int column) {
        if (row >= 0 && row < 3 && column >= 0 && column < 3) {
            switch (row * 3 + column) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m02;
                }
                case 3: {
                    return this.m10;
                }
                case 4: {
                    return this.m11;
                }
                case 5: {
                    return this.m12;
                }
                case 6: {
                    return this.m20;
                }
                case 7: {
                    return this.m21;
                }
                case 8: {
                    return this.m22;
                }
            }
        }
        throw Matrix3.indexOutOfBounds(row, column);
    }

    @Override
    public final void setElement(int row, int column, double value) {
        if (row >= 0 && row < 3 && column >= 0 && column < 3) {
            switch (row * 3 + column) {
                case 0: {
                    this.m00 = value;
                    return;
                }
                case 1: {
                    this.m01 = value;
                    return;
                }
                case 2: {
                    this.m02 = value;
                    return;
                }
                case 3: {
                    this.m10 = value;
                    return;
                }
                case 4: {
                    this.m11 = value;
                    return;
                }
                case 5: {
                    this.m12 = value;
                    return;
                }
                case 6: {
                    this.m20 = value;
                    return;
                }
                case 7: {
                    this.m21 = value;
                    return;
                }
                case 8: {
                    this.m22 = value;
                    return;
                }
            }
        }
        throw Matrix3.indexOutOfBounds(row, column);
    }

    @Override
    public final double[] getElements() {
        double[] elements = new double[9];
        this.getElements(elements);
        return elements;
    }

    @Override
    final void getElements(double[] elements) {
        elements[0] = this.m00;
        elements[1] = this.m01;
        elements[2] = this.m02;
        elements[3] = this.m10;
        elements[4] = this.m11;
        elements[5] = this.m12;
        elements[6] = this.m20;
        elements[7] = this.m21;
        elements[8] = this.m22;
    }

    @Override
    public final void setElements(double[] elements) {
        Matrix3.ensureLengthMatch(9, elements);
        this.m00 = elements[0];
        this.m01 = elements[1];
        this.m02 = elements[2];
        this.m10 = elements[3];
        this.m11 = elements[4];
        this.m12 = elements[5];
        this.m20 = elements[6];
        this.m21 = elements[7];
        this.m22 = elements[8];
    }

    @Override
    public final boolean isAffine() {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.isAffine();
    }

    @Override
    public void transpose() {
        double swap = this.m01;
        this.m01 = this.m10;
        this.m10 = swap;
        swap = this.m02;
        this.m02 = this.m20;
        this.m20 = swap;
        swap = this.m12;
        this.m12 = this.m21;
        this.m21 = swap;
    }
}

