/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.matrix.Solver;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public abstract class MatrixSIS
implements Matrix,
LenientComparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3075280376118406219L;

    protected MatrixSIS() {
    }

    static void ensureLengthMatch(int expected, double[] elements) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("elements", elements);
        if (elements.length != expected) {
            throw new IllegalArgumentException(Errors.format((short)107, expected, elements.length));
        }
    }

    static void ensureSizeMatch(int numRow, int numCol, Matrix matrix) throws MismatchedMatrixSizeException {
        int othRow = matrix.getNumRow();
        int othCol = matrix.getNumCol();
        if (numRow != othRow || numCol != othCol) {
            throw new MismatchedMatrixSizeException(Errors.format((short)60, numRow, numCol, othRow, othCol));
        }
    }

    static void ensureNumRowMatch(int expected, int actual, int numCol) {
        if (actual != expected) {
            throw new MismatchedMatrixSizeException(Errors.format((short)60, expected, "\u24a9", actual, numCol));
        }
    }

    static IndexOutOfBoundsException indexOutOfBounds(int row, int column) {
        return new IndexOutOfBoundsException(Errors.format((short)50, row, column));
    }

    public static MatrixSIS castOrCopy(Matrix matrix) {
        if (matrix == null || matrix instanceof MatrixSIS) {
            return (MatrixSIS)matrix;
        }
        return Matrices.copy(matrix);
    }

    void get(int row, int column, DoubleDouble dd) {
        dd.value = this.getElement(row, column);
        dd.error = DoubleDouble.errorForWellKnownValue(dd.value);
    }

    void set(int row, int column, DoubleDouble dd) {
        this.setElement(row, column, dd.value);
    }

    public Number getNumber(int row, int column) {
        return this.getElement(row, column);
    }

    @Override
    public abstract double getElement(int var1, int var2);

    public double[] getElements() {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        double[] elements = new double[numRow * numCol];
        int k = 0;
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                elements[k++] = this.getElement(j, i);
            }
        }
        return elements;
    }

    void getElements(double[] dest) {
        double[] elements = this.getElements();
        System.arraycopy(elements, 0, dest, 0, elements.length);
    }

    static void getElements(Matrix matrix, int numRow, int numCol, double[] elements) {
        if (matrix instanceof MatrixSIS) {
            ((MatrixSIS)matrix).getElements(elements);
        } else {
            int k = 0;
            for (int j = 0; j < numRow; ++j) {
                for (int i = 0; i < numCol; ++i) {
                    elements[k++] = matrix.getElement(j, i);
                }
            }
        }
    }

    public abstract void setElements(double[] var1);

    final void setElements(double[] source, int length, int stride, DoubleDouble transfer, int srcRow, int srcCol, int dstRow, int dstCol, int numRow, int numCol) {
        while (--numRow >= 0) {
            int valueOffset = srcRow * stride + srcCol;
            for (int i = 0; i < numCol; ++i) {
                if (transfer != null) {
                    transfer.setFrom(source, valueOffset + i, length);
                    this.set(dstRow, dstCol + i, transfer);
                    continue;
                }
                this.setElement(dstRow, dstCol + i, source[valueOffset + i]);
            }
            ++srcRow;
            ++dstRow;
        }
    }

    public void setMatrix(Matrix matrix) throws MismatchedMatrixSizeException {
        double[] elements;
        ArgumentChecks.ensureNonNull("matrix", matrix);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        MatrixSIS.ensureSizeMatch(numRow, numCol, matrix);
        int count = numRow * numCol;
        if (this.isExtendedPrecision() && matrix instanceof ExtendedPrecisionMatrix) {
            elements = ((ExtendedPrecisionMatrix)matrix).getExtendedElements();
            if (elements.length > count) {
                DoubleDouble t = new DoubleDouble();
                for (int i = 0; i < count; ++i) {
                    t.value = elements[i];
                    t.error = elements[i + count];
                    this.set(i / numCol, i % numCol, t);
                }
                return;
            }
        } else {
            elements = new double[count];
            MatrixSIS.getElements(matrix, numRow, numCol, elements);
        }
        this.setElements(elements);
    }

    boolean isExtendedPrecision() {
        return false;
    }

    public boolean isAffine() {
        return MatrixSIS.isAffine(this);
    }

    static boolean isAffine(Matrix matrix) {
        int j = matrix.getNumRow();
        int i = matrix.getNumCol();
        if (i != j--) {
            return false;
        }
        double e = 1.0;
        while (--i >= 0) {
            if (matrix.getElement(j, i) != e) {
                return false;
            }
            e = 0.0;
        }
        return true;
    }

    @Override
    public abstract boolean isIdentity();

    public abstract void transpose();

    public void normalizeColumns() {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        DoubleDouble sum = new DoubleDouble();
        DoubleDouble dot = new DoubleDouble();
        DoubleDouble tmp = new DoubleDouble();
        for (int i = 0; i < numCol; ++i) {
            int j;
            sum.clear();
            for (j = 0; j < numRow; ++j) {
                this.get(j, i, dot);
                dot.square();
                sum.add(dot);
            }
            sum.sqrt();
            for (j = 0; j < numRow; ++j) {
                this.get(j, i, tmp);
                dot.setFrom(sum);
                dot.inverseDivide(tmp);
                this.set(j, i, dot);
            }
        }
    }

    public void convertBefore(int srcDim, Number scale, Number offset) {
        int lastCol = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(lastCol, srcDim);
        DoubleDouble s = new DoubleDouble();
        DoubleDouble t = new DoubleDouble();
        int j = this.getNumRow();
        while (--j >= 0) {
            if (offset != null) {
                this.get(j, srcDim, s);
                this.get(j, lastCol, t);
                s.multiply(offset);
                t.add(s);
                this.set(j, lastCol, t);
            }
            if (scale == null) continue;
            this.get(j, srcDim, s);
            s.multiply(scale);
            this.set(j, srcDim, s);
        }
    }

    public void convertAfter(int tgtDim, Number scale, Number offset) {
        int lastRow = this.getNumRow() - 1;
        int lastCol = this.getNumCol() - 1;
        ArgumentChecks.ensureValidIndex(lastRow, tgtDim);
        DoubleDouble s = new DoubleDouble();
        if (scale != null) {
            for (int i = lastCol; i >= 0; --i) {
                this.get(tgtDim, i, s);
                s.multiply(scale);
                this.set(tgtDim, i, s);
            }
        }
        if (offset != null) {
            this.get(tgtDim, lastCol, s);
            s.add(offset);
            this.set(tgtDim, lastCol, s);
        }
    }

    public MatrixSIS multiply(Matrix matrix) throws MismatchedMatrixSizeException {
        int nc = matrix.getNumCol();
        MatrixSIS.ensureNumRowMatch(this.getNumCol(), matrix.getNumRow(), nc);
        GeneralMatrix result = GeneralMatrix.createExtendedPrecision(this.getNumRow(), nc, false);
        result.setToProduct(this, matrix);
        return result;
    }

    public MatrixSIS solve(Matrix matrix) throws MismatchedMatrixSizeException, NoninvertibleMatrixException {
        return Solver.solve(this, matrix);
    }

    public MatrixSIS inverse() throws NoninvertibleMatrixException {
        return Solver.inverse(this, true);
    }

    public MatrixSIS removeRows(int lower, int upper) {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        ArgumentChecks.ensureValidIndexRange(numRow, lower, upper);
        DoubleDouble dd = this.isExtendedPrecision() ? new DoubleDouble() : null;
        MatrixSIS reduced = Matrices.createZero(numRow - (upper - lower), numCol, dd != null);
        int dest = 0;
        for (int j = 0; j < numRow && (j != lower || (j = upper) != numRow); ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (dd != null) {
                    this.get(j, i, dd);
                    reduced.set(dest, i, dd);
                    continue;
                }
                reduced.setElement(dest, i, this.getElement(j, i));
            }
            ++dest;
        }
        return reduced;
    }

    public MatrixSIS removeColumns(int lower, int upper) {
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        ArgumentChecks.ensureValidIndexRange(numCol, lower, upper);
        DoubleDouble dd = this.isExtendedPrecision() ? new DoubleDouble() : null;
        MatrixSIS reduced = Matrices.createZero(numRow, numCol - (upper - lower), dd != null);
        int dest = 0;
        for (int i = 0; i < numCol && (i != lower || (i = upper) != numCol); ++i) {
            for (int j = 0; j < numRow; ++j) {
                if (dd != null) {
                    this.get(j, i, dd);
                    reduced.set(j, dest, dd);
                    continue;
                }
                reduced.setElement(j, dest, this.getElement(j, i));
            }
            ++dest;
        }
        return reduced;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getElements()) ^ 0x63446C4B;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            int numRow = this.getNumRow();
            int numCol = this.getNumCol();
            MatrixSIS that = (MatrixSIS)object;
            if (that.getNumRow() == numRow && that.getNumCol() == numCol) {
                int j = numRow;
                while (--j >= 0) {
                    int i = numCol;
                    while (--i >= 0) {
                        if (Numerics.equals(that.getElement(j, i), this.getElement(j, i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Matrix matrix, double tolerance) {
        return Matrices.equals(this, matrix, tolerance, false);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return object instanceof Matrix && Matrices.equals(this, (Matrix)object, mode);
    }

    @Override
    public MatrixSIS clone() {
        try {
            return (MatrixSIS)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return Matrices.toString(this);
    }
}

