/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

final class Solver
implements Matrix {
    private static final int TUPLE_SIZE = 3;
    private static final Matrix IDENTITY = new Solver();

    private Solver() {
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public double getElement(int j, int i) {
        return j == i ? 1.0 : 0.0;
    }

    @Override
    public void setElement(int j, int i, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix clone() {
        return this;
    }

    @Override
    public int getNumRow() {
        return 0;
    }

    @Override
    public int getNumCol() {
        return 0;
    }

    static MatrixSIS inverse(Matrix X, boolean noChange) throws NoninvertibleMatrixException {
        int size = X.getNumRow();
        int numCol = X.getNumCol();
        if (numCol != size) {
            throw new NoninvertibleMatrixException(Errors.format((short)81, size, numCol));
        }
        return Solver.solve(X, IDENTITY, null, size, size, noChange);
    }

    static MatrixSIS solve(Matrix X, Matrix Y) throws NoninvertibleMatrixException {
        int size = X.getNumRow();
        int numCol = X.getNumCol();
        if (numCol != size) {
            throw new NoninvertibleMatrixException(Errors.format((short)81, size, numCol));
        }
        int innerSize = Y.getNumCol();
        GeneralMatrix.ensureNumRowMatch(size, Y.getNumRow(), innerSize);
        double[] eltY = null;
        if (Y instanceof GeneralMatrix && (eltY = ((GeneralMatrix)Y).elements).length == size * innerSize) {
            eltY = null;
        }
        return Solver.solve(X, Y, eltY, size, innerSize, true);
    }

    private static MatrixSIS solve(Matrix X, Matrix Y, double[] eltY, int size, int innerSize, boolean noChange) throws NoninvertibleMatrixException {
        int i;
        assert (X.getNumRow() == size && X.getNumCol() == size) : size;
        assert (Y.getNumRow() == size && Y.getNumCol() == innerSize || Y instanceof Solver);
        double[] LU = GeneralMatrix.getExtendedElements(X, size, size, noChange);
        int lastRowOrColumn = size - 1;
        int[] indexOfNaN = null;
        int indexCount = 0;
        if (X instanceof MatrixSIS ? ((MatrixSIS)X).isAffine() : MatrixSIS.isAffine(X)) {
            int flatIndex = (size - 1) * size;
            block0: while (--flatIndex >= 0) {
                int k;
                if (!Double.isNaN(LU[flatIndex])) continue;
                int j = flatIndex / size;
                i = flatIndex % size;
                int columnOfScale = -1;
                if (i != lastRowOrColumn) {
                    columnOfScale = i;
                    k = lastRowOrColumn;
                    while (--k >= 0) {
                        if (k == j || LU[k * size + i] == 0.0) continue;
                        indexOfNaN = null;
                        indexCount = 0;
                        break block0;
                    }
                }
                k = lastRowOrColumn;
                while (--k >= 0) {
                    if (k == i || LU[j * size + k] == 0.0) continue;
                    if (columnOfScale >= 0) {
                        indexOfNaN = null;
                        indexCount = 0;
                        break block0;
                    }
                    columnOfScale = k;
                }
                if (indexOfNaN == null) {
                    indexOfNaN = new int[lastRowOrColumn * 6];
                }
                indexOfNaN[indexCount++] = i;
                indexOfNaN[indexCount++] = j;
                indexOfNaN[indexCount++] = columnOfScale;
                assert (indexCount % 3 == 0);
            }
            for (int k = 0; k < indexCount; k += 3) {
                void i2 = indexOfNaN[k];
                void j = indexOfNaN[k + 1];
                void flatIndex2 = j * size + i2;
                LU[flatIndex2] = i2 == lastRowOrColumn ? 0.0 : 1.0;
                LU[flatIndex2 + size * size] = 0.0;
            }
        }
        MatrixSIS matrix = Solver.solve(LU, Y, eltY, size, innerSize);
        int k = 0;
        while (k < indexCount) {
            assert (k % 3 == 0);
            i = indexOfNaN[k++];
            void j = indexOfNaN[k++];
            void s = indexOfNaN[k++];
            if (i != lastRowOrColumn) {
                matrix.setElement(i, (int)j, Double.NaN);
                if (matrix.getElement(i, lastRowOrColumn) == 0.0) continue;
                matrix.setElement(i, lastRowOrColumn, Double.NaN);
                continue;
            }
            if (s < 0) continue;
            matrix.setElement((int)s, lastRowOrColumn, Double.NaN);
        }
        return matrix;
    }

    private static MatrixSIS solve(double[] LU, Matrix Y, double[] eltY, int size, int innerSize) throws NoninvertibleMatrixException {
        int j;
        int rowOffset;
        int errorLU = size * size;
        assert (errorLU == GeneralMatrix.indexOfErrors(size, size, LU));
        int[] pivot = new int[size];
        for (int j2 = 0; j2 < size; ++j2) {
            pivot[j2] = j2;
        }
        double[] column = new double[size * 2];
        DoubleDouble acc = new DoubleDouble();
        DoubleDouble rat = new DoubleDouble();
        for (int i = 0; i < size; ++i) {
            int k;
            int j3;
            for (j3 = 0; j3 < size; ++j3) {
                int k2 = j3 * size + i;
                column[j3] = LU[k2];
                column[j3 + size] = LU[k2 + errorLU];
            }
            for (j3 = 0; j3 < size; ++j3) {
                int rowOffset2 = j3 * size;
                int kmax = Math.min(j3, i);
                acc.clear();
                for (k = 0; k < kmax; ++k) {
                    rat.setFrom(LU, rowOffset2 + k, errorLU);
                    rat.multiply(column, k, size);
                    acc.add(rat);
                }
                acc.subtract(column, j3, size);
                acc.negate();
                acc.storeTo(column, j3, size);
                acc.storeTo(LU, rowOffset2 + i, errorLU);
            }
            int p = i;
            int j4 = i;
            while (++j4 < size) {
                if (!(Math.abs(column[j4]) > Math.abs(column[p]))) continue;
                p = j4;
            }
            if (p != i) {
                int pRow = p * size;
                int iRow = i * size;
                for (k = 0; k < size; ++k) {
                    DoubleDouble.swap(LU, pRow + k, iRow + k, errorLU);
                }
                ArraysExt.swap(pivot, p, i);
            }
            acc.setFrom(LU, i * size + i, errorLU);
            if (acc.isZero()) continue;
            j4 = i;
            while (++j4 < size) {
                int t = j4 * size + i;
                rat.setFrom(acc);
                rat.inverseDivide(LU, t, errorLU);
                rat.storeTo(LU, t, errorLU);
            }
        }
        for (int j5 = 0; j5 < size; ++j5) {
            rat.setFrom(LU, j5 * size + j5, errorLU);
            if (!rat.isZero()) continue;
            throw new NoninvertibleMatrixException(Errors.format((short)101));
        }
        GeneralMatrix result = GeneralMatrix.createExtendedPrecision(size, innerSize, false);
        double[] elements = result.elements;
        int errorOffset = size * innerSize;
        int k = 0;
        for (int j6 = 0; j6 < size; ++j6) {
            int p = pivot[j6];
            for (int i = 0; i < innerSize; ++i) {
                if (eltY != null) {
                    int t = p * innerSize + i;
                    elements[k] = eltY[t];
                    elements[k + errorOffset] = eltY[t + errorOffset];
                } else {
                    elements[k] = Y.getElement(p, i);
                }
                ++k;
            }
        }
        for (k = 0; k < size; ++k) {
            rowOffset = k * innerSize;
            j = k;
            while (++j < size) {
                int loRowOffset = j * innerSize;
                int luRowOffset = j * size;
                for (int i = 0; i < innerSize; ++i) {
                    acc.setFrom(elements, loRowOffset + i, errorOffset);
                    rat.setFrom(elements, rowOffset + i, errorOffset);
                    rat.multiply(LU, luRowOffset + k, errorLU);
                    acc.subtract(rat);
                    acc.storeTo(elements, loRowOffset + i, errorOffset);
                }
            }
        }
        k = size;
        while (--k >= 0) {
            rowOffset = k * innerSize;
            acc.setFrom(LU, k * size + k, errorLU);
            for (int i = 0; i < innerSize; ++i) {
                rat.setFrom(acc);
                rat.inverseDivide(elements, rowOffset + i, errorOffset);
                rat.storeTo(elements, rowOffset + i, errorOffset);
            }
            for (j = 0; j < k; ++j) {
                int upRowOffset = j * innerSize;
                acc.setFrom(LU, j * size + k, errorLU);
                for (int i = 0; i < innerSize; ++i) {
                    rat.setFrom(elements, rowOffset + i, errorOffset);
                    rat.multiply(acc);
                    rat.subtract(elements, upRowOffset + i, errorOffset);
                    rat.negate();
                    rat.storeTo(elements, upRowOffset + i, errorOffset);
                }
            }
        }
        return result;
    }
}

