/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class ConformalProjection
extends NormalizedProjection {
    private static final long serialVersionUID = 458860570536642265L;
    static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    static final double ECCENTRICITY_THRESHOLD = 0.16;
    private transient boolean useIterations;
    transient double ci2;
    transient double ci4;
    transient double ci6;
    transient double ci8;

    ConformalProjection(Initializer initializer) {
        super(initializer);
    }

    void computeCoefficients() {
        this.useIterations = this.eccentricity >= 0.16;
        double e2 = this.eccentricitySquared;
        double e4 = e2 * e2;
        double e6 = e2 * e4;
        double e8 = e4 * e4;
        this.ci2 = 0.03611111111111111 * e8 + 0.08333333333333333 * e6 + 0.20833333333333334 * e4 + e2 / 2.0;
        this.ci4 = 0.07039930555555556 * e8 + 0.12083333333333333 * e6 + 0.14583333333333334 * e4;
        this.ci6 = 0.07232142857142858 * e8 + 0.058333333333333334 * e6;
        this.ci8 = 0.026531498015873015 * e8;
        this.ci4 *= 2.0;
        this.ci6 *= 4.0;
        this.ci8 *= 8.0;
    }

    ConformalProjection(ConformalProjection other) {
        super(other);
        this.useIterations = other.useIterations;
        this.ci2 = other.ci2;
        this.ci4 = other.ci4;
        this.ci6 = other.ci6;
        this.ci8 = other.ci8;
    }

    final double \u03c6(double expOfSouthing) throws ProjectionException {
        double \u03c6 = 1.5707963267948966 - 2.0 * Math.atan(expOfSouthing);
        double sin_2\u03c6 = Math.sin(2.0 * \u03c6);
        double sin2 = sin_2\u03c6 * sin_2\u03c6;
        \u03c6 += ((this.ci4 + this.ci8 * (0.5 - sin2)) * Math.cos(2.0 * \u03c6) + (this.ci2 + this.ci6 * (0.75 - sin2))) * sin_2\u03c6;
        if (!this.useIterations) {
            return \u03c6;
        }
        double h\u212f = 0.5 * this.eccentricity;
        for (int it = 0; it < 15; ++it) {
            double \u212fsin\u03c6 = this.eccentricity * Math.sin(\u03c6);
            double \u0394\u03c6 = \u03c6 - (\u03c6 = 1.5707963267948966 - 2.0 * Math.atan(expOfSouthing * Math.pow((1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6), h\u212f)));
            if (Math.abs(\u0394\u03c6) > 3.926676682852614E-10) continue;
            return \u03c6;
        }
        throw new ProjectionException(181);
    }

    final double expOfNorthing(double \u03c6, double \u212fsin\u03c6) {
        return Math.tan(0.7853981633974483 + 0.5 * \u03c6) * Math.pow((1.0 - \u212fsin\u03c6) / (1.0 + \u212fsin\u03c6), 0.5 * this.eccentricity);
    }

    final double dy_d\u03c6(double sin\u03c6, double cos\u03c6) {
        return 1.0 / cos\u03c6 - this.eccentricitySquared * cos\u03c6 / (1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeCoefficients();
    }

    static boolean identityEquals(double actual, double expected) {
        return !(Math.abs(actual - expected) > 1.5706706731410455E-12 * Math.max(1.0, Math.abs(expected)));
    }
}

