/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.Map;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.operation.OperationMethod;

final class Initializer {
    final ContextualParameters context;
    final Parameters parameters;
    final DoubleDouble eccentricitySquared;
    final byte variant;

    Initializer(OperationMethod method, Parameters parameters, Map<NormalizedProjection.ParameterRole, ? extends ParameterDescriptor<? extends Number>> roles, byte variant) {
        ParameterDescriptor<? extends Number> scaleFactor;
        ArgumentChecks.ensureNonNull("method", method);
        ArgumentChecks.ensureNonNull("parameters", parameters);
        ArgumentChecks.ensureNonNull("roles", roles);
        this.context = new ContextualParameters(method);
        this.parameters = parameters;
        this.variant = variant;
        ParameterDescriptor<? extends Number> semiMajor = roles.get((Object)NormalizedProjection.ParameterRole.SEMI_MAJOR);
        ParameterDescriptor<? extends Number> semiMinor = roles.get((Object)NormalizedProjection.ParameterRole.SEMI_MINOR);
        if (semiMajor == null) {
            semiMajor = MapProjection.SEMI_MAJOR;
        }
        if (semiMinor == null) {
            semiMinor = MapProjection.SEMI_MINOR;
        }
        double a = this.getAndStore(semiMajor);
        double b = this.getAndStore(semiMinor);
        double \u03bb0 = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN));
        double fe = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_EASTING)) - this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_WESTING));
        double fn = this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_NORTHING)) - this.getAndStore(roles.get((Object)NormalizedProjection.ParameterRole.FALSE_SOUTHING));
        this.eccentricitySquared = new DoubleDouble();
        DoubleDouble k = new DoubleDouble(a);
        if (a != b) {
            boolean isIvfDefinitive;
            try {
                isIvfDefinitive = parameters.parameter("is_ivf_definitive").booleanValue();
            }
            catch (ParameterNotFoundException e) {
                isIvfDefinitive = false;
            }
            if (isIvfDefinitive) {
                DoubleDouble f = new DoubleDouble(parameters.parameter("inverse_flattening").doubleValue());
                f.inverseDivide(1.0, 0.0);
                this.eccentricitySquared.setFrom(f);
                this.eccentricitySquared.multiply(2.0, 0.0);
                f.square();
                this.eccentricitySquared.subtract(f);
            } else {
                DoubleDouble rs = new DoubleDouble(b);
                rs.divide(k);
                rs.square();
                this.eccentricitySquared.value = 1.0;
                this.eccentricitySquared.subtract(rs);
            }
            ParameterDescriptor<? extends Number> radius = roles.get((Object)NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS);
            if (radius != null) {
                k = this.r\u03bd2(Math.sin(Math.toRadians(parameters.doubleValue(radius))));
                k.inverseDivide(b, 0.0);
            }
        }
        if ((scaleFactor = roles.get((Object)NormalizedProjection.ParameterRole.SCALE_FACTOR)) != null) {
            k.multiply(this.getAndStore(scaleFactor));
        }
        this.context.normalizeGeographicInputs(\u03bb0);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertAfter(0, k, new DoubleDouble(fe));
        denormalize.convertAfter(1, k, new DoubleDouble(fn));
    }

    final double getAndStore(ParameterDescriptor<? extends Number> descriptor) {
        if (descriptor == null) {
            return 0.0;
        }
        double value = this.parameters.doubleValue(descriptor);
        Number defaultValue = descriptor.getDefaultValue();
        if (defaultValue == null || !defaultValue.equals(value)) {
            MapProjection.validate(descriptor, value);
            this.context.parameter(descriptor.getName().getCode()).setValue(value);
        }
        return value;
    }

    final double getAndStore(ParameterDescriptor<Double> descriptor, double defaultValue) {
        Double value = this.parameters.getValue(descriptor);
        if (value == null) {
            return defaultValue;
        }
        MapProjection.validate(descriptor, value);
        this.context.parameter(descriptor.getName().getCode()).setValue(value);
        return value;
    }

    final DoubleDouble axisLengthRatio() {
        DoubleDouble b = new DoubleDouble(1.0, 0.0);
        b.subtract(this.eccentricitySquared);
        b.sqrt();
        return b;
    }

    private DoubleDouble r\u03bd2(double sin\u03c6) {
        DoubleDouble t = DoubleDouble.verbatim(sin\u03c6);
        t.square();
        t.multiply(this.eccentricitySquared);
        t.negate();
        t.add(1.0, 0.0);
        return t;
    }

    final double radiusOfConformalSphere(double sin\u03c6) {
        DoubleDouble Rc = DoubleDouble.verbatim(1.0);
        Rc.subtract(this.eccentricitySquared);
        Rc.sqrt();
        Rc.divide(this.r\u03bd2(sin\u03c6));
        return Rc.value;
    }

    final double scaleAt\u03c6(double sin\u03c6, double cos\u03c6) {
        DoubleDouble s = this.r\u03bd2(sin\u03c6);
        s.sqrt();
        s.inverseDivide(cos\u03c6, 0.0);
        return s.value;
    }
}

