/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.referencing.provider.Mercator2SP;
import org.apache.sis.internal.referencing.provider.RegionalMercator;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.ConformalProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Mercator
extends ConformalProjection {
    private static final long serialVersionUID = 2564172914329253286L;
    private static final byte SPHERICAL = 1;
    private static final byte PSEUDO = 3;
    private static final byte REGIONAL = 2;
    private static final byte MILLER = 4;
    private final byte variant;

    private static byte getVariant(OperationMethod method) {
        if (Mercator.identMatch(method, "(?i).*\\bvariant\\s*C\\b.*", "1044")) {
            return 2;
        }
        if (Mercator.identMatch(method, "(?i).*\\bSpherical\\b.*", "1026")) {
            return 1;
        }
        if (Mercator.identMatch(method, "(?i).*\\bPseudo.*", "1024")) {
            return 3;
        }
        if (Mercator.identMatch(method, "(?i).*\\bMiller.*", null)) {
            return 4;
        }
        return 0;
    }

    public Mercator(OperationMethod method, Parameters parameters) {
        this(Mercator.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        byte variant = Mercator.getVariant(method);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, Mercator1SP.SCALE_FACTOR);
        switch (variant) {
            case 2: {
                roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, RegionalMercator.EASTING_AT_FALSE_ORIGIN);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, RegionalMercator.NORTHING_AT_FALSE_ORIGIN);
                break;
            }
            case 1: {
                roles.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, Mercator1SP.LATITUDE_OF_ORIGIN);
            }
            default: {
                roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, Mercator1SP.FALSE_EASTING);
                roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, Mercator1SP.FALSE_NORTHING);
            }
        }
        return new Initializer(method, parameters, roles, variant);
    }

    private Mercator(Initializer initializer) {
        super(initializer);
        super.computeCoefficients();
        this.variant = initializer.variant;
        double \u03bb0 = initializer.getAndStore(Mercator1SP.LONGITUDE_OF_ORIGIN);
        double \u03c60 = Math.toRadians(initializer.getAndStore(this.variant == 2 ? RegionalMercator.LATITUDE_OF_FALSE_ORIGIN : Mercator1SP.LATITUDE_OF_ORIGIN));
        double \u03c61 = Math.toRadians(initializer.getAndStore(Mercator2SP.STANDARD_PARALLEL));
        DoubleDouble k0 = DoubleDouble.verbatim(initializer.scaleAt\u03c6(Math.sin(\u03c61), Math.cos(\u03c61)));
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertBefore(0, k0, null);
        denormalize.convertBefore(1, k0, null);
        if (\u03bb0 != 0.0) {
            DoubleDouble offset = DoubleDouble.createDegreesToRadians();
            offset.multiply(-\u03bb0);
            denormalize.convertBefore(0, null, offset);
        }
        if (\u03c60 != 0.0) {
            denormalize.convertBefore(1, null, DoubleDouble.verbatim(-Math.log(this.expOfNorthing(\u03c60, this.eccentricity * Math.sin(\u03c60)))));
        }
        if (this.variant == 4) {
            normalize.convertBefore(1, 0.8, null);
            denormalize.convertBefore(1, 1.25, null);
        }
        if (\u03c60 == 0.0 && MathFunctions.isPositive(\u03c61 != 0.0 ? \u03c61 : \u03c60)) {
            DoubleDouble reverseSign = DoubleDouble.verbatim(-1.0);
            normalize.convertBefore(1, reverseSign, null);
            denormalize.convertBefore(1, reverseSign, null);
        }
    }

    Mercator(Mercator other) {
        super(other);
        this.variant = other.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        Mercator kernel = this;
        if ((this.variant & 1) != 0 || this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        if (dstPts != null) {
            double a;
            double y = \u03c6 == 0.0 ? \u03c6 : ((a = Math.abs(\u03c6)) < 1.5707963267948966 ? Math.log(this.expOfNorthing(\u03c6, this.eccentricity * sin\u03c6)) : Math.copySign(a <= 1.5707963283655673 ? Double.POSITIVE_INFINITY : Double.NaN, \u03c6));
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = y;
        }
        return derivate ? new Matrix2(1.0, 0.0, 0.0, this.dy_d\u03c6(sin\u03c6, Math.cos(\u03c6))) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            --dstOff;
            while (--numPts >= 0) {
                double \u03c6 = dstPts[dstOff += 2];
                if (\u03c6 == 0.0) continue;
                double a = Math.abs(\u03c6);
                double y = a < 1.5707963267948966 ? Math.log(this.expOfNorthing(\u03c6, this.eccentricity * Math.sin(\u03c6))) : Math.copySign(a <= 1.5707963283655673 ? Double.POSITIVE_INFINITY : Double.NaN, \u03c6);
                dstPts[dstOff] = y;
            }
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = this.\u03c6(Math.exp(-y));
    }

    static final class Spherical
    extends Mercator {
        private static final long serialVersionUID = 2383414176395616561L;

        Spherical(Mercator other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
            double \u03c6 = srcPts[srcOff + 1];
            if (dstPts != null) {
                double a;
                double y = \u03c6 == 0.0 ? \u03c6 : ((a = Math.abs(\u03c6)) < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * \u03c6)) : Math.copySign(a <= 1.5707963283655673 ? Double.POSITIVE_INFINITY : Double.NaN, \u03c6));
                dstPts[dstOff] = srcPts[srcOff];
                dstPts[dstOff + 1] = y;
            }
            return derivate ? new Matrix2(1.0, 0.0, 0.0, 1.0 / Math.cos(\u03c6)) : null;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts != dstPts || srcOff != dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                --dstOff;
                while (--numPts >= 0) {
                    double \u03c6 = dstPts[dstOff += 2];
                    if (\u03c6 == 0.0) continue;
                    double a = Math.abs(\u03c6);
                    double y = a < 1.5707963267948966 ? Math.log(Math.tan(0.7853981633974483 + 0.5 * \u03c6)) : Math.copySign(a <= 1.5707963283655673 ? Double.POSITIVE_INFINITY : Double.NaN, \u03c6);
                    dstPts[dstOff] = y;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
        }
    }
}

