/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class NormalizedProjection
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -4010883312927645853L;
    static final double ANGULAR_TOLERANCE = 1.5706706731410455E-9;
    static final double ITERATION_TOLERANCE = 3.926676682852614E-10;
    static final int MAXIMUM_ITERATIONS = 15;
    private static final Map<Class<?>, ParameterDescriptorGroup> DESCRIPTORS = new HashMap();
    final ContextualParameters context;
    protected final double eccentricity;
    protected final double eccentricitySquared;
    private final MathTransform2D inverse;

    protected NormalizedProjection(OperationMethod method, Parameters parameters, Map<ParameterRole, ? extends ParameterDescriptor<? extends Number>> roles) {
        this(new Initializer(method, parameters, roles, 0));
    }

    NormalizedProjection(Initializer initializer) {
        this.context = initializer.context;
        this.eccentricitySquared = initializer.eccentricitySquared.value;
        this.eccentricity = Math.sqrt(this.eccentricitySquared);
        this.inverse = new Inverse();
    }

    NormalizedProjection(NormalizedProjection other) {
        this.context = other.context;
        this.eccentricity = other.eccentricity;
        this.eccentricitySquared = other.eccentricitySquared;
        this.inverse = new Inverse();
    }

    static boolean identMatch(OperationMethod method, String regex, String identifier) {
        if (identifier != null) {
            for (ReferenceIdentifier id : method.getIdentifiers()) {
                if (!"EPSG".equals(id.getCodeSpace())) continue;
                return identifier.equals(id.getCode());
            }
        }
        return method.getName().getCode().replace('_', ' ').matches(regex);
    }

    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        return this.context.completeTransform(factory, this);
    }

    final MathTransform delegate(MathTransformFactory factory, String name) throws FactoryException {
        OperationMethod method = factory instanceof DefaultMathTransformFactory ? ((DefaultMathTransformFactory)factory).getOperationMethod(name) : ReferencingServices.getInstance().getOperationMethod(factory.getAvailableMethods(SingleOperation.class), name);
        if (method instanceof MathTransformProvider) {
            return ((MathTransformProvider)((Object)method)).createMathTransform(factory, this.context);
        }
        throw new FactoryException(Errors.format((short)127, (method != null ? method : factory).getClass()));
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup group = this.getParameterDescriptors().createValue();
        group.parameter("eccentricity").setValue(this.eccentricity);
        String[] names = this.getInternalParameterNames();
        double[] values = this.getInternalParameterValues();
        for (int i = 0; i < names.length; ++i) {
            group.parameter(names[i]).setValue(values[i]);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ParameterDescriptorGroup group;
        Class<?> type = this.getClass();
        while (!Modifier.isPublic(type.getModifiers())) {
            type = type.getSuperclass();
        }
        Map<Class<?>, ParameterDescriptorGroup> map = DESCRIPTORS;
        synchronized (map) {
            group = DESCRIPTORS.get(type);
            if (group == null) {
                ParameterBuilder builder = new ParameterBuilder().setRequired(true);
                if (Utilities.isSIS(type)) {
                    builder.setCodeSpace(Citations.SIS, "SIS");
                }
                String[] names = this.getInternalParameterNames();
                GeneralParameterDescriptor[] parameters = new ParameterDescriptor[names.length + 1];
                parameters[0] = MapProjection.ECCENTRICITY;
                for (int i = 1; i < parameters.length; ++i) {
                    parameters[i] = ((ParameterBuilder)builder.addName(names[i - 1])).create(Double.class, null);
                }
                group = ((ParameterBuilder)builder.addName(CharSequences.camelCaseToSentence(type.getSimpleName()) + " (radians domain)")).createGroup(1, 1, parameters);
                DESCRIPTORS.put(type, group);
            }
        }
        return group;
    }

    String[] getInternalParameterNames() {
        return CharSequences.EMPTY_ARRAY;
    }

    double[] getInternalParameterValues() {
        return null;
    }

    @Override
    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws ProjectionException;

    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        long c = Double.doubleToLongBits(this.eccentricity);
        double[] parameters = this.getInternalParameterValues();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                c = c * 31L + Double.doubleToLongBits(parameters[i]);
            }
        }
        return super.computeHashCode() ^ Numerics.hashCode(c);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        double[] parameters;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        NormalizedProjection that = (NormalizedProjection)object;
        switch (mode) {
            case STRICT: 
            case BY_CONTRACT: {
                if (!Objects.equals(this.context, that.context)) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.eccentricitySquared, that.eccentricitySquared)) break;
                return false;
            }
            default: {
                double e = Math.max(this.eccentricity, that.eccentricity);
                if (Numerics.epsilonEqual(this.eccentricity, that.eccentricity, 1.5706706731410455E-9 * (1.0 / e - e))) break;
                assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference("eccentricity", this.eccentricity, that.eccentricity);
                return false;
            }
        }
        if ((parameters = this.getInternalParameterValues()) != null) {
            double[] others = that.getInternalParameterValues();
            assert (others.length == parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                if (Numerics.epsilonEqual(parameters[i], others[i], mode)) continue;
                assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference(this.getInternalParameterNames()[i], parameters[i], others[i]);
                return false;
            }
        }
        return true;
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        private static final long serialVersionUID = -9138242780765956870L;

        public Inverse() {
            super(NormalizedProjection.this);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            if (!derivate) {
                NormalizedProjection.this.inverseTransform(srcPts, srcOff, dstPts, dstOff);
                return null;
            }
            if (dstPts == null) {
                dstPts = new double[2];
                dstOff = 0;
            }
            NormalizedProjection.this.inverseTransform(srcPts, srcOff, dstPts, dstOff);
            return Matrices.inverse(NormalizedProjection.this.transform(dstPts, dstOff, null, 0, true));
        }
    }

    protected static enum ParameterRole {
        SEMI_MAJOR,
        SEMI_MINOR,
        LATITUDE_OF_CONFORMAL_SPHERE_RADIUS,
        CENTRAL_MERIDIAN,
        SCALE_FACTOR,
        FALSE_EASTING,
        FALSE_WESTING,
        FALSE_NORTHING,
        FALSE_SOUTHING;

    }
}

