/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class AbstractMathTransform
extends FormattableObject
implements MathTransform,
Parameterized,
LenientComparable {
    static final int MAXIMUM_BUFFER_SIZE = 512;
    static final int MAXIMUM_FAILURES = 32;
    private transient int hashCode;

    protected AbstractMathTransform() {
    }

    @Override
    public abstract int getSourceDimensions();

    @Override
    public abstract int getTargetDimensions();

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ContextualParameters parameters = this.getContextualParameters();
        return parameters != null ? parameters.getDescriptor() : null;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    protected ContextualParameters getContextualParameters() {
        return null;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    static MismatchedDimensionException mismatchedDimension(String argument, int expected, int dimension) {
        return new MismatchedDimensionException(Errors.format((short)59, argument, expected, dimension));
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches("ptSrc", dimSource, ptSrc);
        if (ptDst != null) {
            int i;
            double[] array;
            ArgumentChecks.ensureDimensionMatches("ptDst", dimTarget, ptDst);
            if (dimSource >= dimTarget) {
                array = ptSrc.getCoordinate();
            } else {
                array = new double[dimTarget];
                i = dimSource;
                while (--i >= 0) {
                    array[i] = ptSrc.getOrdinate(i);
                }
            }
            this.transform(array, 0, array, 0, false);
            for (i = 0; i < dimTarget; ++i) {
                ptDst.setOrdinate(i, array[i]);
            }
        } else {
            double[] source;
            GeneralDirectPosition destination = new GeneralDirectPosition(dimTarget);
            if (dimSource <= dimTarget) {
                source = destination.ordinates;
                for (int i = 0; i < dimSource; ++i) {
                    source[i] = ptSrc.getOrdinate(i);
                }
            } else {
                source = ptSrc.getCoordinate();
            }
            this.transform(source, 0, destination.ordinates, 0, false);
            ptDst = destination;
        }
        return ptDst;
    }

    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws TransformException;

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (numPts <= 0) {
            return;
        }
        double[] dstFinal = null;
        int offFinal = 0;
        int srcInc = this.getSourceDimensions();
        int dstInc = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dstFinal = dstPts;
                    dstPts = new double[numPts * dstInc];
                    offFinal = dstOff;
                    dstOff = 0;
                }
            }
        }
        TransformException failure = null;
        int failureCount = 0;
        int blockStart = 0;
        do {
            block14: {
                try {
                    this.transform(srcPts, srcOff, dstPts, dstOff, false);
                }
                catch (TransformException exception) {
                    if ((failureCount += Math.abs(srcInc)) > 32) {
                        throw failure;
                    }
                    Arrays.fill(dstPts, dstOff, dstOff + Math.abs(dstInc), Double.NaN);
                    if (failure == null) {
                        failure = exception;
                        blockStart = srcOff;
                    }
                    if (Math.abs(srcOff - blockStart) <= 512) break block14;
                    failureCount = 0;
                    blockStart = srcOff;
                }
            }
            srcOff += srcInc;
            dstOff += dstInc;
        } while (--numPts != 0);
        if (dstFinal != null) {
            System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
        }
        if (failure != null) {
            failure.setLastCompletedTransform(this);
            throw failure;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        if (numPts <= 0) {
            return;
        }
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        int dimLargest = Math.max(dimSource, dimTarget);
        int numBufferedPts = numPts;
        int bufferSize = numPts * dimLargest;
        if (bufferSize > 512) {
            numBufferedPts = Math.max(1, 512 / dimLargest);
            bufferSize = numBufferedPts * dimLargest;
        }
        int srcInc = dimSource * numBufferedPts;
        int dstInc = dimTarget * numBufferedPts;
        int srcStop = srcInc;
        int dstStop = dstInc;
        if (srcPts == dstPts) {
            int numPass = (numPts + numBufferedPts - 1) / numBufferedPts;
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPass)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    int delta = numPts - numBufferedPts;
                    srcOff += delta * dimSource;
                    dstOff += delta * dimTarget;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dimSource);
                    srcOff = 0;
                }
            }
        }
        int bufferedSrcOff = dimSource >= dimTarget ? 0 : dstStop - srcStop;
        double[] buffer = new double[bufferSize];
        TransformException failure = null;
        do {
            int i;
            block17: {
                if (numPts < numBufferedPts) {
                    numBufferedPts = numPts;
                    srcStop = numPts * dimSource;
                    dstStop = numPts * dimTarget;
                    if (srcInc < 0) {
                        srcOff -= srcStop + srcInc;
                        dstOff -= dstStop + dstInc;
                    }
                }
                for (i = 0; i < srcStop; ++i) {
                    buffer[bufferedSrcOff + i] = srcPts[srcOff + i];
                }
                assert (!IterationStrategy.suggest((int)bufferedSrcOff, (int)dimSource, (int)0, (int)dimTarget, (int)numBufferedPts).needBuffer);
                try {
                    this.transform(buffer, bufferedSrcOff, buffer, 0, numBufferedPts);
                }
                catch (TransformException exception) {
                    if (exception.getLastCompletedTransform() != this) {
                        throw exception;
                    }
                    if (failure != null) break block17;
                    failure = exception;
                }
            }
            for (i = 0; i < dstStop; ++i) {
                dstPts[dstOff + i] = (float)buffer[i];
            }
            srcOff += srcInc;
            dstOff += dstInc;
        } while ((numPts -= numBufferedPts) != 0);
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        if (numPts <= 0) {
            return;
        }
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        int numBufferedPts = numPts;
        int bufferSize = numPts * dimTarget;
        if (bufferSize > 512) {
            numBufferedPts = Math.max(1, 512 / dimTarget);
            bufferSize = numBufferedPts * dimTarget;
        }
        int srcLength = numBufferedPts * dimSource;
        int dstLength = numBufferedPts * dimTarget;
        double[] buffer = new double[bufferSize];
        TransformException failure = null;
        do {
            block9: {
                if (numPts < numBufferedPts) {
                    numBufferedPts = numPts;
                    srcLength = numPts * dimSource;
                    dstLength = numPts * dimTarget;
                }
                try {
                    this.transform(srcPts, srcOff, buffer, 0, numBufferedPts);
                }
                catch (TransformException exception) {
                    if (exception.getLastCompletedTransform() != this) {
                        throw exception;
                    }
                    if (failure != null) break block9;
                    failure = exception;
                }
            }
            for (int i = 0; i < dstLength; ++i) {
                dstPts[dstOff++] = (float)buffer[i];
            }
            srcOff += srcLength;
        } while ((numPts -= numBufferedPts) != 0);
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimTarget;
        if (numPts <= 0) {
            return;
        }
        int dimSource = this.getSourceDimensions();
        if (dimSource == (dimTarget = this.getTargetDimensions())) {
            int n = numPts * dimSource;
            for (int i = 0; i < n; ++i) {
                dstPts[dstOff + i] = srcPts[srcOff + i];
            }
            this.transform(dstPts, dstOff, dstPts, dstOff, numPts);
            return;
        }
        int numBufferedPts = numPts;
        int bufferSize = numPts * dimSource;
        if (bufferSize > 512) {
            numBufferedPts = Math.max(1, 512 / dimSource);
            bufferSize = numBufferedPts * dimSource;
        }
        int srcLength = numBufferedPts * dimSource;
        int dstLength = numBufferedPts * dimTarget;
        double[] buffer = new double[bufferSize];
        TransformException failure = null;
        do {
            block11: {
                if (numPts < numBufferedPts) {
                    numBufferedPts = numPts;
                    srcLength = numPts * dimSource;
                    dstLength = numPts * dimTarget;
                }
                for (int i = 0; i < srcLength; ++i) {
                    buffer[i] = srcPts[srcOff++];
                }
                try {
                    this.transform(buffer, 0, dstPts, dstOff, numBufferedPts);
                }
                catch (TransformException exception) {
                    if (exception.getLastCompletedTransform() != this) {
                        throw exception;
                    }
                    if (failure != null) break block11;
                    failure = exception;
                }
            }
            dstOff += dstLength;
        } while ((numPts -= numBufferedPts) != 0);
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        double[] coordinate = point.getCoordinate();
        if (coordinate.length != dimSource) {
            throw AbstractMathTransform.mismatchedDimension("point", dimSource, coordinate.length);
        }
        Matrix derivative = this.transform(coordinate, 0, null, 0, true);
        if (derivative == null) {
            throw new TransformException(Errors.format((short)1));
        }
        return derivative;
    }

    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Errors.format((short)82));
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst, MathTransformFactory factory) throws FactoryException {
        return null;
    }

    public final int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = this.computeHashCode();
            if (hash == 0) {
                hash = -1;
            }
            this.hashCode = hash;
        }
        assert (hash == -1 || hash == this.computeHashCode()) : this;
        return hash;
    }

    protected int computeHashCode() {
        return this.getClass().hashCode() + this.getSourceDimensions() + 31 * this.getTargetDimensions();
    }

    @Override
    public final boolean equals(Object object) {
        boolean eq = this.equals(object, ComparisonMode.STRICT);
        assert (!eq || this.computeHashCode() == ((AbstractMathTransform)object).computeHashCode()) : this;
        return eq;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object != null && this.getClass() == object.getClass()) {
            int oc;
            int tc;
            AbstractMathTransform that = (AbstractMathTransform)object;
            if (!mode.isApproximative() && (tc = this.hashCode) != 0 && (oc = that.hashCode) != 0 && tc != oc) {
                return false;
            }
            if (mode.isIgnoringMetadata()) {
                return true;
            }
            return Utilities.deepEquals(this.getContextualParameters(), that.getContextualParameters(), mode);
        }
        return false;
    }

    int beforeFormat(List<Object> transforms, int index, boolean inverse) {
        assert (AbstractMathTransform.unwrap(transforms.get(index), inverse) == this);
        ContextualParameters parameters = this.getContextualParameters();
        return parameters != null ? parameters.beforeFormat(transforms, index, inverse) : index;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendParamMT(this.getParameterValues(), formatter);
        return "Param_MT";
    }

    private static Object unwrap(Object object, boolean inverse) {
        return inverse ? ((Inverse)object).inverse() : object;
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public final int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public final int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            if (point != null) {
                point = this.transform(point, null);
            }
            return Matrices.inverse(AbstractMathTransform.this.derivative(point));
        }

        @Override
        public MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        protected int computeHashCode() {
            return super.computeHashCode() + 31 * AbstractMathTransform.this.hashCode();
        }

        @Override
        public boolean equals(Object object, ComparisonMode mode) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                return AbstractMathTransform.this.equals(((Inverse)object).inverse(), mode);
            }
            return false;
        }

        @Override
        int beforeFormat(List<Object> transforms, int index, boolean inverse) {
            ContextualParameters parameters = this.getContextualParameters();
            if (parameters != null) {
                return parameters.beforeFormat(transforms, index, inverse);
            }
            return AbstractMathTransform.this.beforeFormat(transforms, index, !inverse);
        }

        @Override
        protected String formatTo(Formatter formatter) {
            ParameterValueGroup parameters = this.getParameterValues();
            if (parameters != null) {
                WKTUtilities.appendParamMT(parameters, formatter);
                return "Param_MT";
            }
            formatter.newLine();
            formatter.append(AbstractMathTransform.this);
            return "Inverse_MT";
        }
    }
}

