/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractMathTransform1D
extends AbstractMathTransform
implements MathTransform1D {
    protected AbstractMathTransform1D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 1;
    }

    @Override
    public final int getTargetDimensions() {
        return 1;
    }

    @Override
    public abstract double transform(double var1) throws TransformException;

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double ordinate = srcPts[srcOff];
        if (dstPts != null) {
            dstPts[dstOff] = this.transform(ordinate);
        }
        return derivate ? new Matrix1(this.derivative(ordinate)) : null;
    }

    @Override
    public abstract double derivative(double var1) throws TransformException;

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        double ordinate;
        if (point == null) {
            ordinate = Double.NaN;
        } else {
            ArgumentChecks.ensureDimensionMatches("point", 1, point);
            ordinate = point.getOrdinate(0);
        }
        return new Matrix1(this.derivative(ordinate));
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }

    protected abstract class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform1D {
        private static final long serialVersionUID = 2018412413506158560L;

        protected Inverse() {
        }

        @Override
        public MathTransform1D inverse() {
            return (MathTransform1D)super.inverse();
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double ordinate = srcPts[srcOff];
            if (dstPts != null) {
                dstPts[dstOff] = this.transform(ordinate);
            }
            return derivate ? new Matrix1(this.derivative(ordinate)) : null;
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            double ordinate;
            if (point == null) {
                ordinate = Double.NaN;
            } else {
                ArgumentChecks.ensureDimensionMatches("point", 1, point);
                ordinate = point.getOrdinate(0);
            }
            return new Matrix1(this.derivative(ordinate));
        }
    }
}

