/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.apache.sis.internal.referencing.j2d.ShapeUtilities;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractMathTransform2D
extends AbstractMathTransform
implements MathTransform2D {
    protected AbstractMathTransform2D() {
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        return AbstractMathTransform2D.transform(this, ptSrc, ptDst);
    }

    static Point2D transform(AbstractMathTransform tr, Point2D ptSrc, Point2D ptDst) throws TransformException {
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        tr.transform(ord, 0, ord, 0, false);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    @Override
    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
    }

    static Shape createTransformedShape(MathTransform2D mt, Shape shape, AffineTransform preTransform, AffineTransform postTransform, boolean horizontal) throws TransformException {
        PathIterator it = shape.getPathIterator(preTransform);
        Path2D.Double path = new Path2D.Double(it.getWindingRule());
        double[] buffer = new double[6];
        double ax = 0.0;
        double ay = 0.0;
        double px = 0.0;
        double py = 0.0;
        while (!it.isDone()) {
            block11: {
                switch (it.currentSegment(buffer)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        path.closePath();
                        break block11;
                    }
                    case 0: {
                        ax = buffer[0];
                        ay = buffer[1];
                        mt.transform(buffer, 0, buffer, 0, 1);
                        px = buffer[0];
                        py = buffer[1];
                        path.moveTo(px, py);
                        break block11;
                    }
                    case 1: {
                        double d = ax;
                        ax = buffer[0];
                        buffer[0] = 0.5 * (d + ax);
                        double d2 = ay;
                        ay = buffer[1];
                        buffer[1] = 0.5 * (d2 + ay);
                        buffer[2] = ax;
                        buffer[3] = ay;
                        break;
                    }
                    case 2: {
                        double d = ax;
                        ax = buffer[2];
                        buffer[0] = 0.5 * (buffer[0] + 0.5 * (d + ax));
                        double d3 = ay;
                        ay = buffer[3];
                        buffer[1] = 0.5 * (buffer[1] + 0.5 * (d3 + ay));
                        break;
                    }
                    case 3: {
                        double d = ax;
                        ax = buffer[4];
                        buffer[0] = 0.25 * (1.5 * (buffer[0] + buffer[2]) + 0.5 * (d + ax));
                        double d4 = ay;
                        ay = buffer[5];
                        buffer[1] = 0.25 * (1.5 * (buffer[1] + buffer[3]) + 0.5 * (d4 + ay));
                        buffer[2] = ax;
                        buffer[3] = ay;
                    }
                }
                mt.transform(buffer, 0, buffer, 0, 2);
                Point2D.Double ctrlPoint = ShapeUtilities.parabolicControlPoint(px, py, buffer[0], buffer[1], buffer[2], buffer[3], horizontal);
                px = buffer[2];
                py = buffer[3];
                if (ctrlPoint != null) {
                    path.quadTo(((Point2D)ctrlPoint).getX(), ((Point2D)ctrlPoint).getY(), px, py);
                } else {
                    path.lineTo(px, py);
                }
            }
            it.next();
        }
        if (postTransform != null) {
            path.transform(postTransform);
        }
        return ShapeUtilities.toPrimitive(path);
    }

    @Override
    public Matrix derivative(Point2D point) throws TransformException {
        return AbstractMathTransform2D.derivative(this, point);
    }

    static Matrix derivative(AbstractMathTransform tr, Point2D point) throws TransformException {
        double[] coordinate = new double[]{point.getX(), point.getY()};
        Matrix derivative = tr.transform(coordinate, 0, null, 0, true);
        if (derivative == null) {
            throw new TransformException(Errors.format((short)1));
        }
        return derivative;
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }

    protected abstract class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D {
        private static final long serialVersionUID = 5751908928042026412L;

        protected Inverse() {
        }

        @Override
        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }

        @Override
        public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
            return AbstractMathTransform2D.transform(this, ptSrc, ptDst);
        }

        @Override
        public Shape createTransformedShape(Shape shape) throws TransformException {
            return this.isIdentity() ? shape : AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
        }

        @Override
        public Matrix derivative(Point2D point) throws TransformException {
            return AbstractMathTransform2D.derivative(this, point);
        }
    }
}

