/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class CartesianToPolar
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 7698079127743791414L;
    static final CartesianToPolar INSTANCE = new CartesianToPolar();

    private Object readResolve() {
        return INSTANCE;
    }

    private CartesianToPolar() {
        super("Cartesian to polar", 2);
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, DoubleDouble.createRadiansToDegrees(), null);
    }

    @Override
    public MathTransform inverse() {
        return PolarToCartesian.INSTANCE;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double r = Math.hypot(x, y);
        if (dstPts != null) {
            dstPts[dstOff] = r;
            dstPts[dstOff + 1] = Math.atan2(y, x);
        }
        if (!derivate) {
            return null;
        }
        double r2 = r * r;
        return new Matrix2(x / r, y / r, -y / r2, x / r2);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 2, dstOff, 2, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += 2 * (numPts - 1);
                    dstOff += 2 * (numPts - 1);
                    srcInc = -4;
                    dstInc = -4;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 2);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = Math.hypot(x, y);
            dstPts[dstOff++] = Math.atan2(y, x);
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }
}

