/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;

public abstract class DatumShiftTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -4492222496475405226L;
    final ContextualParameters context;
    final DatumShiftGrid<?, ?> grid;

    DatumShiftTransform(ParameterDescriptorGroup descriptor, DatumShiftGrid<?, ?> grid) {
        int size = grid.getTranslationDimensions() + 1;
        this.context = new ContextualParameters(descriptor, size, size);
        this.grid = grid;
    }

    DatumShiftTransform(ParameterDescriptorGroup descriptor, boolean isSource3D, boolean isTarget3D, DatumShiftGrid<?, ?> grid) {
        this.context = new ContextualParameters(descriptor, isSource3D ? 4 : 3, isTarget3D ? 4 : 3);
        this.grid = grid;
    }

    static void ensureGeocentricTranslation(DatumShiftGrid<?, ?> grid, Unit<Length> unit) throws IllegalArgumentException {
        int dim = grid.getTranslationDimensions();
        if (dim != 3) {
            throw new MismatchedDimensionException(Errors.format((short)59, "grid", 3, dim));
        }
        Object unitLabel = "ratio";
        if (grid.isCellValueRatio() || (unitLabel = grid.getTranslationUnit()) != unit) {
            throw new IllegalArgumentException(Errors.format((short)43, "translation", unitLabel));
        }
    }

    final void setContextParameters(double semiMajor, double semiMinor, Unit<Length> unit, Ellipsoid target) {
        UnitConverter c = target.getAxisUnit().getConverterTo(unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(semiMajor, unit);
        this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(semiMinor, unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MAJOR).setValue(c.convert(target.getSemiMajorAxis()), unit);
        this.context.getOrCreate(Molodensky.TGT_SEMI_MINOR).setValue(c.convert(target.getSemiMinorAxis()), unit);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.context;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return super.equals(object, mode) && Objects.equals(this.grid, ((DatumShiftTransform)object).grid);
    }
}

