/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class IdentityTransform
extends AbstractLinearTransform {
    private static final long serialVersionUID = -5339040282922138164L;
    private static final LinearTransform[] IDENTITIES = new LinearTransform[8];
    private final int dimension;

    private IdentityTransform(int dimension) {
        this.dimension = dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinearTransform create(int dimension) {
        LinearTransform[] linearTransformArray = IDENTITIES;
        synchronized (IDENTITIES) {
            LinearTransform candidate;
            if (dimension < IDENTITIES.length && (candidate = IDENTITIES[dimension]) != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return candidate;
            }
            switch (dimension) {
                default: {
                    candidate = new IdentityTransform(dimension);
                    break;
                }
                case 1: {
                    candidate = IdentityTransform1D.INSTANCE;
                    break;
                }
                case 2: {
                    candidate = new AffineTransform2D(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                }
            }
            if (dimension < IDENTITIES.length) {
                IdentityTransform.IDENTITIES[dimension] = candidate;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return candidate;
        }
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public double getElement(int row, int column) {
        return row == column ? 1.0 : 0.0;
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return Matrices.createIdentity(this.dimension);
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) {
        ArgumentChecks.ensureDimensionMatches("ptSrc", this.dimension, ptSrc);
        if (ptDst == null) {
            return new GeneralDirectPosition(ptSrc);
        }
        ArgumentChecks.ensureDimensionMatches("ptDst", this.dimension, ptDst);
        for (int i = 0; i < this.dimension; ++i) {
            ptDst.setOrdinate(i, ptSrc.getOrdinate(i));
        }
        return ptDst;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.dimension);
        }
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        numPts *= this.dimension;
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)srcPts[srcOff++];
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        numPts *= this.dimension;
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++];
        }
    }

    @Override
    public LinearTransform inverse() {
        return this;
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        return ((IdentityTransform)object).dimension == this.dimension;
    }
}

