/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.NTv2;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class InterpolatedTransform
extends DatumShiftTransform {
    private static final long serialVersionUID = -8962688502524486475L;
    private static final int GRID_DIMENSION = 2;
    private final int dimension;
    private final Inverse inverse;

    protected <T extends Quantity> InterpolatedTransform(DatumShiftGrid<T, T> grid) throws NoninvertibleMatrixException {
        super(grid instanceof DatumShiftGridFile ? ((DatumShiftGridFile)grid).descriptor : NTv2.PARAMETERS, grid);
        Unit<Angle> normalized;
        if (!grid.isCellValueRatio()) {
            throw new IllegalArgumentException(Errors.format((short)144, "isCellValueRatio", Boolean.FALSE));
        }
        Unit<T> unit = grid.getTranslationUnit();
        if (unit != grid.getCoordinateUnit()) {
            throw new IllegalArgumentException(Errors.format((short)43, "translation", unit));
        }
        this.dimension = grid.getTranslationDimensions();
        if (grid instanceof DatumShiftGridFile) {
            ((DatumShiftGridFile)grid).setFileParameters(this.context);
        }
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.setMatrix(grid.getCoordinateToGrid().getMatrix());
        Unit<Angle> unit2 = normalized = Units.isAngular(unit) ? NonSI.DEGREE_ANGLE : unit.toSI();
        if (!unit.equals(normalized)) {
            UnitConverter converter = normalized.getConverterTo(unit);
            if (!(converter instanceof LinearConverter)) {
                throw new IllegalArgumentException(Errors.format((short)83, normalized, unit));
            }
            Double offset = converter.convert(0.0);
            Double scale = Units.derivative(converter, 0.0);
            for (int j = 0; j < this.dimension; ++j) {
                normalize.convertBefore(j, scale, offset);
            }
        }
        this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).setMatrix(normalize.inverse());
        this.inverse = this.createInverse();
    }

    public static <T extends Quantity> MathTransform createGeodeticTransformation(MathTransformFactory factory, DatumShiftGrid<T, T> grid) throws FactoryException {
        InterpolatedTransform tr;
        ArgumentChecks.ensureNonNull("grid", grid);
        try {
            tr = grid.getTranslationDimensions() == 2 ? new InterpolatedTransform2D(grid) : new InterpolatedTransform(grid);
        }
        catch (NoninvertibleMatrixException e) {
            throw new FactoryException(e.getLocalizedMessage(), e);
        }
        return tr.context.completeTransform(factory, tr);
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        if (dstPts != null) {
            double[] vector = new double[this.dimension];
            this.grid.interpolateInCell(x, y, vector);
            if (this.dimension > 2) {
                System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, this.dimension - 2);
                int i = this.dimension;
                do {
                    int n = dstOff + --i;
                    dstPts[n] = dstPts[n] + vector[i];
                } while (i > 2);
            }
            dstPts[dstOff + 1] = y + vector[1];
            dstPts[dstOff] = x + vector[0];
        }
        if (!derivate) {
            return null;
        }
        return this.grid.derivativeInCell(x, y);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int inc = this.dimension;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, inc, dstOff, inc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * inc;
                    dstOff += (numPts - 1) * inc;
                    inc = -inc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * inc);
                    srcOff = 0;
                }
            }
        }
        double[] vector = new double[this.dimension];
        while (--numPts >= 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            this.grid.interpolateInCell(x, y, vector);
            if (this.dimension > 2) {
                System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, this.dimension - 2);
                int i = this.dimension;
                do {
                    int n = dstOff + --i;
                    dstPts[n] = dstPts[n] + vector[i];
                } while (i > 2);
            }
            dstPts[dstOff + 1] = y + vector[1];
            dstPts[dstOff] = x + vector[0];
            dstOff += inc;
            srcOff += inc;
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    Inverse createInverse() {
        return new Inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Objects.hashCode(this.grid);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        return super.equals(object, mode) && Objects.equals(this.grid, ((InterpolatedTransform)object).grid);
    }

    class Inverse
    extends AbstractMathTransform.Inverse {
        private static final long serialVersionUID = -6779719408779847014L;
        private final double tolerance;

        Inverse() {
            this.tolerance = InterpolatedTransform.this.grid.getCellPrecision();
            if (!(this.tolerance > 0.0)) {
                throw new IllegalArgumentException(Errors.format((short)132, "grid.cellPrecision", this.tolerance));
            }
        }

        @Override
        public final Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double yi;
            double xi;
            if (dstPts == null) {
                dstPts = new double[InterpolatedTransform.this.dimension];
                dstOff = 0;
            }
            double x = xi = srcPts[srcOff];
            double y = yi = srcPts[srcOff + 1];
            double[] vector = new double[InterpolatedTransform.this.dimension];
            int it = 15;
            do {
                InterpolatedTransform.this.grid.interpolateInCell(xi, yi, vector);
                double ox = xi;
                double oy = yi;
                xi = x - vector[0];
                yi = y - vector[1];
                if (Math.abs(xi - ox) > this.tolerance || Math.abs(yi - oy) > this.tolerance) continue;
                if (InterpolatedTransform.this.dimension > 2) {
                    System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, InterpolatedTransform.this.dimension - 2);
                    int i = InterpolatedTransform.this.dimension;
                    do {
                        int n = dstOff + --i;
                        dstPts[n] = dstPts[n] + vector[i];
                    } while (i > 2);
                }
                dstPts[dstOff] = xi;
                dstPts[dstOff + 1] = yi;
                if (derivate) {
                    return Matrices.inverse(InterpolatedTransform.this.derivative(new DirectPositionView(dstPts, dstOff, InterpolatedTransform.this.dimension)));
                }
                return null;
            } while (--it >= 0);
            throw new TransformException(Errors.format((short)181));
        }

        @Override
        public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int inc = InterpolatedTransform.this.dimension;
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, inc, dstOff, inc, numPts)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        srcOff += (numPts - 1) * inc;
                        dstOff += (numPts - 1) * inc;
                        inc = -inc;
                        break;
                    }
                    default: {
                        srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * inc);
                        srcOff = 0;
                    }
                }
            }
            double[] vector = new double[InterpolatedTransform.this.dimension];
            block4: while (--numPts >= 0) {
                double yi;
                double xi;
                double x = xi = srcPts[srcOff];
                double y = yi = srcPts[srcOff + 1];
                int it = 15;
                do {
                    InterpolatedTransform.this.grid.interpolateInCell(xi, yi, vector);
                    double ox = xi;
                    double oy = yi;
                    xi = x - vector[0];
                    yi = y - vector[1];
                    if (Math.abs(xi - ox) > this.tolerance || Math.abs(yi - oy) > this.tolerance) continue;
                    if (InterpolatedTransform.this.dimension > 2) {
                        System.arraycopy(srcPts, srcOff + 2, dstPts, dstOff + 2, InterpolatedTransform.this.dimension - 2);
                        int i = InterpolatedTransform.this.dimension;
                        do {
                            int n = dstOff + --i;
                            dstPts[n] = dstPts[n] + vector[i];
                        } while (i > 2);
                    }
                    dstPts[dstOff] = xi;
                    dstPts[dstOff + 1] = yi;
                    dstOff += inc;
                    srcOff += inc;
                    continue block4;
                } while (--it >= 0);
                throw new TransformException(Errors.format((short)181));
            }
        }
    }
}

