/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.referencing.provider.Interpolation1D;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LinearInterpolator1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = -5025693608589996896L;
    private final double[] values;
    private final double slope;
    private final MathTransform1D inverse;

    private LinearInterpolator1D(double[] values, double slope) {
        this.values = values;
        this.slope = slope;
        double last = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (last <= (last = values[i])) continue;
            this.inverse = null;
            return;
        }
        this.inverse = new Inverse();
    }

    private static MathTransform1D create(double[] values) {
        boolean isReverted;
        int n = values.length - 1;
        double offset = values[0];
        double slope = (values[n] - offset) / (double)n;
        double tolerance = Math.abs(slope) * 1.0E-13;
        int i = 0;
        while (Numerics.epsilonEqual(values[++i] - offset, slope * (double)i, tolerance)) {
            if (i < n) continue;
            return LinearTransform1D.create(slope, offset);
        }
        boolean bl = isReverted = slope < 0.0;
        if (isReverted) {
            slope = -slope;
            for (int i2 = 0; i2 <= n; ++i2) {
                values[i2] = -values[i2];
            }
        }
        AbstractMathTransform tr = new LinearInterpolator1D(values, slope);
        if (isReverted) {
            tr = new ConcatenatedTransformDirect1D((MathTransform1D)((Object)tr), LinearTransform1D.NEGATE);
        }
        return tr;
    }

    static MathTransform1D create(double[] preimage, double[] values) {
        int length;
        if (preimage == null) {
            if (values == null) {
                return IdentityTransform1D.INSTANCE;
            }
            length = values.length;
        } else {
            length = preimage.length;
            if (values != null && values.length != length) {
                throw new IllegalArgumentException(Errors.format((short)56));
            }
        }
        switch (length) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)20, preimage != null ? "preimage" : "values"));
            }
            case 1: {
                return LinearTransform1D.constant(preimage != null ? preimage[0] : Double.NaN, values != null ? values[0] : Double.NaN);
            }
        }
        MathTransform1D tr = null;
        if (values != null) {
            tr = LinearInterpolator1D.create((double[])values.clone());
        }
        if (preimage != null) {
            MathTransform1D indexToValues = tr;
            try {
                tr = LinearInterpolator1D.create((double[])preimage.clone()).inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException(Errors.format((short)221, "preimage"), e);
            }
            if (indexToValues != null) {
                tr = MathTransforms.concatenate(tr, indexToValues);
            }
        }
        return tr;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Interpolation1D.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup p = this.getParameterDescriptors().createValue();
        p.parameter("values").setValue(this.values);
        return p;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == (double)i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double d;
        double y;
        double x = srcPts[srcOff];
        if (x >= 0.0) {
            int i = (int)x;
            int n = this.values.length - 1;
            if (i < n) {
                y = this.values[i] * (1.0 - (x -= (double)i)) + this.values[i + 1] * x;
                d = this.values[i + 1] - this.values[i];
            } else {
                y = (x - (double)n) * this.slope + this.values[n];
                d = this.slope;
            }
        } else {
            y = x * this.slope + this.values[0];
            d = this.slope;
        }
        if (dstPts != null) {
            dstPts[dstOff] = y;
        }
        return derivate ? new Matrix1(d) : null;
    }

    @Override
    public double transform(double x) {
        if (x >= 0.0) {
            int i = (int)x;
            int n = this.values.length - 1;
            if (i < n) {
                return this.values[i] * (1.0 - (x -= (double)i)) + this.values[i + 1] * x;
            }
            return (x - (double)n) * this.slope + this.values[n];
        }
        return x * this.slope + this.values[0];
    }

    @Override
    public double derivative(double x) {
        int i;
        if (x >= 0.0 && (i = (int)x) < this.values.length - 1) {
            return this.values[i + 1] - this.values[i];
        }
        return this.slope;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            return Arrays.equals(this.values, ((LinearInterpolator1D)object).values);
        }
        return false;
    }

    private final class Inverse
    extends AbstractMathTransform1D.Inverse
    implements MathTransform1D {
        private static final long serialVersionUID = 3179638888992528901L;

        Inverse() {
            super(LinearInterpolator1D.this);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double d;
            double x;
            double y = srcPts[srcOff];
            double[] values = LinearInterpolator1D.this.values;
            int i = Arrays.binarySearch(values, y);
            if (i >= 0) {
                x = i;
                d = i >= 1 && i < values.length ? values[i] - values[i - 1] : LinearInterpolator1D.this.slope;
            } else if ((i ^= 0xFFFFFFFF) >= 1) {
                if (i < values.length) {
                    double y0 = values[i - 1];
                    d = values[i] - y0;
                    x = (y - y0) / d + (double)(i - 1);
                } else {
                    int n = values.length - 1;
                    d = LinearInterpolator1D.this.slope;
                    x = (y - values[n]) / d + (double)n;
                }
            } else {
                d = LinearInterpolator1D.this.slope;
                x = (y - values[0]) / d;
            }
            if (dstPts != null) {
                dstPts[dstOff] = x;
            }
            return derivate ? new Matrix1(1.0 / d) : null;
        }

        @Override
        public double transform(double y) {
            double[] values = LinearInterpolator1D.this.values;
            int i = Arrays.binarySearch(values, y);
            if (i >= 0) {
                return i;
            }
            if ((i ^= 0xFFFFFFFF) >= 1) {
                if (i < values.length) {
                    double y0 = values[i - 1];
                    return (y - y0) / (values[i] - y0) + (double)(i - 1);
                }
                int n = values.length - 1;
                return (y - values[n]) / LinearInterpolator1D.this.slope + (double)n;
            }
            return (y - values[0]) / LinearInterpolator1D.this.slope;
        }

        @Override
        public double derivative(double y) {
            double[] values = LinearInterpolator1D.this.values;
            int i = Arrays.binarySearch(values, y);
            if (i < 0) {
                i ^= 0xFFFFFFFF;
            }
            double d = i >= 1 && i < values.length ? values[i] - values[i - 1] : LinearInterpolator1D.this.slope;
            return 1.0 / d;
        }
    }
}

