/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class LinearTransform1D
extends AbstractMathTransform1D
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -7595037195668813000L;
    static final LinearTransform1D NEGATE = new LinearTransform1D(-1.0, 0.0);
    final double scale;
    final double offset;
    private transient MathTransform1D inverse;

    protected LinearTransform1D(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public static LinearTransform1D create(double scale, double offset) {
        if (offset == 0.0) {
            if (scale == 1.0) {
                return IdentityTransform1D.INSTANCE;
            }
            if (scale == -1.0) {
                return NEGATE;
            }
        }
        if (scale == 0.0) {
            if (offset == 0.0) {
                return ConstantTransform1D.ZERO;
            }
            if (offset == 1.0) {
                return ConstantTransform1D.ONE;
            }
            return new ConstantTransform1D(offset);
        }
        return new LinearTransform1D(scale, offset);
    }

    static LinearTransform1D constant(double x, double y) {
        LinearTransform1D tr = LinearTransform1D.create(0.0, y);
        if (!Double.isNaN(x)) {
            tr.inverse = LinearTransform1D.create(0.0, x);
        }
        return tr;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.getProvider(1, 1, true).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this.getMatrix());
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix2(this.scale, this.offset, 0.0, 1.0);
    }

    @Override
    public LinearTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.scale != 0.0) {
                LinearTransform1D inverse = LinearTransform1D.create(1.0 / this.scale, -this.offset / this.scale);
                inverse.inverse = this;
                this.inverse = inverse;
            } else {
                this.inverse = super.inverse();
            }
        }
        return (LinearTransform1D)this.inverse;
    }

    @Override
    public boolean isAffine() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return this.offset == 0.0 && this.scale == 1.0;
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        return new Matrix1(this.scale);
    }

    @Override
    public double derivative(double value) {
        return this.scale;
    }

    @Override
    public double transform(double value) {
        return this.offset + this.scale * value;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            dstPts[dstOff] = this.offset + this.scale * srcPts[srcOff];
        }
        return derivate ? new Matrix1(this.scale) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.offset + this.scale * srcPts[srcOff++];
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.offset + this.scale * srcPts[--srcOff];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.offset + this.scale * (double)srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.offset + this.scale * (double)srcPts[--srcOff]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)(this.offset + this.scale * srcPts[srcOff++]);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = this.offset + this.scale * (double)srcPts[srcOff++];
        }
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.scale * srcPts[srcOff++];
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.scale * srcPts[--srcOff];
            }
        }
    }

    @Override
    protected int computeHashCode() {
        return Numerics.hashCode(Double.doubleToRawLongBits(this.offset) + 31L * Double.doubleToRawLongBits(this.scale)) ^ super.computeHashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (mode != ComparisonMode.STRICT) {
            if (object instanceof LinearTransform) {
                return Matrices.equals(this.getMatrix(), ((LinearTransform)object).getMatrix(), mode);
            }
        } else if (super.equals(object, mode)) {
            LinearTransform1D that = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(that.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(that.offset);
        }
        return false;
    }

    @Override
    public String toString() {
        return Matrices.toString(this.getMatrix());
    }
}

