/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.DatumShiftTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

abstract class MolodenskyFormula
extends DatumShiftTransform {
    private static final long serialVersionUID = 7684676923384073055L;
    static final double ANGULAR_SCALE = 1.0000000000039175;
    final boolean isSource3D;
    final boolean isTarget3D;
    final boolean isAbridged;
    protected final double tX;
    protected final double tY;
    protected final double tZ;
    final double \u0394a;
    final double \u0394fmod;
    protected final double semiMajor;
    protected final double eccentricitySquared;

    MolodenskyFormula(MolodenskyFormula inverse, Ellipsoid source, Ellipsoid target, ParameterDescriptorGroup descriptor) {
        this(target, inverse.isTarget3D, source, inverse.isSource3D, -inverse.tX, -inverse.tY, -inverse.tZ, inverse.grid, inverse.isAbridged, descriptor);
    }

    MolodenskyFormula(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, DatumShiftGrid<?, ?> grid, boolean isAbridged, ParameterDescriptorGroup descriptor) {
        super(descriptor, isSource3D, isTarget3D, grid);
        ArgumentChecks.ensureNonNull("source", source);
        ArgumentChecks.ensureNonNull("target", target);
        DefaultEllipsoid src = DefaultEllipsoid.castOrCopy(source);
        this.isSource3D = isSource3D;
        this.isTarget3D = isTarget3D;
        this.isAbridged = isAbridged;
        this.semiMajor = src.getSemiMajorAxis();
        this.\u0394a = src.semiMajorAxisDifference(target);
        this.tX = tX;
        this.tY = tY;
        this.tZ = tZ;
        double semiMinor = src.getSemiMinorAxis();
        double \u0394f = src.flatteningDifference(target);
        this.eccentricitySquared = src.getEccentricitySquared();
        this.\u0394fmod = isAbridged ? this.semiMajor * \u0394f + (this.semiMajor - semiMinor) * (this.\u0394a / this.semiMajor) : semiMinor * \u0394f;
        Unit<Length> unit = src.getAxisUnit();
        this.setContextParameters(this.semiMajor, semiMinor, unit, target);
        this.completeParameters(this.context, semiMinor, unit, \u0394f);
        this.context.normalizeGeographicInputs(0.0);
        this.context.denormalizeGeographicOutputs(0.0);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Unit<?> unit = this.context.getOrCreate(Molodensky.SRC_SEMI_MAJOR).getUnit();
        double semiMinor = this.context.getOrCreate(Molodensky.SRC_SEMI_MINOR).doubleValue(unit);
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(Molodensky.SRC_SEMI_MAJOR).setValue(this.semiMajor, unit);
        pg.getOrCreate(Molodensky.SRC_SEMI_MINOR).setValue(semiMinor, unit);
        this.completeParameters(pg, semiMinor, unit, Double.NaN);
        return pg;
    }

    void completeParameters(Parameters pg, double semiMinor, Unit<?> unit, double \u0394f) {
        pg.getOrCreate(Molodensky.DIMENSION).setValue(this.getSourceDimensions());
    }

    @Override
    public final int getSourceDimensions() {
        return this.isSource3D ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.isTarget3D ? 3 : 2;
    }

    final Matrix transform(double \u03bb, double \u03c6, double h, double[] dstPts, int dstOff, double tX, double tY, double tZ, double[] offset, boolean derivate) throws TransformException {
        double \u03c6t;
        double \u03bbt;
        double scaleY;
        double scaleX;
        double cms\u03c6;
        double cms\u03bb;
        double spc\u03bb;
        double sin\u03bb = Math.sin(\u03bb);
        double cos\u03bb = Math.cos(\u03bb);
        double sin\u03c6 = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        double sin2\u03c6 = sin\u03c6 * sin\u03c6;
        double \u03bd2den = 1.0 - this.eccentricitySquared * sin2\u03c6;
        double \u03bdden = Math.sqrt(\u03bd2den);
        double \u03c1den = \u03bd2den * \u03bdden;
        double \u03c1 = this.semiMajor * (1.0 - this.eccentricitySquared) / \u03c1den;
        double \u03bd = this.semiMajor / \u03bdden;
        double t = this.\u0394fmod * 2.0;
        if (!this.isAbridged) {
            \u03c1 += h;
            \u03bd += h;
            t = t * (0.5 / \u03bdden + 0.5 / \u03c1den) + this.\u0394a * this.eccentricitySquared / \u03bdden;
        }
        while (true) {
            spc\u03bb = tY * sin\u03bb + tX * cos\u03bb;
            cms\u03bb = tY * cos\u03bb - tX * sin\u03bb;
            cms\u03c6 = (tZ + t * sin\u03c6) * cos\u03c6 - spc\u03bb * sin\u03c6;
            scaleX = 1.0000000000039175 / (\u03bd * cos\u03c6);
            scaleY = 1.0000000000039175 / \u03c1;
            \u03bbt = \u03bb + cms\u03bb * scaleX;
            \u03c6t = \u03c6 + cms\u03c6 * scaleY;
            if (offset == null) break;
            this.grid.interpolateInCell(this.grid.normalizedToGridX(\u03bbt), this.grid.normalizedToGridY(\u03c6t), offset);
            tX = -offset[0];
            tY = -offset[1];
            tZ = -offset[2];
            offset = null;
        }
        if (dstPts != null) {
            dstPts[dstOff++] = \u03bbt;
            dstPts[dstOff++] = \u03c6t;
            if (this.isTarget3D) {
                double t1 = this.\u0394fmod * sin2\u03c6;
                double t2 = this.\u0394a;
                if (!this.isAbridged) {
                    t1 /= \u03bdden;
                    t2 *= \u03bdden;
                }
                dstPts[dstOff++] = h + spc\u03bb * cos\u03c6 + tZ * sin\u03c6 + t1 - t2;
            }
        }
        if (!derivate) {
            return null;
        }
        MatrixSIS matrix = Matrices.createDiagonal(this.getTargetDimensions(), this.getSourceDimensions());
        double sin\u03c6cos\u03c6 = sin\u03c6 * cos\u03c6;
        double d\u03bd = this.eccentricitySquared * sin\u03c6cos\u03c6 / \u03bd2den;
        double d\u03bd3\u03c1 = 3.0 * d\u03bd * (1.0 - this.eccentricitySquared) / \u03bd2den;
        double dYd\u03bb = cms\u03bb * sin\u03c6;
        double dZd\u03bb = cms\u03bb * cos\u03c6;
        double dXd\u03c6 = dYd\u03bb / cos\u03c6;
        double dYd\u03c6 = -tZ * sin\u03c6 - cos\u03c6 * spc\u03bb + t * (1.0 - 2.0 * sin2\u03c6);
        double dZd\u03c6 = tZ * cos\u03c6 - sin\u03c6 * spc\u03bb;
        if (this.isAbridged) {
            dXd\u03c6 -= cms\u03bb * d\u03bd;
            dYd\u03c6 -= cms\u03c6 * d\u03bd3\u03c1;
            dZd\u03c6 += t * cos\u03c6 * sin\u03c6;
        } else {
            double d\u03c1 = d\u03bd3\u03c1 * \u03bdden * (this.semiMajor / \u03c1);
            dXd\u03c6 -= d\u03bd * cms\u03bb * this.semiMajor / (\u03bdden * \u03bd);
            dYd\u03c6 -= d\u03c1 * dZd\u03c6 - (this.\u0394fmod * (d\u03bd * 2.0 / (1.0 - this.eccentricitySquared) + (1.0 + 1.0 / \u03bd2den) * (d\u03bd - d\u03c1)) + this.\u0394a * (d\u03bd + 1.0) * this.eccentricitySquared) * sin\u03c6cos\u03c6 / \u03bdden;
            if (this.isSource3D) {
                double dXdh = cms\u03bb / \u03bd;
                double dYdh = -cms\u03c6 / \u03c1;
                matrix.setElement(0, 2, -dXdh * scaleX);
                matrix.setElement(1, 2, dYdh * scaleY);
            }
            double t1 = this.\u0394fmod * (d\u03bd * sin2\u03c6 + 2.0 * sin\u03c6cos\u03c6);
            double t2 = this.\u0394a * d\u03bd;
            dZd\u03c6 += t1 / \u03bdden + t2 * \u03bdden;
        }
        matrix.setElement(0, 0, 1.0 - spc\u03bb * scaleX);
        matrix.setElement(1, 1, 1.0 + dYd\u03c6 * scaleY);
        matrix.setElement(0, 1, dXd\u03c6 * scaleX);
        matrix.setElement(1, 0, -dYd\u03bb * scaleY);
        if (this.isTarget3D) {
            matrix.setElement(2, 0, dZd\u03bb);
            matrix.setElement(2, 1, dZd\u03c6);
        }
        return matrix;
    }

    @Override
    protected int computeHashCode() {
        int code = super.computeHashCode() + Numerics.hashCode(Double.doubleToLongBits(this.\u0394a) + Double.doubleToLongBits(this.\u0394fmod) + 31L * (Double.doubleToLongBits(this.tX) + 31L * (Double.doubleToLongBits(this.tY) + 31L * Double.doubleToLongBits(this.tZ))));
        if (this.isAbridged) {
            code ^= 0xFFFFFFFF;
        }
        return code;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            MolodenskyFormula that = (MolodenskyFormula)object;
            return this.isSource3D == that.isSource3D && this.isTarget3D == that.isTarget3D && this.isAbridged == that.isAbridged && Numerics.epsilonEqual(this.tX, that.tX, mode) && Numerics.epsilonEqual(this.tY, that.tY, mode) && Numerics.epsilonEqual(this.tZ, that.tZ, mode) && Numerics.epsilonEqual(this.\u0394a, that.\u0394a, mode) && Numerics.epsilonEqual(this.\u0394fmod, that.\u0394fmod, mode) && Numerics.epsilonEqual(this.semiMajor, that.semiMajor, mode) && Numerics.epsilonEqual(this.eccentricitySquared, that.eccentricitySquared, mode);
        }
        return false;
    }
}

