/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IdentityTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1673997634240223449L;
    final int firstAffectedOrdinate;
    final int numTrailingOrdinates;
    final MathTransform subTransform;
    PassThroughTransform inverse;

    protected PassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        ArgumentChecks.ensurePositive("firstAffectedOrdinate", firstAffectedOrdinate);
        ArgumentChecks.ensurePositive("numTrailingOrdinates", numTrailingOrdinates);
        if (subTransform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)subTransform;
            this.firstAffectedOrdinate = passThrough.firstAffectedOrdinate + firstAffectedOrdinate;
            this.numTrailingOrdinates = passThrough.numTrailingOrdinates + numTrailingOrdinates;
            this.subTransform = passThrough.subTransform;
        } else {
            this.firstAffectedOrdinate = firstAffectedOrdinate;
            this.numTrailingOrdinates = numTrailingOrdinates;
            this.subTransform = subTransform;
        }
    }

    public static MathTransform create(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        int dimension;
        ArgumentChecks.ensureNonNull("subTransform", subTransform);
        ArgumentChecks.ensurePositive("firstAffectedOrdinate", firstAffectedOrdinate);
        ArgumentChecks.ensurePositive("numTrailingOrdinates", numTrailingOrdinates);
        if (firstAffectedOrdinate == 0 && numTrailingOrdinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getSourceDimensions()) == subTransform.getTargetDimensions()) {
            return IdentityTransform.create(firstAffectedOrdinate + dimension + numTrailingOrdinates);
        }
        Matrix matrix = MathTransforms.getMatrix(subTransform);
        if (matrix != null) {
            matrix = PassThroughTransform.expand(MatrixSIS.castOrCopy(matrix), firstAffectedOrdinate, numTrailingOrdinates, 1);
            return MathTransforms.linear(matrix);
        }
        int dim = subTransform.getSourceDimensions();
        if (subTransform.getTargetDimensions() == dim && (dim += firstAffectedOrdinate + numTrailingOrdinates) == 2) {
            return new PassThroughTransform2D(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
        }
        return new PassThroughTransform(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
    }

    final Matrix toSubMatrix(Matrix matrix) {
        int numCol;
        int numRow = matrix.getNumRow();
        if (numRow != (numCol = matrix.getNumCol())) {
            return null;
        }
        int subDim = this.subTransform.getSourceDimensions();
        MatrixSIS sub = Matrices.createIdentity(subDim + 1);
        int j = numRow;
        while (--j >= 0) {
            int sj = j - this.firstAffectedOrdinate;
            int i = numCol;
            while (--i >= 0) {
                double element = matrix.getElement(j, i);
                if (sj >= 0 && sj < subDim) {
                    boolean pass;
                    int si;
                    if (i == numCol - 1) {
                        si = subDim;
                        pass = true;
                    } else {
                        si = i - this.firstAffectedOrdinate;
                        boolean bl = pass = si >= 0 && si < subDim;
                    }
                    if (pass) {
                        sub.setElement(sj, si, element);
                        continue;
                    }
                }
                if (element == (double)(i == j ? 1 : 0)) continue;
                return null;
            }
        }
        return sub;
    }

    @Override
    public final int getSourceDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getSourceDimensions() + this.numTrailingOrdinates;
    }

    @Override
    public final int getTargetDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getTargetDimensions() + this.numTrailingOrdinates;
    }

    public final int[] getModifiedCoordinates() {
        int[] index = new int[this.subTransform.getSourceDimensions()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i + this.firstAffectedOrdinate;
        }
        return index;
    }

    public final MathTransform getSubTransform() {
        return this.subTransform;
    }

    @Override
    public boolean isIdentity() {
        return this.subTransform.isIdentity();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix derivative = null;
        if (derivate) {
            derivative = this.derivative(new DirectPositionView(srcPts, srcOff, this.getSourceDimensions()));
        }
        if (dstPts != null) {
            this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return derivative;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts) {
            int add = this.firstAffectedOrdinate + this.numTrailingOrdinates;
            int dimSource = subDimSource + add;
            int dimTarget = subDimTarget + add;
            switch (IterationStrategy.suggest(srcOff, dimSource, dstOff, dimTarget, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * dimSource;
                    dstOff += (numPts - 1) * dimTarget;
                    srcStep -= 2 * dimSource;
                    dstStep -= 2 * dimTarget;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dimSource);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.subTransform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts) {
            int add = this.firstAffectedOrdinate + this.numTrailingOrdinates;
            int dimSource = subDimSource + add;
            int dimTarget = subDimTarget + add;
            switch (IterationStrategy.suggest(srcOff, dimSource, dstOff, dimTarget, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * dimSource;
                    dstOff += (numPts - 1) * dimTarget;
                    srcStep -= 2 * dimSource;
                    dstStep -= 2 * dimTarget;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dimSource);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.subTransform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        while (--numPts >= 0) {
            int i;
            for (i = 0; i < this.firstAffectedOrdinate; ++i) {
                dstPts[dstOff++] = (float)srcPts[srcOff++];
            }
            this.subTransform.transform(srcPts, srcOff, dstPts, dstOff, 1);
            srcOff += subDimSource;
            dstOff += subDimTarget;
            for (i = 0; i < this.numTrailingOrdinates; ++i) {
                dstPts[dstOff++] = (float)srcPts[srcOff++];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        while (--numPts >= 0) {
            int i;
            for (i = 0; i < this.firstAffectedOrdinate; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++];
            }
            this.subTransform.transform(srcPts, srcOff, dstPts, dstOff, 1);
            srcOff += subDimSource;
            dstOff += subDimTarget;
            for (i = 0; i < this.numTrailingOrdinates; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        int nSkipped = this.firstAffectedOrdinate + this.numTrailingOrdinates;
        int transDim = this.subTransform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("point", transDim + nSkipped, point);
        GeneralDirectPosition subPoint = new GeneralDirectPosition(transDim);
        for (int i = 0; i < transDim; ++i) {
            subPoint.ordinates[i] = point.getOrdinate(i + this.firstAffectedOrdinate);
        }
        return PassThroughTransform.expand(MatrixSIS.castOrCopy(this.subTransform.derivative(subPoint)), this.firstAffectedOrdinate, this.numTrailingOrdinates, 0);
    }

    private static Matrix expand(MatrixSIS subMatrix, int firstAffectedOrdinate, int numTrailingOrdinates, int affine) {
        int j;
        int j2;
        int nSkipped = firstAffectedOrdinate + numTrailingOrdinates;
        int numSubRow = subMatrix.getNumRow() - affine;
        int numSubCol = subMatrix.getNumCol() - affine;
        int numRow = numSubRow + (nSkipped + affine);
        int numCol = numSubCol + (nSkipped + affine);
        Object[] elements = new Number[numRow * numCol];
        Arrays.fill(elements, (Object)0);
        Integer ONE = 1;
        for (j2 = 0; j2 < firstAffectedOrdinate; ++j2) {
            elements[j2 * numCol + j2] = ONE;
        }
        for (j2 = 0; j2 < numSubRow; ++j2) {
            for (int i = 0; i < numSubCol; ++i) {
                elements[(j2 + firstAffectedOrdinate) * numCol + (i + firstAffectedOrdinate)] = subMatrix.getNumber(j2, i);
            }
        }
        int offset = numSubCol - numSubRow;
        int numRowOut = numSubRow + nSkipped;
        int numColOut = numSubCol + nSkipped;
        for (j = numRowOut - numTrailingOrdinates; j < numRowOut; ++j) {
            elements[j * numCol + (j + offset)] = ONE;
        }
        if (affine != 0) {
            for (j = 0; j < numSubRow; ++j) {
                elements[(j + firstAffectedOrdinate) * numCol + numColOut] = subMatrix.getNumber(j, numSubCol);
            }
            for (int i = 0; i < numSubCol; ++i) {
                elements[numRowOut * numCol + (i + firstAffectedOrdinate)] = subMatrix.getNumber(numSubRow, i);
            }
            elements[numRowOut * numCol + numColOut] = subMatrix.getNumber(numSubRow, numSubCol);
        }
        return Matrices.create(numRow, numCol, (Number[])elements);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedOrdinate, this.subTransform.inverse(), this.numTrailingOrdinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.subTransform.hashCode() + this.firstAffectedOrdinate;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            PassThroughTransform that = (PassThroughTransform)object;
            return this.firstAffectedOrdinate == that.firstAffectedOrdinate && this.numTrailingOrdinates == that.numTrailingOrdinates && Utilities.deepEquals(this.subTransform, that.subTransform, mode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.firstAffectedOrdinate);
        if (this.numTrailingOrdinates != 0) {
            formatter.append(this.numTrailingOrdinates);
            formatter.setInvalidWKT(PassThroughTransform.class, null);
        }
        formatter.append(this.subTransform);
        return "PassThrough_MT";
    }
}

