/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class PassThroughTransform2D
extends PassThroughTransform
implements MathTransform2D {
    private static final long serialVersionUID = -5637760772953973708L;

    PassThroughTransform2D(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        super(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, 1);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    @Override
    public Shape createTransformedShape(Shape shape) throws TransformException {
        return AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
    }

    @Override
    public Matrix derivative(Point2D point) throws TransformException {
        return super.derivative(point instanceof DirectPosition ? (DirectPosition)((Object)point) : new DirectPosition2D(point.getX(), point.getY()));
    }

    @Override
    public synchronized MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform2D(this.firstAffectedOrdinate, this.subTransform.inverse(), this.numTrailingOrdinates);
            this.inverse.inverse = this;
        }
        return (MathTransform2D)((Object)this.inverse);
    }
}

