/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

final class SphericalToCartesian
extends CoordinateSystemTransform
implements Serializable {
    private static final long serialVersionUID = 8001536207920751506L;
    static final SphericalToCartesian INSTANCE = new SphericalToCartesian();

    private Object readResolve() {
        return INSTANCE;
    }

    private SphericalToCartesian() {
        super("Spherical to Cartesian", 3);
        this.context.normalizeGeographicInputs(0.0);
    }

    @Override
    public MathTransform inverse() {
        return CartesianToSpherical.INSTANCE;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        double \u03b8 = srcPts[srcOff];
        double \u03a9 = srcPts[srcOff + 1];
        double r = srcPts[srcOff + 2];
        double cos\u03b8 = Math.cos(\u03b8);
        double sin\u03b8 = Math.sin(\u03b8);
        double cos\u03a9 = Math.cos(\u03a9);
        double sin\u03a9 = Math.sin(\u03a9);
        double rsin\u03a9 = r * sin\u03a9;
        double rcos\u03a9 = r * cos\u03a9;
        if (dstPts != null) {
            dstPts[dstOff] = rcos\u03a9 * cos\u03b8;
            dstPts[dstOff + 1] = rcos\u03a9 * sin\u03b8;
            dstPts[dstOff + 2] = rsin\u03a9;
        }
        if (!derivate) {
            return null;
        }
        double dX_dr = cos\u03a9 * cos\u03b8;
        double dY_dr = cos\u03a9 * sin\u03b8;
        return new Matrix3(-r * dY_dr, -rsin\u03a9 * cos\u03b8, dX_dr, r * dX_dr, -rsin\u03a9 * sin\u03b8, dY_dr, 0.0, rcos\u03a9, sin\u03a9);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int srcInc = 0;
        int dstInc = 0;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, 3, dstOff, 3, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += 3 * (numPts - 1);
                    dstOff += 3 * (numPts - 1);
                    srcInc = -6;
                    dstInc = -6;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * 3);
                    srcOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03b8 = srcPts[srcOff++];
            double \u03a9 = srcPts[srcOff++];
            double r = srcPts[srcOff++];
            double rcos\u03a9 = r * Math.cos(\u03a9);
            dstPts[dstOff++] = rcos\u03a9 * Math.cos(\u03b8);
            dstPts[dstOff++] = rcos\u03a9 * Math.sin(\u03b8);
            dstPts[dstOff++] = r * Math.sin(\u03a9);
            srcOff += srcInc;
            dstOff += dstInc;
        }
    }
}

