/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.referencing.operation.transform.ExponentialTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.LogarithmicTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.content.TransferFunctionType;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;

public class TransferFunction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 185931909755748004L;
    private TransferFunctionType type = TransferFunctionType.LINEAR;
    private double base = 10.0;
    private double scale = 1.0;
    private double offset;
    private MathTransform1D transform;

    public TransferFunctionType getType() {
        return this.type;
    }

    public void setType(TransferFunctionType type) {
        ArgumentChecks.ensureNonNull("type", type);
        this.type = type;
        this.transform = null;
    }

    public double getBase() {
        return TransferFunctionType.LINEAR.equals(this.type) ? 1.0 : this.base;
    }

    public void setBase(double base) {
        ArgumentChecks.ensureStrictlyPositive("base", base);
        this.base = base;
        this.transform = null;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.transform = null;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
        this.transform = null;
    }

    public MathTransform1D getTransform() {
        if (this.transform == null) {
            if (TransferFunctionType.LINEAR.equals(this.type)) {
                this.transform = LinearTransform1D.create(this.scale, this.offset);
            } else if (TransferFunctionType.EXPONENTIAL.equals(this.type)) {
                this.transform = ExponentialTransform1D.create(this.base, this.scale);
                if (this.offset != 0.0) {
                    this.transform = MathTransforms.concatenate(this.transform, LinearTransform1D.create(0.0, this.offset));
                }
            } else if (TransferFunctionType.LOGARITHMIC.equals(this.type)) {
                this.transform = this.scale == 1.0 ? LogarithmicTransform1D.create(this.base, this.offset) : MathTransforms.concatenate(LogarithmicTransform1D.create(this.base, 0.0), LinearTransform1D.create(this.scale, this.offset));
            } else {
                throw new IllegalStateException(Errors.format((short)118, this.type));
            }
        }
        return this.transform;
    }

    public void setTransform(MathTransform1D function) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("function", function);
        if (function instanceof LinearTransform) {
            this.setLinearTerms((LinearTransform)((Object)function));
            this.type = TransferFunctionType.LINEAR;
        } else if (function instanceof ExponentialTransform1D) {
            ExponentialTransform1D f = (ExponentialTransform1D)function;
            this.type = TransferFunctionType.EXPONENTIAL;
            this.base = f.base;
            this.scale = f.scale;
            this.offset = 0.0;
        } else if (function instanceof LogarithmicTransform1D) {
            LogarithmicTransform1D f = (LogarithmicTransform1D)function;
            this.type = TransferFunctionType.LOGARITHMIC;
            this.base = f.base();
            this.offset = f.offset();
            this.scale = 1.0;
        } else {
            LogarithmicTransform1D.Base10 log = LogarithmicTransform1D.Base10.INSTANCE;
            MathTransform1D f = MathTransforms.concatenate(function, log);
            if (f instanceof LinearTransform) {
                this.setLinearTerms((LinearTransform)((Object)f));
                this.type = TransferFunctionType.EXPONENTIAL;
                this.base = 10.0;
            } else {
                f = MathTransforms.concatenate(((LogarithmicTransform1D)log).inverse(), function);
                if (f instanceof LinearTransform) {
                    this.setLinearTerms((LinearTransform)((Object)f));
                    this.type = TransferFunctionType.LOGARITHMIC;
                    this.base = 10.0;
                } else {
                    throw new IllegalArgumentException(Errors.format((short)118, function.getClass()));
                }
            }
        }
        this.transform = function;
    }

    private void setLinearTerms(LinearTransform function) throws IllegalArgumentException {
        Matrix m = function.getMatrix();
        int numRow = m.getNumRow();
        int numCol = m.getNumCol();
        if (numRow != 2 || numCol != 2) {
            Integer two = 2;
            throw new IllegalArgumentException(Errors.format((short)60, two, two, numRow, numCol));
        }
        this.scale = m.getElement(0, 0);
        this.offset = m.getElement(0, 1);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("y = ");
        if (this.scale != 1.0) {
            if (this.scale == -1.0) {
                b.append('\u2212');
            } else {
                StringBuilders.trimFractionalPart(b.append(this.scale).append('\u22c5'));
            }
        }
        if (TransferFunctionType.LINEAR.equals(this.type)) {
            b.append('x');
        } else if (TransferFunctionType.EXPONENTIAL.equals(this.type)) {
            if (this.base == Math.E) {
                b.append('e');
            } else {
                StringBuilders.trimFractionalPart(b.append(this.base));
            }
            b.append('\u02e3');
        } else if (TransferFunctionType.LOGARITHMIC.equals(this.type)) {
            if (this.base == Math.E) {
                b.append("ln");
            } else {
                b.append('\u33d2');
                if (this.base != 10.0) {
                    int c = (int)this.base;
                    if ((double)c == this.base && c >= 0 && c <= 9) {
                        b.append(Characters.toSubScript((char)(c - 48)));
                    } else {
                        StringBuilders.trimFractionalPart(b.append(this.base));
                    }
                }
            }
            b.append('\u24b3');
        } else {
            b.append('?');
        }
        if (this.offset != 0.0) {
            StringBuilders.trimFractionalPart(b.append(' ').append(this.offset < 0.0 ? (char)'\u2212' : '+').append(' ').append(Math.abs(this.offset)));
        }
        return b.toString();
    }
}

