/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeProviderPair;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class DataStoreRegistry {
    private final ServiceLoader<DataStoreProvider> loader;

    DataStoreRegistry() {
        this.loader = ServiceLoader.load(DataStoreProvider.class);
    }

    DataStoreRegistry(ClassLoader loader) {
        ArgumentChecks.ensureNonNull("loader", loader);
        this.loader = ServiceLoader.load(DataStoreProvider.class, loader);
    }

    public String probeContentType(Object storage) throws DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        ProbeProviderPair p = this.lookup(storage, false);
        return p != null ? p.probe.getMimeType() : null;
    }

    public DataStore open(Object storage) throws UnsupportedStorageException, DataStoreException {
        ArgumentChecks.ensureNonNull("storage", storage);
        return this.lookup((Object)storage, (boolean)true).store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProbeProviderPair lookup(Object storage, boolean open) throws DataStoreException {
        StorageConnector connector = storage instanceof StorageConnector ? (StorageConnector)storage : new StorageConnector(storage);
        ProbeProviderPair selected = null;
        LinkedList<ProbeProviderPair> deferred = null;
        try {
            DataStoreProvider provider;
            Iterator<DataStoreProvider> providers;
            ServiceLoader<DataStoreProvider> serviceLoader = this.loader;
            synchronized (serviceLoader) {
                providers = this.loader.iterator();
                provider = providers.hasNext() ? providers.next() : null;
            }
            while (provider != null) {
                ProbeResult probe = provider.probeContent(connector);
                if (probe.isSupported()) {
                    selected = new ProbeProviderPair(provider, probe);
                    deferred = null;
                    break;
                }
                if (ProbeResult.INSUFFICIENT_BYTES.equals(probe)) {
                    if (deferred == null) {
                        deferred = new LinkedList<ProbeProviderPair>();
                    }
                    deferred.add(new ProbeProviderPair(provider, probe));
                } else if (ProbeResult.UNDETERMINED.equals(probe)) {
                    selected = new ProbeProviderPair(provider, probe);
                }
                ServiceLoader<DataStoreProvider> serviceLoader2 = this.loader;
                synchronized (serviceLoader2) {
                    provider = providers.hasNext() ? providers.next() : null;
                }
            }
            if (deferred != null) {
                block10: while (!deferred.isEmpty() && connector.prefetch()) {
                    Iterator it = deferred.iterator();
                    while (it.hasNext()) {
                        ProbeProviderPair p = (ProbeProviderPair)it.next();
                        p.probe = provider.probeContent(connector);
                        if (p.probe.isSupported()) {
                            selected = p;
                            break block10;
                        }
                        if (ProbeResult.INSUFFICIENT_BYTES.equals(p.probe)) continue;
                        if (ProbeResult.UNDETERMINED.equals(p.probe)) {
                            selected = p;
                        }
                        it.remove();
                    }
                }
            }
            if (open && selected != null) {
                selected.store = selected.provider.open(connector);
                connector = null;
            }
        }
        finally {
            if (connector != null && connector != storage) {
                connector.closeAllExcept(null);
            }
        }
        if (open && selected == null) {
            throw new UnsupportedStorageException(Errors.format((short)115, connector.getStorageName()));
        }
        return selected;
    }
}

