/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

public final class ArgumentChecks
extends Static {
    private ArgumentChecks() {
    }

    public static void ensureNonNull(String name, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format((short)95, name));
        }
    }

    public static void ensureNonNullElement(String name, int index, Object element) throws NullArgumentException {
        if (element == null) {
            StringBuilder buffer = new StringBuilder(name);
            int s = name.indexOf("[#]");
            if (s >= 0) {
                buffer.setLength(s + 1);
                buffer.append(index).append(name, s + 2, name.length());
            } else {
                buffer.append('[').append(index).append(']');
            }
            throw new NullArgumentException(Errors.format((short)95, buffer.toString()));
        }
    }

    public static void ensureNonEmpty(String name, CharSequence text) throws NullArgumentException, IllegalArgumentException {
        if (text == null) {
            throw new NullArgumentException(Errors.format((short)95, name));
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException(Errors.format((short)20, name));
        }
    }

    public static void ensureCanCast(String name, Class<?> expectedType, Object value) throws IllegalArgumentException {
        Class<?> valueClass;
        if (value != null && !expectedType.isAssignableFrom(valueClass = value.getClass())) {
            Object[] args;
            short key;
            if (name != null) {
                key = 29;
                args = new Object[]{name, expectedType, valueClass};
            } else {
                key = 34;
                args = new Object[]{expectedType, valueClass};
            }
            throw new IllegalArgumentException(Errors.format(key, args));
        }
    }

    public static void ensureValidIndex(int upper, int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= upper) {
            throw new IndexOutOfBoundsException(Errors.format((short)49, index));
        }
    }

    public static void ensureValidIndexRange(int length, int lower, int upper) throws IndexOutOfBoundsException {
        if (lower < 0 || upper < lower || upper > length) {
            throw new IndexOutOfBoundsException(Errors.format((short)41, lower, upper));
        }
    }

    public static void ensurePositive(String name, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException(Errors.format((short)67, name, value));
        }
    }

    public static void ensurePositive(String name, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException(Errors.format((short)67, name, value));
        }
    }

    public static void ensurePositive(String name, float value) throws IllegalArgumentException {
        if (!(value >= 0.0f)) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)67, name, Float.valueOf(value)));
        }
    }

    public static void ensurePositive(String name, double value) throws IllegalArgumentException {
        if (!(value >= 0.0)) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)67, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, int value) throws IllegalArgumentException {
        if (value <= 0) {
            throw new IllegalArgumentException(Errors.format((short)132, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, long value) throws IllegalArgumentException {
        if (value <= 0L) {
            throw new IllegalArgumentException(Errors.format((short)132, name, value));
        }
    }

    public static void ensureStrictlyPositive(String name, float value) throws IllegalArgumentException {
        if (!(value > 0.0f)) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)132, name, Float.valueOf(value)));
        }
    }

    public static void ensureStrictlyPositive(String name, double value) throws IllegalArgumentException {
        if (!(value > 0.0)) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)132, name, value));
        }
    }

    public static void ensureFinite(String name, float value) {
        boolean isNaN = Float.isNaN(value);
        if (isNaN || Float.isInfinite(value)) {
            throw new IllegalArgumentException(Errors.format(isNaN ? (short)89 : 51, name));
        }
    }

    public static void ensureFinite(String name, double value) {
        boolean isNaN = Double.isNaN(value);
        if (isNaN || Double.isInfinite(value)) {
            throw new IllegalArgumentException(Errors.format(isNaN ? (short)89 : 51, name));
        }
    }

    public static void ensureBetween(String name, int min, int max, int value) throws IllegalArgumentException {
        if (value < min || value > max) {
            throw new IllegalArgumentException(Errors.format((short)133, name, min, max, value));
        }
    }

    public static void ensureBetween(String name, long min, long max, long value) throws IllegalArgumentException {
        if (value < min || value > max) {
            throw new IllegalArgumentException(Errors.format((short)133, name, min, max, value));
        }
    }

    public static void ensureBetween(String name, float min, float max, float value) throws IllegalArgumentException {
        if (!(value >= min) || !(value <= max)) {
            throw new IllegalArgumentException(Float.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)133, name, Float.valueOf(min), Float.valueOf(max), Float.valueOf(value)));
        }
    }

    public static void ensureBetween(String name, double min, double max, double value) throws IllegalArgumentException {
        if (!(value >= min) || !(value <= max)) {
            throw new IllegalArgumentException(Double.isNaN(value) ? Errors.format((short)89, name) : Errors.format((short)133, name, min, max, value));
        }
    }

    public static void ensureSizeBetween(String name, int min, int max, int size) throws IllegalArgumentException {
        String message;
        if (size < min) {
            message = min == 1 ? Errors.format((short)20, name) : Errors.format((short)53, name, min, size);
        } else if (size > max) {
            message = Errors.format((short)24, name, max, size);
        } else {
            return;
        }
        throw new IllegalArgumentException(message);
    }

    public static void ensureValidUnicodeCodePoint(String name, int code) throws IllegalArgumentException {
        if (!Character.isValidCodePoint(code)) {
            throw new IllegalArgumentException(Errors.format((short)42, name, code < 0 ? Integer.valueOf(code) : "U+" + Integer.toHexString(code).toUpperCase()));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        int dimension;
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null && (dimension = cs.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)59, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, CoordinateSystem cs) throws MismatchedDimensionException {
        int dimension;
        if (cs != null && (dimension = cs.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)59, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, double[] vector) throws MismatchedDimensionException {
        int dimension;
        if (vector != null && (dimension = vector.length) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)59, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, DirectPosition position) throws MismatchedDimensionException {
        int dimension;
        if (position != null && (dimension = position.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)59, name, expected, dimension));
        }
    }

    public static void ensureDimensionMatches(String name, int expected, Envelope envelope) throws MismatchedDimensionException {
        int dimension;
        if (envelope != null && (dimension = envelope.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)59, name, expected, dimension));
        }
    }
}

