/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Static;

public final class ArraysExt
extends Static {
    public static final double[] EMPTY_DOUBLE = new double[0];
    public static final float[] EMPTY_FLOAT = new float[0];
    public static final long[] EMPTY_LONG = new long[0];
    public static final int[] EMPTY_INT = new int[0];
    public static final short[] EMPTY_SHORT = new short[0];
    public static final byte[] EMPTY_BYTE = new byte[0];
    public static final char[] EMPTY_CHAR = new char[0];
    public static final boolean[] EMPTY_BOOLEAN = new boolean[0];

    private ArraysExt() {
    }

    public static <E> E[] resize(E[] array, int length) throws NegativeArraySizeException {
        return array == null || array.length == length ? array : Arrays.copyOf(array, length);
    }

    public static double[] resize(double[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_DOUBLE;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static float[] resize(float[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_FLOAT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static long[] resize(long[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_LONG;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static int[] resize(int[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_INT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static short[] resize(short[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_SHORT;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static byte[] resize(byte[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_BYTE;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static char[] resize(char[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_CHAR;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    public static boolean[] resize(boolean[] array, int length) throws NegativeArraySizeException {
        if (array != null) {
            if (length == 0) {
                return EMPTY_BOOLEAN;
            }
            if (array.length != length) {
                return Arrays.copyOf(array, length);
            }
        }
        return array;
    }

    private static <T> T doRemove(T array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (length == 0) {
            return array;
        }
        ArgumentChecks.ensureNonNull("array", array);
        ArgumentChecks.ensurePositive("length", length);
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength -= length);
        System.arraycopy(array, 0, newArray, 0, first);
        System.arraycopy(array, first + length, newArray, first, arrayLength - first);
        return (T)newArray;
    }

    public static <E> E[] remove(E[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doRemove(array, first, length);
    }

    public static double[] remove(double[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_DOUBLE : ArraysExt.doRemove(array, first, length);
    }

    public static float[] remove(float[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_FLOAT : ArraysExt.doRemove(array, first, length);
    }

    public static long[] remove(long[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_LONG : ArraysExt.doRemove(array, first, length);
    }

    public static int[] remove(int[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_INT : ArraysExt.doRemove(array, first, length);
    }

    public static short[] remove(short[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_SHORT : ArraysExt.doRemove(array, first, length);
    }

    public static byte[] remove(byte[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_BYTE : ArraysExt.doRemove(array, first, length);
    }

    public static char[] remove(char[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_CHAR : ArraysExt.doRemove(array, first, length);
    }

    public static boolean[] remove(boolean[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return first == 0 && array != null && length == array.length ? EMPTY_BOOLEAN : ArraysExt.doRemove(array, first, length);
    }

    private static <T> T doInsert(T array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (length == 0) {
            return array;
        }
        ArgumentChecks.ensureNonNull("array", array);
        ArgumentChecks.ensurePositive("length", length);
        int arrayLength = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + length);
        System.arraycopy(array, 0, newArray, 0, first);
        System.arraycopy(array, first, newArray, first + length, arrayLength - first);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static double[] insert(double[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static float[] insert(float[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static long[] insert(long[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static int[] insert(int[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static short[] insert(short[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static byte[] insert(byte[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static char[] insert(char[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    public static boolean[] insert(boolean[] array, int first, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(array, first, length);
    }

    private static <T> T doInsert(T src, int srcOff, T dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        if (length == 0) {
            return dst;
        }
        ArgumentChecks.ensureNonNull("src", src);
        ArgumentChecks.ensureNonNull("dst", dst);
        ArgumentChecks.ensurePositive("length", length);
        int dstLength = Array.getLength(dst);
        Object newArray = Array.newInstance(dst.getClass().getComponentType(), dstLength + length);
        System.arraycopy(dst, 0, newArray, 0, dstOff);
        System.arraycopy(src, srcOff, newArray, dstOff, length);
        System.arraycopy(dst, dstOff, newArray, dstOff + length, dstLength - dstOff);
        return (T)newArray;
    }

    public static <E> E[] insert(E[] src, int srcOff, E[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static double[] insert(double[] src, int srcOff, double[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static float[] insert(float[] src, int srcOff, float[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static long[] insert(long[] src, int srcOff, long[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static int[] insert(int[] src, int srcOff, int[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static short[] insert(short[] src, int srcOff, short[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static byte[] insert(byte[] src, int srcOff, byte[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static char[] insert(char[] src, int srcOff, char[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static boolean[] insert(boolean[] src, int srcOff, boolean[] dst, int dstOff, int length) throws NullArgumentException, IllegalArgumentException, IndexOutOfBoundsException {
        return ArraysExt.doInsert(src, srcOff, dst, dstOff, length);
    }

    public static <T> T[] append(T[] array, T element) throws NullArgumentException {
        ArgumentChecks.ensureNonNull("array", array);
        T[] copy = Arrays.copyOf(array, array.length + 1);
        copy[array.length] = element;
        return copy;
    }

    public static int removeDuplicated(Object[] array) {
        int length;
        if (array == null) {
            return 0;
        }
        int i = length = array.length;
        block0: while (--i >= 0) {
            Object value = array[i];
            int j = i;
            while (--j >= 0) {
                if (!Objects.equals(array[j], value)) continue;
                System.arraycopy(array, i + 1, array, i, --length - i);
                array[length] = null;
                continue block0;
            }
        }
        return length;
    }

    public static void reverse(Object[] entries) {
        if (entries != null) {
            int i = entries.length >>> 1;
            int j = i + (entries.length & 1);
            while (--i >= 0) {
                Object tmp = entries[i];
                entries[i] = entries[j];
                entries[j++] = tmp;
            }
        }
    }

    public static void reverse(int[] values) {
        if (values != null) {
            int i = values.length >>> 1;
            int j = i + (values.length & 1);
            while (--i >= 0) {
                int tmp = values[i];
                values[i] = values[j];
                values[j++] = tmp;
            }
        }
    }

    public static <E> boolean isSorted(E[] array, Comparator<? super E> comparator, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            E p = array[i];
            if (p == null) continue;
            while (++i < array.length) {
                E e = array[i];
                if (e == null) continue;
                int c = comparator.compare(e, p);
                if (strict ? c <= 0 : c < 0) {
                    return false;
                }
                p = e;
            }
            break;
        }
        return true;
    }

    public static <E extends Comparable<? super E>> boolean isSorted(E[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            E p = array[i];
            if (p == null) continue;
            while (++i < array.length) {
                E e = array[i];
                if (e == null) continue;
                int c = e.compareTo(p);
                if (strict ? c <= 0 : c < 0) {
                    return false;
                }
                p = e;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(double[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            double p = array[i];
            if (Double.isNaN(p)) continue;
            while (++i < array.length) {
                double e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                if (Double.isNaN(e)) continue;
                p = e;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(float[] array, boolean strict) {
        for (int i = 0; i < array.length; ++i) {
            float p = array[i];
            if (Float.isNaN(p)) continue;
            while (++i < array.length) {
                float e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                if (Float.isNaN(e)) continue;
                p = e;
            }
            break;
        }
        return true;
    }

    public static boolean isSorted(long[] array, boolean strict) {
        if (array.length != 0) {
            long p = array[0];
            for (int i = 1; i < array.length; ++i) {
                long e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                p = e;
            }
        }
        return true;
    }

    public static boolean isSorted(int[] array, boolean strict) {
        if (array.length != 0) {
            int p = array[0];
            for (int i = 1; i < array.length; ++i) {
                int e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                p = e;
            }
        }
        return true;
    }

    public static boolean isSorted(short[] array, boolean strict) {
        if (array.length != 0) {
            short p = array[0];
            for (int i = 1; i < array.length; ++i) {
                short e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                p = e;
            }
        }
        return true;
    }

    public static boolean isSorted(byte[] array, boolean strict) {
        if (array.length != 0) {
            byte p = array[0];
            for (int i = 1; i < array.length; ++i) {
                byte e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                p = e;
            }
        }
        return true;
    }

    public static boolean isSorted(char[] array, boolean strict) {
        if (array.length != 0) {
            char p = array[0];
            for (int i = 1; i < array.length; ++i) {
                char e = array[i];
                if (strict ? e <= p : e < p) {
                    return false;
                }
                p = e;
            }
        }
        return true;
    }

    public static void swap(Object[] data, int i0, int i1) {
        Object t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(double[] data, int i0, int i1) {
        double t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(float[] data, int i0, int i1) {
        float t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(long[] data, int i0, int i1) {
        long t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(int[] data, int i0, int i1) {
        int t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(short[] data, int i0, int i1) {
        short t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(byte[] data, int i0, int i1) {
        byte t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static void swap(char[] data, int i0, int i1) {
        char t = data[i0];
        data[i0] = data[i1];
        data[i1] = t;
    }

    public static boolean allEquals(double[] array, double value) {
        if (Double.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Double.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEquals(float[] array, float value) {
        if (Float.isNaN(value)) {
            for (int i = 0; i < array.length; ++i) {
                if (Float.isNaN(array[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasNaN(double[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!Double.isNaN(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNaN(float[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!Float.isNaN(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        if (array != null) {
            for (String element : array) {
                if (!value.equalsIgnoreCase(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIdentity(Object[] array, Object value) {
        if (array != null) {
            for (Object element : array) {
                if (element != value) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (array != null) {
            for (Object element : array) {
                if (!Objects.equals(element, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(Object[] array1, Object[] array2) {
        if (array1 != null) {
            for (Object element : array1) {
                if (!ArraysExt.contains(array2, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T[] concatenate(T[] ... arrays) {
        T[] result = null;
        if (arrays != null) {
            int length = 0;
            for (T[] array : arrays) {
                if (array == null) continue;
                length += array.length;
            }
            int offset = 0;
            for (T[] array : arrays) {
                if (array == null) continue;
                if (result == null) {
                    if (array.length == length) {
                        return array;
                    }
                    result = Arrays.copyOf(array, length);
                } else {
                    System.arraycopy(array, 0, result, offset, array.length);
                }
                offset += array.length;
            }
        }
        return result;
    }

    public static int[] unionOfSorted(int[] array1, int[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        int[] union = new int[array1.length + array2.length];
        int nu = 0;
        int ix = 0;
        int iy = 0;
        while (true) {
            int s;
            int no;
            if (ix == array1.length) {
                no = array2.length - iy;
                System.arraycopy(array2, iy, union, nu, no);
                nu += no;
                break;
            }
            if (iy == array2.length) {
                no = array1.length - ix;
                System.arraycopy(array1, ix, union, nu, no);
                nu += no;
                break;
            }
            int sx = array1[ix];
            int sy = array2[iy];
            if (sx <= sy) {
                s = sx;
                ++ix;
                if (sx == sy) {
                    ++iy;
                }
            } else {
                s = sy;
                ++iy;
            }
            union[nu++] = s;
        }
        union = ArraysExt.resize(union, nu);
        return union;
    }
}

