/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.util.LocalizedException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Vocabulary;

public final class Exceptions
extends Static {
    private Exceptions() {
    }

    public static String getLocalizedMessage(Throwable exception, Locale locale) {
        if (exception == null) {
            return null;
        }
        if (locale != null && exception instanceof LocalizedException) {
            return ((LocalizedException)((Object)exception)).getLocalizedMessage(locale);
        }
        return exception.getLocalizedMessage();
    }

    public static <T extends Throwable> T setMessage(T exception, String message, boolean append) {
        Throwable ne;
        String em;
        if (append && (em = CharSequences.trimWhitespaces(exception.getLocalizedMessage())) != null && !em.isEmpty()) {
            StringBuilder buffer = new StringBuilder(CharSequences.trimWhitespaces(message));
            int length = buffer.length();
            if (length != 0 && Character.isLetterOrDigit(buffer.charAt(length - 1))) {
                buffer.append(". ");
            }
            message = buffer.append(em).toString();
        }
        try {
            ne = (Throwable)exception.getClass().getConstructor(String.class).newInstance(message);
        }
        catch (Exception e) {
            return exception;
        }
        ne.setStackTrace(exception.getStackTrace());
        return (T)ne;
    }

    public static String formatChainedMessages(Locale locale, String header, Throwable cause) {
        ArrayList<String> previousLines = new ArrayList<String>();
        String lineSeparator = JDK7.lineSeparator();
        StringBuilder buffer = null;
        Vocabulary resources = null;
        while (cause != null) {
            SQLException next;
            String message = CharSequences.trimWhitespaces(Exceptions.getLocalizedMessage(cause, locale));
            if (message != null && !message.isEmpty()) {
                if (buffer == null) {
                    buffer = new StringBuilder(128);
                    if ((header = CharSequences.trimWhitespaces(header)) != null && !header.isEmpty()) {
                        buffer.append(header);
                        previousLines.add(header);
                    }
                }
                if (!Exceptions.contains(previousLines, message)) {
                    previousLines.add(message);
                    if (buffer.length() != 0) {
                        buffer.append(lineSeparator);
                        if (resources == null) {
                            resources = Vocabulary.getResources(locale);
                        }
                        buffer.append(resources.getString((short)107, cause.getClass())).append(": ");
                    }
                    buffer.append(message);
                }
            }
            if (cause instanceof SQLException && (next = ((SQLException)cause).getNextException()) != null) {
                cause = next;
                continue;
            }
            cause = cause.getCause();
        }
        if (buffer != null) {
            header = buffer.toString();
        }
        return header;
    }

    private static boolean contains(List<String> previousLines, String message) {
        int i = previousLines.size();
        while (--i >= 0) {
            if (!previousLines.get(i).contains(message)) continue;
            return true;
        }
        return false;
    }
}

