/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class StringBuilders
extends Static {
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private StringBuilders() {
    }

    public static void replace(StringBuilder buffer, char toSearch, char replaceBy) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        if (toSearch != replaceBy) {
            int i = buffer.length();
            while (--i >= 0) {
                if (buffer.charAt(i) != toSearch) continue;
                buffer.setCharAt(i, replaceBy);
            }
        }
    }

    public static void replace(StringBuilder buffer, String toSearch, String replaceBy) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        ArgumentChecks.ensureNonNull("replaceBy", replaceBy);
        if (!toSearch.equals(replaceBy)) {
            int length = toSearch.length();
            int i = buffer.length();
            while ((i = buffer.lastIndexOf(toSearch, i)) >= 0) {
                buffer.replace(i, i + length, replaceBy);
                i -= length;
            }
        }
    }

    public static void replace(StringBuilder buffer, int start, int end, char[] chars) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonNull("chars", chars);
        int length = end - start;
        if (start < 0 || length < 0) {
            throw new StringIndexOutOfBoundsException(Errors.format((short)41, start, end));
        }
        int remaining = chars.length - length;
        if (remaining < 0) {
            buffer.delete(end + remaining, end);
            length = chars.length;
        }
        for (int i = 0; i < length; ++i) {
            buffer.setCharAt(start++, chars[i]);
        }
        if (remaining > 0) {
            buffer.insert(start, chars, length, remaining);
        }
    }

    public static void remove(StringBuilder buffer, String toSearch) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        int length = toSearch.length();
        int i = buffer.lastIndexOf(toSearch);
        while (i >= 0) {
            buffer.delete(i, i + length);
            i = buffer.lastIndexOf(toSearch, i);
        }
    }

    public static void trimFractionalPart(StringBuilder buffer) {
        int c;
        ArgumentChecks.ensureNonNull("buffer", buffer);
        block4: for (int i = buffer.length(); i > 0; i -= Character.charCount(c)) {
            c = buffer.codePointBefore(i);
            switch (c) {
                case 48: {
                    continue block4;
                }
                case 46: {
                    buffer.setLength(i);
                }
            }
            return;
        }
    }

    public static void toASCII(StringBuilder buffer) {
        ArgumentChecks.ensureNonNull("buffer", buffer);
        StringBuilders.toASCII(buffer, buffer);
    }

    static CharSequence toASCII(CharSequence text, StringBuilder buffer) {
        if (text != null) {
            int i = text.length();
            block12: while (i > 0) {
                char cr;
                int c = Character.codePointBefore(text, i);
                int n = Character.charCount(c);
                int r = c - 192;
                i -= n;
                if (r < 0) continue;
                if (r < ASCII.length()) {
                    cr = ASCII.charAt(r);
                } else {
                    block0 : switch (Character.getType(c)) {
                        case 15: 
                        case 16: {
                            buffer.delete(i, i + n);
                            continue block12;
                        }
                        case 13: 
                        case 14: {
                            cr = '\n';
                            break;
                        }
                        case 12: {
                            cr = ' ';
                            break;
                        }
                        case 29: {
                            cr = c == 8216 ? (char)'\'' : '\"';
                            break;
                        }
                        case 30: {
                            cr = c == 8217 ? (char)'\'' : '\"';
                            break;
                        }
                        case 24: {
                            switch (c) {
                                case 8242: {
                                    cr = '\'';
                                    break block0;
                                }
                                case 8243: {
                                    cr = '\"';
                                    break block0;
                                }
                            }
                            continue block12;
                        }
                        default: {
                            continue block12;
                        }
                    }
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length()).append(text);
                    text = buffer;
                }
                if (n == 2) {
                    buffer.deleteCharAt(i + 1);
                }
                buffer.setCharAt(i, cr);
            }
        }
        return text;
    }
}

