/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sis.internal.jdk8.Supplier;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.CacheEntries;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

public class Cache<K, V>
extends AbstractMap<K, V> {
    private final ConcurrentMap<K, Object> map;
    private final Map<K, Integer> costs;
    private long totalCost;
    private final long costLimit;
    private final boolean soft;
    private volatile boolean isKeyCollisionAllowed;
    private volatile transient Set<Map.Entry<K, V>> entries;

    public Cache() {
        this(12, 100L, false);
    }

    public Cache(int initialCapacity, long costLimit, boolean soft) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", initialCapacity);
        ArgumentChecks.ensurePositive("costLimit", costLimit);
        initialCapacity = Containers.hashMapCapacity(initialCapacity);
        this.map = new ConcurrentHashMap<K, Object>(initialCapacity);
        this.costs = new LinkedHashMap<K, Integer>((int)Math.min((long)initialCapacity, costLimit), 0.75f, true);
        this.costLimit = costLimit;
        this.soft = soft;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    static boolean isReservedType(Object value) {
        return value instanceof Handler || value instanceof Reference;
    }

    private static <V> V valueOf(Object value) {
        if (value instanceof Reference) {
            return (V)((Reference)value).get();
        }
        if (value instanceof Handler) {
            return (V)((Supplier)value).get();
        }
        return (V)value;
    }

    @Override
    public V put(K key, V value) {
        Object previous;
        if (Cache.isReservedType(value)) {
            throw new IllegalArgumentException(Errors.format((short)28, "value", value.getClass()));
        }
        if (value != null) {
            previous = this.map.put(key, value);
            DelayedExecutor.schedule(new Strong(key, value));
        } else {
            previous = this.map.remove(key);
        }
        return Cache.valueOf(previous);
    }

    @Override
    public V remove(Object key) {
        return Cache.valueOf(this.map.remove(key));
    }

    @Override
    public V get(Object key) {
        return Cache.valueOf(this.map.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCreate(K key, Callable<? extends V> creator) throws Exception {
        V value = this.peek(key);
        if (value == null) {
            Handler<V> handler = this.lock(key);
            try {
                value = handler.peek();
                if (value == null) {
                    value = creator.call();
                }
            }
            finally {
                handler.putAndUnlock(value);
            }
        }
        return value;
    }

    public V peek(K key) {
        Object value = this.map.get(key);
        if (value instanceof Handler) {
            return null;
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            Object result = ref.get();
            if (result != null && this.map.replace(key, ref, result)) {
                ref.clear();
                DelayedExecutor.schedule(new Strong(key, result));
            }
            return (V)result;
        }
        Object result = value;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler<V> lock(K key) {
        Object value;
        Work handler = new Work(key);
        boolean unlock = true;
        handler.lock.lock();
        try {
            while (true) {
                if ((value = this.map.putIfAbsent(key, handler)) == null) {
                    unlock = false;
                    Work work = handler;
                    return work;
                }
                if (!(value instanceof Reference)) {
                    break;
                }
                Reference ref = (Reference)value;
                Object result = ref.get();
                if (result != null) {
                    if (this.map.replace(key, ref, result)) {
                        ref.clear();
                        DelayedExecutor.schedule(new Strong(key, result));
                    }
                    Simple simple = new Simple(result);
                    return simple;
                }
                if (!this.map.replace(key, ref, handler)) continue;
                unlock = false;
                Work work = handler;
                return work;
            }
        }
        finally {
            if (unlock) {
                handler.lock.unlock();
            }
        }
        if (value instanceof Handler) {
            Work work = (Work)value;
            if (work.lock.isHeldByCurrentThread()) {
                if (this.isKeyCollisionAllowed()) {
                    return new Simple<Object>(null);
                }
                throw new IllegalStateException(Errors.format((short)99, key));
            }
            return work.new Work.Wait();
        }
        assert (!Cache.isReservedType(value)) : value;
        Object result = value;
        return new Simple<Object>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void adjustReferences(K key, V value) {
        int cost = this.cost(value);
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            Integer old = this.costs.put(key, cost);
            if (old != null) {
                cost -= old.intValue();
            }
            if ((this.totalCost += (long)cost) > this.costLimit) {
                Iterator<Map.Entry<K, Integer>> it = this.costs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<K, Integer> entry = it.next();
                    K oldKey = entry.getKey();
                    Object oldValue = this.map.get(oldKey);
                    if (oldValue != null && !Cache.isReservedType(oldValue)) {
                        Reference ref;
                        Reference reference = ref = this.soft ? new Soft(this.map, oldKey, oldValue) : new Weak(this.map, oldKey, oldValue);
                        if (!this.map.replace(oldKey, oldValue, ref)) {
                            ref.clear();
                        }
                    }
                    it.remove();
                    if ((this.totalCost -= (long)entry.getValue().intValue()) > this.costLimit) continue;
                    break;
                }
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entries;
        return es != null ? es : (this.entries = new CacheEntries(this.map.entrySet()));
    }

    public boolean isKeyCollisionAllowed() {
        return this.isKeyCollisionAllowed;
    }

    public void setKeyCollisionAllowed(boolean allowed) {
        this.isKeyCollisionAllowed = allowed;
    }

    protected int cost(V value) {
        return 1;
    }

    private static final class Weak<K, V>
    extends WeakReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Weak(ConcurrentMap<K, Object> map, K key, V value) {
            super(value, ReferenceQueueConsumer.QUEUE);
            this.map = map;
            this.key = key;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    private static final class Soft<K, V>
    extends SoftReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Soft(ConcurrentMap<K, Object> map, K key, V value) {
            super(value, ReferenceQueueConsumer.QUEUE);
            this.map = map;
            this.key = key;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    final class Work
    extends DelayedRunnable.Immediate
    implements Handler<V>,
    Supplier<V> {
        final ReentrantLock lock = new ReentrantLock();
        final K key;
        private V value;

        Work(K key) {
            this.key = key;
        }

        @Override
        public V get() {
            if (this.lock.isHeldByCurrentThread()) {
                return null;
            }
            this.lock.lock();
            Object v = this.value;
            this.lock.unlock();
            return v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V result) throws IllegalStateException {
            boolean done;
            try {
                if (Cache.isReservedType(result)) {
                    throw new IllegalArgumentException(Errors.format((short)28, "result", result.getClass()));
                }
                this.value = result;
                done = result != null ? Cache.this.map.replace(this.key, this, result) : Cache.this.map.remove(this.key, this);
            }
            finally {
                this.lock.unlock();
            }
            if (done) {
                DelayedExecutor.schedule(this);
            }
        }

        @Override
        public void run() {
            Object value = this.value;
            if (value != null) {
                Cache.this.adjustReferences(this.key, value);
            }
        }

        final class Wait
        implements Handler<V> {
            Wait() {
            }

            @Override
            public V peek() {
                return Work.this.get();
            }

            @Override
            public void putAndUnlock(V result) throws IllegalStateException {
                if (result != null && !Cache.this.isKeyCollisionAllowed() && result != Work.this.get()) {
                    throw new IllegalStateException(Errors.format((short)54, Work.this.key));
                }
            }
        }
    }

    private final class Simple<V>
    implements Handler<V> {
        private final V value;

        Simple(V value) {
            this.value = value;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V result) throws IllegalStateException {
            if (result != this.value && !Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException(Errors.format((short)54, "<unknown>"));
            }
        }
    }

    public static interface Handler<V> {
        public V peek();

        public void putAndUnlock(V var1) throws IllegalStateException;
    }

    private final class Strong
    extends DelayedRunnable.Immediate {
        private final K key;
        private final V value;

        Strong(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void run() {
            Cache.this.adjustReferences(this.key, this.value);
        }
    }
}

