/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.DerivedMap;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.resources.Errors;

public final class Containers
extends Static {
    private Containers() {
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <E> List<? extends E> unmodifiableList(E ... array) {
        return UnmodifiableArrayList.wrap(array);
    }

    public static <E> List<? extends E> unmodifiableList(E[] array, int lower, int upper) {
        ArgumentChecks.ensureNonNull("array", array);
        ArgumentChecks.ensureValidIndexRange(array.length, lower, upper);
        return UnmodifiableArrayList.wrap(array, lower, upper);
    }

    public static <S, E> Set<E> derivedSet(Set<S> storage, ObjectConverter<S, E> converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (storage == null) {
            return null;
        }
        return DerivedSet.create(storage, converter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        ArgumentChecks.ensureNonNull("keyConverter", keyConverter);
        ArgumentChecks.ensureNonNull("valueConverter", valueConverter);
        if (storage == null) {
            return null;
        }
        return DerivedMap.create(storage, keyConverter, valueConverter);
    }

    public static <T> T property(Map<?, ?> properties, Object key, Class<T> type) throws IllegalArgumentException {
        if (properties == null) {
            return null;
        }
        Object value = properties.get(key);
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)224, key, type, value.getClass()));
        }
        return (T)value;
    }

    public static int hashMapCapacity(int count) {
        int r = count >>> 2;
        if ((count & 3) != 0) {
            ++r;
        }
        return count + r;
    }
}

