/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.resources.Errors;

class DerivedMap<SK, SV, K, V>
extends AbstractMap<K, V>
implements ObjectConverter<Map.Entry<SK, SV>, Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = -4760466188643114727L;
    protected final Map<SK, SV> storage;
    protected final ObjectConverter<SK, K> keyConverter;
    protected final ObjectConverter<SV, V> valueConverter;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;

    static <SK, SV, K, V> Map<K, V> create(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        Set<FunctionProperty> kp = keyConverter.properties();
        Set<FunctionProperty> vp = valueConverter.properties();
        if (kp.contains((Object)FunctionProperty.INVERTIBLE)) {
            if (vp.contains((Object)FunctionProperty.INVERTIBLE)) {
                return new Invertible<SK, SV, K, V>(storage, keyConverter, valueConverter);
            }
            return new InvertibleKey<SK, SV, K, V>(storage, keyConverter, valueConverter);
        }
        if (vp.contains((Object)FunctionProperty.INVERTIBLE)) {
            return new InvertibleValue<SK, SV, K, V>(storage, keyConverter, valueConverter);
        }
        return new DerivedMap<SK, SV, K, V>(storage, keyConverter, valueConverter);
    }

    private DerivedMap(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        this.storage = storage;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() || this.keySet().isEmpty();
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException {
        return this.put(key, this.keyConverter.inverse().apply(key), this.valueConverter.inverse().apply(value));
    }

    final V put(K original, SK key, SV value) {
        if (key == null) {
            throw new UnconvertibleObjectException(Errors.format((short)31, "key", original));
        }
        return this.valueConverter.apply(this.storage.put(key, value));
    }

    @Override
    public final Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = DerivedSet.create(this.storage.keySet(), this.keyConverter);
        }
        return this.keySet;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = DerivedSet.create(this.storage.entrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public final Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> properties = EnumSet.of(FunctionProperty.INVERTIBLE, FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE);
        properties.retainAll(this.keyConverter.properties());
        properties.retainAll(this.valueConverter.properties());
        return properties;
    }

    @Override
    public final Class<Map.Entry<SK, SV>> getSourceClass() {
        return Map.Entry.class;
    }

    @Override
    public final Class<Map.Entry<K, V>> getTargetClass() {
        return Map.Entry.class;
    }

    @Override
    public final Map.Entry<K, V> apply(Map.Entry<SK, SV> entry) {
        K key = this.keyConverter.apply(entry.getKey());
        V value = this.valueConverter.apply(entry.getValue());
        return key != null ? new AbstractMap.SimpleEntry<K, V>(key, value) : null;
    }

    @Override
    public ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static final class Invertible<SK, SV, K, V>
    extends InvertibleKey<SK, SV, K, V> {
        private static final long serialVersionUID = -6625938922337246124L;
        private final ObjectConverter<V, SV> valueInverse;
        private transient ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse;

        Invertible(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
            super(storage, keyConverter, valueConverter);
            this.valueInverse = valueConverter.inverse();
        }

        @Override
        public boolean containsValue(Object value) {
            Class type = this.valueConverter.getTargetClass();
            return type.isInstance(value) && this.storage.containsValue(this.valueInverse.apply((V)type.cast(value)));
        }

        @Override
        public V put(K key, V value) {
            return this.put(key, this.keyInverse.apply(key), this.valueInverse.apply(value));
        }

        @Override
        public ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse() {
            if (this.inverse == null) {
                this.inverse = new DerivedMap<K, V, SK, SV>(null, this.keyInverse, this.valueInverse);
            }
            return this.inverse;
        }
    }

    private static final class InvertibleValue<SK, SV, K, V>
    extends DerivedMap<SK, SV, K, V> {
        private static final long serialVersionUID = -8290698486357636366L;
        private final ObjectConverter<V, SV> valueInverse;

        InvertibleValue(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
            super(storage, keyConverter, valueConverter);
            this.valueInverse = valueConverter.inverse();
        }

        @Override
        public boolean containsValue(Object value) {
            Class type = this.valueConverter.getTargetClass();
            return type.isInstance(value) && this.storage.containsValue(this.valueInverse.apply((V)type.cast(value)));
        }
    }

    private static class InvertibleKey<SK, SV, K, V>
    extends DerivedMap<SK, SV, K, V> {
        private static final long serialVersionUID = 3499911507293121425L;
        protected final ObjectConverter<K, SK> keyInverse;

        InvertibleKey(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
            super(storage, keyConverter, valueConverter);
            this.keyInverse = keyConverter.inverse();
        }

        @Override
        public final V get(Object key) {
            Class type = this.keyConverter.getTargetClass();
            return type.isInstance(key) ? (V)this.valueConverter.apply(this.storage.get(this.keyInverse.apply((K)type.cast(key)))) : null;
        }

        @Override
        public final V remove(Object key) throws UnsupportedOperationException {
            Class type = this.keyConverter.getTargetClass();
            return type.isInstance(key) ? (V)this.valueConverter.apply(this.storage.remove(this.keyInverse.apply((K)type.cast(key)))) : null;
        }

        @Override
        public final boolean containsKey(Object key) {
            Class type = this.keyConverter.getTargetClass();
            return type.isInstance(key) && this.storage.containsKey(this.keyInverse.apply((K)type.cast(key)));
        }
    }
}

