/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public class IntegerList
extends AbstractList<Integer>
implements RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1241962316404811189L;
    private static final int VALUE_SIZE = 64;
    private static final int BASE_SHIFT = 6;
    private static final int OFFSET_MASK = 63;
    private long[] values;
    private final int bitCount;
    private final int mask;
    private int size;

    public IntegerList(int initialCapacity, int maximalValue) {
        this(initialCapacity, maximalValue, false);
    }

    public IntegerList(int initialCapacity, int maximalValue, boolean fill) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", initialCapacity);
        ArgumentChecks.ensureStrictlyPositive("maximalValue", maximalValue);
        int bitCount = 0;
        do {
            ++bitCount;
        } while ((maximalValue >>>= 1) != 0);
        this.bitCount = bitCount;
        this.mask = (1 << bitCount) - 1;
        this.values = new long[this.length(initialCapacity)];
        if (fill) {
            this.size = initialCapacity;
        }
    }

    private int length(int size) {
        int length = (size *= this.bitCount) >>> 6;
        if ((size & 0x3F) != 0) {
            ++length;
        }
        return length;
    }

    public int maximalValue() {
        return this.mask;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void resize(int size) {
        ArgumentChecks.ensurePositive("size", size);
        if (size > this.size) {
            int base = this.size * this.bitCount;
            int offset = base & 0x3F;
            if (offset != 0 && (base >>>= 6) < this.values.length) {
                int n = base++;
                this.values[n] = this.values[n] & (1L << offset) - 1L;
            }
            int length = this.length(size);
            Arrays.fill(this.values, base, Math.min(length, this.values.length), 0L);
            if (length > this.values.length) {
                this.values = Arrays.copyOf(this.values, length);
            }
        }
        this.size = size;
    }

    public void fill(int value) {
        long p;
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        if (value == 0) {
            p = 0L;
        } else if (value == this.mask) {
            p = -1L;
        } else {
            switch (this.bitCount) {
                case 1: {
                    value |= value << 1;
                }
                case 2: {
                    value |= value << 2;
                }
                case 4: {
                    value |= value << 4;
                }
                case 8: {
                    value |= value << 8;
                }
                case 16: {
                    value |= value << 16;
                }
                case 32: {
                    p = (long)value & 0xFFFFFFFFL | (long)value << 32;
                    break;
                }
                default: {
                    for (int i = 0; i < this.size; ++i) {
                        this.setUnchecked(i, value);
                    }
                    return;
                }
            }
        }
        Arrays.fill(this.values, 0, this.length(this.size), p);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean add(Integer value) throws IllegalArgumentException {
        this.addInt(value);
        return true;
    }

    public void addInt(int value) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        int last = this.size++;
        int length = this.length(this.size);
        if (length > this.values.length) {
            this.values = Arrays.copyOf(this.values, 2 * this.values.length);
        }
        this.setUnchecked(last, value);
    }

    @Override
    public Integer get(int index) throws IndexOutOfBoundsException {
        return this.getInt(index);
    }

    public int getInt(int index) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.size, index);
        return this.getUnchecked(index);
    }

    private int getUnchecked(int index) {
        int base = (index *= this.bitCount) >>> 6;
        int offset = index & 0x3F;
        int value = (int)(this.values[base] >>> offset);
        if ((offset = 64 - offset) < this.bitCount) {
            int high = (int)this.values[++base];
            value |= high << offset;
        }
        return value &= this.mask;
    }

    @Override
    public Integer set(int index, Integer value) throws IndexOutOfBoundsException {
        Integer old = this.get(index);
        this.setInt(index, value);
        return old;
    }

    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.size, index);
        ArgumentChecks.ensureBetween("value", 0, this.mask, value);
        this.setUnchecked(index, value);
    }

    private void setUnchecked(int index, int value) {
        int base = (index *= this.bitCount) >>> 6;
        int offset = index & 0x3F;
        int n = base;
        this.values[n] = this.values[n] & ((long)this.mask << offset ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = base++;
        this.values[n2] = this.values[n2] | (long)value << offset;
        if ((offset = 64 - offset) < this.bitCount) {
            int n3 = base;
            this.values[n3] = this.values[n3] & ((long)this.mask >>> offset ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = base;
            this.values[n4] = this.values[n4] | (long)(value >>>= offset);
        }
    }

    @Override
    public Integer remove(int index) throws IndexOutOfBoundsException {
        Integer old = this.get(index);
        this.removeRange(index, index + 1);
        return old;
    }

    @Override
    public int removeLast() throws NoSuchElementException {
        if (this.size != 0) {
            return this.getUnchecked(--this.size);
        }
        throw new NoSuchElementException();
    }

    @Override
    protected void removeRange(int lower, int upper) {
        ArgumentChecks.ensureValidIndexRange(this.size, lower, upper);
        int lo = lower * this.bitCount;
        int hi = upper * this.bitCount;
        int offset = lo & 0x3F;
        if (offset == (hi & 0x3F)) {
            long mask = (1L << offset) - 1L;
            long save = this.values[lo >>>= 6] & mask;
            System.arraycopy(this.values, hi >>>= 6, this.values, lo, this.length(this.size) - hi);
            this.values[lo] = this.values[lo] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | save;
        } else {
            while (upper < this.size) {
                this.setUnchecked(lower++, this.getUnchecked(upper++));
            }
        }
        this.size -= upper - lower;
    }

    public int occurrence(int value) {
        int count = 0;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (this.getUnchecked(i) != value) continue;
            ++count;
        }
        return count;
    }

    public void trimToSize() {
        this.values = ArraysExt.resize(this.values, this.length(this.size));
    }

    public IntegerList clone() {
        IntegerList clone;
        try {
            clone = (IntegerList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        clone.values = (long[])clone.values.clone();
        return clone;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }
}

