/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public class TableColumn<V>
implements CheckedContainer<V> {
    public static final TableColumn<CharSequence> NAME = new Constant<CharSequence>("NAME", CharSequence.class, 37);
    public static final TableColumn<String> IDENTIFIER = new Constant<String>("IDENTIFIER", String.class, 20);
    public static final TableColumn<Integer> INDEX = new Constant<Integer>("INDEX", Integer.class, 22);
    public static final TableColumn<Class<?>> TYPE = new Constant<Class>("TYPE", Class.class, 56);
    public static final TableColumn<Object> VALUE = new Constant<Object>("VALUE", Object.class, 60);
    public static final TableColumn<CharSequence> VALUE_AS_TEXT = new Constant<CharSequence>("VALUE_AS_TEXT", CharSequence.class, 60);
    public static final TableColumn<Number> VALUE_AS_NUMBER = new Constant<Number>("VALUE_AS_NUMBER", Number.class, 60);
    static final Map<TableColumn<?>, Integer> NAME_MAP = Collections.singletonMap(NAME, 0);
    private final Class<V> type;
    CharSequence header;

    protected TableColumn() {
        this.type = null;
    }

    TableColumn(Class<V> type) {
        this.type = type;
    }

    public TableColumn(Class<V> type, CharSequence header) {
        this.type = type;
        ArgumentChecks.ensureNonNull("type", this.type);
        this.header = header;
        ArgumentChecks.ensureNonNull("header", this.header);
    }

    public synchronized InternationalString getHeader() {
        InternationalString i18n = Types.toInternationalString(this.header);
        this.header = i18n;
        return i18n;
    }

    @Override
    public final Class<V> getElementType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getHeader());
    }

    private static final class Constant<V>
    extends TableColumn<V>
    implements Serializable {
        private static final long serialVersionUID = -3460868641711391888L;
        private final String field;
        private final transient short resourceKey;

        Constant(String field, Class<V> type, short header) {
            super(type);
            this.field = field;
            this.resourceKey = header;
        }

        @Override
        public synchronized InternationalString getHeader() {
            InternationalString i18n = (InternationalString)this.header;
            if (i18n == null) {
                i18n = Vocabulary.formatInternational(this.resourceKey);
                this.header = i18n;
            }
            return i18n;
        }

        private Object readResolve() throws InvalidObjectException {
            try {
                return TableColumn.class.getField(this.field).get(null);
            }
            catch (Exception cause) {
                InvalidObjectException e = new InvalidObjectException(cause.toString());
                e.initCause(cause);
                throw e;
            }
        }
    }
}

