/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

abstract class TreeNodeList
extends AbstractList<TreeTable.Node>
implements CheckedContainer<TreeTable.Node>,
Serializable {
    private static final long serialVersionUID = -8723469207489667631L;
    protected static final int NULL = 0;
    protected static final int THIS = 1;
    protected static final int DRY_RUN = 2;
    protected final TreeTable.Node parent;
    private TreeTable.Node[] children;
    private int size;

    protected TreeNodeList(TreeTable.Node parent) {
        this.parent = parent;
    }

    private boolean isParentOf(TreeTable.Node node) throws IllegalArgumentException {
        if (node == this.parent) {
            throw new IllegalArgumentException(Errors.format((short)73, node));
        }
        TreeTable.Node p = node.getParent();
        if (p == null) {
            return false;
        }
        if (p == this.parent) {
            return true;
        }
        throw new IllegalArgumentException(Errors.format((short)74, node));
    }

    protected abstract void setParentOf(TreeTable.Node var1, int var2) throws IllegalArgumentException;

    @Override
    public final Class<TreeTable.Node> getElementType() {
        return TreeTable.Node.class;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public TreeTable.Node get(int index) {
        ArgumentChecks.ensureValidIndex(this.size, index);
        return this.children[index];
    }

    @Override
    public TreeTable.Node set(int index, TreeTable.Node node) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size, index);
        ArgumentChecks.ensureNonNull("node", node);
        TreeTable.Node old = this.children[index];
        if (old != node) {
            if (this.isParentOf(node)) {
                this.ensureNotPresent(node);
                this.setParentOf(old, 0);
            } else {
                this.setParentOf(node, 2);
                this.setParentOf(old, 0);
                this.setParentOf(node, 1);
            }
            this.children[index] = node;
            ++this.modCount;
        }
        return old;
    }

    @Override
    public void add(int index, TreeTable.Node node) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size + 1, index);
        ArgumentChecks.ensureNonNull("node", node);
        if (this.isParentOf(node)) {
            this.ensureNotPresent(node);
        } else {
            this.setParentOf(node, 1);
        }
        this.addChild(index, node);
    }

    final void addChild(int index, TreeTable.Node node) {
        if (this.children == null) {
            this.children = new TreeTable.Node[4];
        } else if (this.size == this.children.length) {
            this.children = Arrays.copyOf(this.children, this.size * 2);
        }
        System.arraycopy(this.children, index, this.children, index + 1, this.size - index);
        this.children[index] = node;
        ++this.size;
        ++this.modCount;
    }

    private void ensureNotPresent(TreeTable.Node node) throws IllegalArgumentException {
        int i = this.size;
        while (--i >= 0) {
            if (this.children[i] != node) continue;
            throw new IllegalArgumentException(Errors.format((short)19));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRange(int lower, int upper) throws IllegalArgumentException {
        int i;
        ArgumentChecks.ensureValidIndexRange(this.size, lower, upper);
        try {
            for (i = upper; i != lower; --i) {
                this.setParentOf(this.children[i - 1], 0);
            }
        }
        finally {
            ++this.modCount;
            if (this.children != null) {
                System.arraycopy(this.children, upper, this.children, i, this.size - upper);
                Arrays.fill(this.children, upper, this.size, null);
            }
            this.size -= upper - i;
        }
    }

    @Override
    public final TreeTable.Node remove(int index) throws IllegalArgumentException {
        ArgumentChecks.ensureValidIndex(this.size, index);
        TreeTable.Node old = this.children[index];
        this.setParentOf(old, 0);
        System.arraycopy(this.children, index + 1, this.children, index, --this.size - index);
        this.children[this.size] = null;
        ++this.modCount;
        return old;
    }

    @Override
    public boolean remove(Object node) throws IllegalArgumentException {
        int index = this.indexOf(node);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public final boolean contains(Object node) {
        return node instanceof TreeTable.Node && ((TreeTable.Node)node).getParent() == this.parent;
    }

    @Override
    public final int indexOf(Object node) {
        return this.lastIndexOf(node);
    }

    @Override
    public final int lastIndexOf(Object node) {
        if (this.contains(node)) {
            int i = this.size;
            while (--i >= 0) {
                if (this.children[i] != node) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.children, this.size);
    }
}

