/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.io.LineAppender;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.Type;

public class TreeTableFormat
extends TabularFormat<TreeTable> {
    private static final long serialVersionUID = 147992015470098561L;
    static final TreeTableFormat INSTANCE = new TreeTableFormat(null, null);
    private Map<TableColumn<?>, Integer> columnIndices;
    private int indentation = 4;
    private int verticalLinePosition = 2;
    private transient String treeBlank;
    private transient String treeLine;
    private transient String treeCross;
    private transient String treeEnd;
    private transient Map<Object, Object> parentObjects;

    public TreeTableFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.beforeFill = "\u2026\u2026";
        this.fillCharacter = (char)8230;
        this.omitTrailingNulls = true;
    }

    private void clearTreeSymbols() {
        this.treeBlank = null;
        this.treeLine = null;
        this.treeCross = null;
        this.treeEnd = null;
    }

    @Override
    public final Class<TreeTable> getValueType() {
        return TreeTable.class;
    }

    public TableColumn<?>[] getColumns() {
        return this.columnIndices != null ? DefaultTreeTable.getColumns(this.columnIndices) : null;
    }

    public void setColumns(TableColumn<?> ... columns) throws IllegalArgumentException {
        if (columns == null) {
            this.columnIndices = null;
        } else {
            if (columns.length == 0) {
                throw new IllegalArgumentException(Errors.format((short)20, "columns"));
            }
            this.columnIndices = DefaultTreeTable.createColumnIndices(columns);
        }
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive("indentation", indentation);
        this.indentation = indentation;
        if (this.verticalLinePosition > indentation) {
            this.verticalLinePosition = indentation;
        }
        this.clearTreeSymbols();
    }

    public int getVerticalLinePosition() {
        return this.verticalLinePosition;
    }

    public void setVerticalLinePosition(int verticalLinePosition) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("verticalLinePosition", 0, this.indentation, verticalLinePosition);
        this.verticalLinePosition = verticalLinePosition;
        this.clearTreeSymbols();
    }

    final Locale getDisplayLocale() {
        return this.getLocale();
    }

    final Format[] getFormats(TableColumn<?>[] columns, boolean mandatory) throws IllegalStateException {
        Format[] formats = new Format[columns.length];
        for (int i = 0; i < formats.length; ++i) {
            Class<String> valueType = columns[i].getElementType();
            formats[i] = this.getFormat(valueType);
            if (formats[i] != null || !mandatory || valueType.isAssignableFrom(String.class)) continue;
            throw new IllegalStateException(Errors.format((short)126, valueType));
        }
        return formats;
    }

    @Override
    public TreeTable parse(CharSequence text, ParsePosition pos) throws ParseException {
        int startNextLine;
        Matcher matcher = this.getColumnSeparatorMatcher(text);
        int length = text.length();
        int indexOfLineStart = pos.getIndex();
        int indentationLevel = 0;
        int[] indentations = new int[16];
        TreeTable.Node lastNode = null;
        DefaultTreeTable.Node root = null;
        DefaultTreeTable table = new DefaultTreeTable(this.columnIndices != null ? this.columnIndices : TableColumn.NAME_MAP);
        TableColumn<?>[] columns = DefaultTreeTable.getColumns(table.columnIndices);
        Format[] formats = this.getFormats(columns, true);
        do {
            int i;
            int c;
            char c2;
            int endOfLine;
            for (endOfLine = startNextLine = CharSequences.indexOfLineStart(text, 1, indexOfLineStart); endOfLine > indexOfLineStart && ((c2 = text.charAt(endOfLine - 1)) == '\r' || c2 == '\n'); --endOfLine) {
            }
            boolean hasChar = false;
            for (i = indexOfLineStart; i < endOfLine; i += Character.charCount(c)) {
                c = Character.codePointAt(text, i);
                if (Character.isSpaceChar(c)) continue;
                hasChar = true;
                if ("\u2500\u2502\u2514\u251c".indexOf(c) < 0) break;
            }
            if (!hasChar) break;
            int indexOfValue = i;
            i = CharSequences.skipTrailingWhitespaces(text, indexOfLineStart, i) - indexOfLineStart;
            DefaultTreeTable.Node node = new DefaultTreeTable.Node(table);
            try {
                matcher.region(indexOfValue, endOfLine);
                for (int ci = 0; ci < columns.length; ++ci) {
                    boolean found = matcher.find();
                    int endOfColumn = found ? matcher.start() : endOfLine;
                    int endOfValue = CharSequences.skipTrailingWhitespaces(text, indexOfValue = CharSequences.skipLeadingWhitespaces(text, indexOfValue, endOfColumn), endOfColumn);
                    if (endOfValue > indexOfValue) {
                        this.parseValue(node, columns[ci], formats[ci], text.subSequence(indexOfValue, endOfValue).toString());
                    }
                    if (found) {
                        indexOfValue = matcher.end();
                        continue;
                    }
                    break;
                }
            }
            catch (ParseException e) {
                pos.setErrorIndex(indexOfValue);
                throw e;
            }
            if (root == null) {
                indentations[0] = i;
                root = node;
            } else {
                int p;
                while (i < (p = indentations[indentationLevel])) {
                    if (--indentationLevel < 0) {
                        pos.setErrorIndex(indexOfLineStart);
                        throw new LocalizedParseException(this.getDisplayLocale(), 75, new Object[]{node}, 0);
                    }
                    lastNode = lastNode.getParent();
                }
                if (i == p) {
                    TreeTable.Node parent = lastNode.getParent();
                    if (parent == null) {
                        pos.setErrorIndex(indexOfLineStart);
                        throw new LocalizedParseException(this.getDisplayLocale(), 75, new Object[]{node}, 0);
                    }
                    parent.getChildren().add(node);
                } else if (i > p) {
                    lastNode.getChildren().add(node);
                    if (++indentationLevel == indentations.length) {
                        indentations = Arrays.copyOf(indentations, indentationLevel * 2);
                    }
                    indentations[indentationLevel] = i;
                }
            }
            lastNode = node;
        } while ((indexOfLineStart = startNextLine) != length);
        if (root == null) {
            return null;
        }
        pos.setIndex(indexOfLineStart);
        table.setRoot(root);
        return table;
    }

    private <V> void parseValue(TreeTable.Node node, TableColumn<V> column, Format format, String text) throws ParseException {
        Object value = format != null ? format.parseObject(text) : text;
        node.setValue(column, column.getElementType().cast(value));
    }

    private void createTreeSymbols() {
        int indentation = this.indentation;
        int verticalLinePosition = this.verticalLinePosition;
        char[] buffer = new char[indentation];
        block6: for (int k = 0; k < 4; ++k) {
            char hc;
            int vc;
            if ((k & 2) == 0) {
                vc = (k & 1) == 0 ? 160 : 9474;
                hc = '\u00a0';
            } else {
                vc = (k & 1) == 0 ? 9492 : 9500;
                hc = '\u2500';
            }
            Arrays.fill(buffer, 0, verticalLinePosition, '\u00a0');
            buffer[verticalLinePosition] = vc;
            Arrays.fill(buffer, verticalLinePosition + 1, indentation, hc);
            String symbols = String.valueOf(buffer);
            switch (k) {
                case 0: {
                    this.treeBlank = symbols;
                    continue block6;
                }
                case 1: {
                    this.treeLine = symbols;
                    continue block6;
                }
                case 2: {
                    this.treeEnd = symbols;
                    continue block6;
                }
                case 3: {
                    this.treeCross = symbols;
                    continue block6;
                }
                default: {
                    throw new AssertionError(k);
                }
            }
        }
    }

    final String getTreeSymbols(boolean isParent, boolean isLast) {
        return isParent ? (isLast ? this.treeBlank : this.treeLine) : (isLast ? this.treeEnd : this.treeCross);
    }

    final void writeColumnSeparator(Appendable out) throws IOException {
        ((TableAppender)out.append(this.beforeFill)).nextColumn(this.fillCharacter);
        out.append(this.columnSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void format(TreeTable tree, Appendable toAppendTo) throws IOException {
        TableColumn<?>[] columns;
        ArgumentChecks.ensureNonNull("tree", tree);
        if (this.treeBlank == null) {
            this.createTreeSymbols();
        }
        if (this.columnIndices != null) {
            columns = DefaultTreeTable.getColumns(this.columnIndices);
        } else {
            List<TableColumn<?>> c = tree.getColumns();
            columns = c.toArray(new TableColumn[c.size()]);
        }
        if (this.parentObjects == null) {
            this.parentObjects = new IdentityHashMap<Object, Object>();
        }
        try {
            Writer out = new Writer(toAppendTo, columns, this.parentObjects);
            out.format(tree.getRoot(), 0);
            out.flush();
        }
        finally {
            this.parentObjects.clear();
        }
    }

    private final class Writer
    extends LineAppender {
        private final TableColumn<?>[] columns;
        private final Format[] formats;
        private final Object[] values;
        private boolean[] isLast;
        private final Map<Object, Object> parentObjects;
        private transient Format columnFormat;

        Writer(Appendable out, TableColumn<?>[] columns, Map<Object, Object> parentObjects) {
            super(columns.length >= 2 ? new TableAppender(out, "") : out);
            this.columns = columns;
            this.formats = TreeTableFormat.this.getFormats(columns, false);
            this.values = new Object[columns.length];
            this.isLast = new boolean[8];
            this.parentObjects = parentObjects;
            this.setTabulationExpanded(true);
            this.setLineSeparator(" \u00b6 ");
        }

        private String toString(GenericName name) {
            Locale locale = TreeTableFormat.this.getDisplayLocale();
            if (name != null) {
                String localized;
                InternationalString i18n = name.toInternationalString();
                if (i18n != null && (localized = i18n.toString(locale)) != null) {
                    return localized;
                }
                localized = name.toString();
                if (localized != null) {
                    return localized;
                }
            }
            return '(' + Vocabulary.getResources(locale).getString((short)65) + ')';
        }

        private void formatValue(Object value, boolean recursive) throws IOException {
            CharSequence text;
            if (value == null) {
                text = " ";
            } else if (this.columnFormat != null) {
                if (this.columnFormat instanceof CompoundFormat) {
                    this.formatValue((CompoundFormat)this.columnFormat, value);
                    return;
                }
                text = this.columnFormat.format(value);
            } else if (value instanceof InternationalString) {
                text = ((InternationalString)value).toString(TreeTableFormat.this.getDisplayLocale());
            } else if (value instanceof CharSequence) {
                text = value.toString();
            } else if (value instanceof CodeList) {
                text = Types.getCodeTitle((CodeList)value).toString(TreeTableFormat.this.getDisplayLocale());
            } else if (value instanceof Enum) {
                text = CharSequences.upperCaseToSentence(((Enum)value).name());
            } else if (value instanceof Type) {
                text = this.toString(((Type)value).getTypeName());
            } else if (value instanceof Locale) {
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                text = locale != Locale.ROOT ? ((Locale)value).getDisplayName(locale) : value.toString();
            } else if (value instanceof TimeZone) {
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                text = locale != Locale.ROOT ? ((TimeZone)value).getDisplayName(locale) : ((TimeZone)value).getID();
            } else if (value instanceof Charset) {
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                text = locale != Locale.ROOT ? ((Charset)value).displayName(locale) : ((Charset)value).name();
            } else {
                if (value instanceof Record) {
                    this.formatCollection(((Record)value).getAttributes().values(), recursive);
                    return;
                }
                if (value instanceof Iterable) {
                    this.formatCollection((Iterable)value, recursive);
                    return;
                }
                if (value instanceof Object[]) {
                    this.formatCollection(Arrays.asList((Object[])value), recursive);
                    return;
                }
                Format format = TreeTableFormat.this.getFormat(value.getClass());
                text = format != null ? format.format(value) : value.toString();
            }
            this.append(text);
        }

        private void formatCollection(Iterable<?> values, boolean recursive) throws IOException {
            if (values != null) {
                if (recursive) {
                    this.append('\u2026');
                } else {
                    int count = 0;
                    for (Object value : values) {
                        if (value == null) continue;
                        if (count != 0) {
                            this.append(", ");
                        }
                        this.formatValue(value, true);
                        if (++count != 10) continue;
                        this.append(", \u2026");
                        break;
                    }
                }
            }
        }

        private <V> void formatValue(CompoundFormat<V> format, Object value) throws IOException {
            format.format(format.getValueType().cast(value), this);
        }

        final void format(TreeTable.Node node, int level) throws IOException {
            Object userObject;
            int i;
            for (int i2 = 0; i2 < level; ++i2) {
                this.out.append(TreeTableFormat.this.getTreeSymbols(i2 != level - 1, this.isLast[i2]));
            }
            int n = 0;
            for (i = 0; i < this.columns.length; ++i) {
                this.values[i] = node.getValue(this.columns[i]);
                if (this.values[i] == null) continue;
                n = i;
            }
            if (!TreeTableFormat.this.omitTrailingNulls) {
                n = this.values.length - 1;
            }
            for (i = 0; i <= n; ++i) {
                if (i != 0) {
                    TreeTableFormat.this.writeColumnSeparator(this.out);
                }
                this.columnFormat = this.formats[i];
                this.formatValue(this.values[i], false);
                this.clear();
            }
            this.out.append(TreeTableFormat.this.lineSeparator);
            if (level >= this.isLast.length) {
                this.isLast = Arrays.copyOf(this.isLast, level * 2);
            }
            if (this.parentObjects.put(userObject = node.getUserObject(), userObject) == null) {
                Iterator<TreeTable.Node> it = node.getChildren().iterator();
                boolean hasNext = it.hasNext();
                while (hasNext) {
                    TreeTable.Node child = it.next();
                    hasNext = it.hasNext();
                    this.isLast[level] = !hasNext;
                    this.format(child, level + 1);
                }
                this.parentObjects.remove(userObject);
            } else {
                for (int i3 = 0; i3 < level; ++i3) {
                    this.out.append(TreeTableFormat.this.getTreeSymbols(true, this.isLast[i3]));
                }
                Locale locale = TreeTableFormat.this.getDisplayLocale();
                this.out.append('(').append(Vocabulary.getResources(locale).getString((short)12).toLowerCase(locale)).append(')').append(TreeTableFormat.this.lineSeparator);
            }
        }
    }
}

