/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.File;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.opengis.util.InternationalString;

public final class TreeTables
extends Static {
    private TreeTables() {
    }

    public static TreeTable.Node nodeForPath(TreeTable.Node from, TableColumn<? super String> column, File path) {
        String name;
        File parent = path.getParentFile();
        if (parent != null) {
            from = TreeTables.nodeForPath(from, column, parent);
        }
        if ((name = path.getName()).isEmpty() && parent == null) {
            name = File.separator;
        }
        for (TreeTable.Node child : from.getChildren()) {
            if (!name.equals(child.getValue(column))) continue;
            return child;
        }
        from = from.newChild();
        from.setValue(column, name);
        return from;
    }

    public static int replaceCharSequences(TreeTable table, Locale locale) {
        ArgumentChecks.ensureNonNull("table", table);
        List<TableColumn<?>> columns = table.getColumns();
        TableColumn[] filtered = new TableColumn[columns.size()];
        int count = 0;
        for (TableColumn<?> column : columns) {
            if (!column.getElementType().isAssignableFrom(String.class)) continue;
            filtered[count++] = column;
        }
        filtered = ArraysExt.resize(filtered, count);
        return TreeTables.replaceCharSequences(table.getRoot(), filtered, locale, new HashMap<String, String>());
    }

    private static int replaceCharSequences(TreeTable.Node node, TableColumn<? super String>[] columns, Locale locale, Map<String, String> pool) {
        int changes = 0;
        for (TreeTable.Node child : node.getChildren()) {
            changes += TreeTables.replaceCharSequences(child, columns, locale, pool);
        }
        for (TableColumn<? super String> column : columns) {
            String value = node.getValue(column);
            if (value == null) continue;
            String text = value instanceof InternationalString ? ((InternationalString)((Object)value)).toString(locale) : value.toString();
            String old = pool.put(text, text);
            if (old != null) {
                pool.put(old, old);
                text = old;
            }
            if (text == value) continue;
            node.setValue(column, text);
            ++changes;
        }
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(TreeTable table) {
        ArgumentChecks.ensureNonNull("table", table);
        TreeTableFormat treeTableFormat = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat) {
            return TreeTableFormat.INSTANCE.format(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeTable parse(String tree, TableColumn<?> labelColumn, TableColumn<?> ... otherColumns) throws ParseException {
        TreeTableFormat format;
        ArgumentChecks.ensureNonNull("tree", tree);
        ArgumentChecks.ensureNonNull("labelColumn", labelColumn);
        TableColumn<?>[] columns = null;
        if (otherColumns.length != 0 || labelColumn != TableColumn.NAME) {
            columns = ArraysExt.insert(otherColumns, 0, 1);
            columns[0] = labelColumn;
        }
        TreeTableFormat treeTableFormat = format = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat) {
            TreeTable treeTable;
            try {
                format.setColumns(columns);
                treeTable = (TreeTable)format.parseObject(tree);
            }
            catch (Throwable throwable) {
                format.setColumns(null);
                throw throwable;
            }
            format.setColumns(null);
            return treeTable;
        }
    }
}

