/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.WeakEntry;
import org.apache.sis.util.resources.Errors;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private static final byte IDENTITY = 0;
    private static final byte EQUALS = 1;
    private static final byte DEEP_EQUALS = 2;
    private Entry[] table;
    private int count;
    private final Class<K> keyType;
    private final byte comparisonMode;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient long lastTimeNormalCapacity;

    public WeakValueHashMap(Class<K> keyType) {
        this(keyType, false);
    }

    public WeakValueHashMap(Class<K> keyType, boolean identity) {
        this.keyType = keyType;
        this.comparisonMode = identity ? 0 : (keyType.isArray() || keyType.equals(Object.class) ? 2 : 1);
        this.lastTimeNormalCapacity = System.nanoTime();
        Entry[] table = (Entry[])Array.newInstance(Entry.class, 7);
        this.table = table;
    }

    private synchronized void removeEntry(Entry toRemove) {
        assert (this.isValid());
        int capacity = this.table.length;
        if (toRemove.removeFrom(this.table, toRemove.hash % capacity)) {
            long currentTime;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(capacity) && (currentTime = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count, "remove");
                this.lastTimeNormalCapacity = currentTime;
                assert (this.isValid());
            }
        }
    }

    final boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    final int keyHashCode(Object key) {
        switch (this.comparisonMode) {
            case 0: {
                return System.identityHashCode(key);
            }
            case 1: {
                return key.hashCode();
            }
            case 2: {
                return Utilities.deepHashCode(key);
            }
        }
        throw new AssertionError(this.comparisonMode);
    }

    final boolean keyEquals(Object k1, Object k2) {
        switch (this.comparisonMode) {
            case 0: {
                return k1 == k2;
            }
            case 1: {
                return k1.equals(k2);
            }
            case 2: {
                return Objects.deepEquals(k1, k2);
            }
        }
        throw new AssertionError(this.comparisonMode);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public synchronized V get(Object key) {
        assert (this.isValid());
        if (key != null) {
            Entry[] table = this.table;
            int index = (this.keyHashCode(key) & Integer.MAX_VALUE) % table.length;
            Entry e = table[index];
            while (e != null) {
                if (this.keyEquals(key, e.key)) {
                    return (V)e.get();
                }
                e = (Entry)e.next;
            }
        }
        return null;
    }

    private synchronized V intern(Object key, V value, boolean replace) {
        assert (this.isValid());
        V oldValue = null;
        Entry[] table = this.table;
        int hash = this.keyHashCode(key) & Integer.MAX_VALUE;
        int index = hash % table.length;
        Entry e = table[index];
        while (e != null) {
            if (this.keyEquals(key, e.key)) {
                oldValue = (V)e.get();
                if (oldValue != null && !replace) {
                    return oldValue;
                }
                e.dispose();
                table = this.table;
                index = hash % table.length;
            }
            e = (Entry)e.next;
        }
        if (value != null) {
            if (++this.count >= WeakEntry.lowerCapacityThreshold(table.length)) {
                if (this.count > WeakEntry.upperCapacityThreshold(table.length)) {
                    this.table = table = (Entry[])WeakEntry.rehash(table, this.count, "put");
                    index = hash % table.length;
                }
                this.lastTimeNormalCapacity = System.nanoTime();
            }
            table[index] = new Entry(this.keyType.cast(key), value, table[index], hash);
        }
        assert (this.isValid());
        return oldValue;
    }

    @Override
    public V put(K key, V value) throws NullArgumentException {
        if (key == null || value == null) {
            throw new NullArgumentException(Errors.format(key == null ? (short)96 : 97));
        }
        return this.intern(key, value, true);
    }

    @Override
    public V putIfAbsent(K key, V value) throws NullArgumentException {
        if (key == null || value == null) {
            throw new NullArgumentException(Errors.format(key == null ? (short)96 : 97));
        }
        return this.intern(key, value, false);
    }

    @Override
    public V remove(Object key) {
        return this.intern(key, null, true);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<K, V>[] toArray() {
            WeakValueHashMap weakValueHashMap = WeakValueHashMap.this;
            synchronized (weakValueHashMap) {
                Entry[] table;
                assert (WeakValueHashMap.this.isValid());
                Map.Entry[] elements = new Map.Entry[this.size()];
                int index = 0;
                for (Entry el : table = WeakValueHashMap.this.table) {
                    while (el != null) {
                        AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(el);
                        if (entry.getValue() != null) {
                            elements[index++] = entry;
                        }
                        el = (Entry)el.next;
                    }
                }
                return ArraysExt.resize(elements, index);
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Arrays.asList(this.toArray()).iterator();
        }
    }

    private final class Entry
    extends WeakEntry<V>
    implements Map.Entry<K, V> {
        final K key;

        Entry(K key, V value, Entry next, int hash) {
            super(value, next, hash);
            this.key = key;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V value) {
            if (value != null) {
                throw new UnsupportedOperationException();
            }
            Object old = this.get();
            this.dispose();
            return old;
        }

        @Override
        public void dispose() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)other;
                return WeakValueHashMap.this.keyEquals(this.key, that.getKey()) && Objects.equals(this.get(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = WeakValueHashMap.this.keyHashCode(this.key);
            Object val2 = this.get();
            if (val2 != null) {
                code ^= val2.hashCode();
            }
            return code;
        }
    }
}

