/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.util.CodeList;

final class CodeListFilter
implements CodeList.Filter {
    private final String codename;
    private final boolean canCreate;

    CodeListFilter(String codename, boolean canCreate) {
        this.codename = codename;
        this.canCreate = canCreate;
    }

    @Override
    public String codename() {
        return this.canCreate ? this.codename : null;
    }

    @Override
    public boolean accept(CodeList<?> code) {
        for (String candidate : code.names()) {
            if (!CodeListFilter.accept(candidate, this.codename)) continue;
            return true;
        }
        return false;
    }

    static boolean accept(String candidate, String codename) {
        return CharSequences.equalsFiltered(candidate, codename, Characters.Filter.LETTERS_AND_DIGITS, true);
    }
}

