/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public class DefaultScopedName
extends AbstractName
implements ScopedName {
    private static final long serialVersionUID = 1363103337249930577L;
    private final UnmodifiableArrayList<? extends LocalName> parsedNames;
    private transient GenericName tail;
    private transient GenericName path;

    static AbstractName create(UnmodifiableArrayList<? extends DefaultLocalName> names) {
        ArgumentChecks.ensureNonNull("names", names);
        switch (names.size()) {
            default: {
                return new DefaultScopedName(names);
            }
            case 1: {
                return names.get(0);
            }
            case 0: 
        }
        throw new IllegalArgumentException(Errors.format((short)20, "names"));
    }

    private DefaultScopedName(UnmodifiableArrayList<? extends LocalName> names) {
        this.parsedNames = names;
    }

    protected DefaultScopedName(NameSpace scope, List<? extends CharSequence> names) {
        ArgumentChecks.ensureNonNull("names", names);
        int size = names.size();
        ArgumentChecks.ensureSizeBetween("names", 2, Integer.MAX_VALUE, size);
        DefaultNameSpace ns = DefaultNameSpace.castOrCopy(scope);
        boolean global = ns.isGlobal();
        int i = 0;
        LocalName[] locals = new LocalName[size];
        Iterator<? extends CharSequence> it = names.iterator();
        CharSequence name = it.next();
        do {
            ArgumentChecks.ensureNonNullElement("names", i, name);
            locals[i++] = new DefaultLocalName(ns, name);
            ns = ns.child(name);
            name = it.next();
        } while (it.hasNext());
        DefaultLocalName tip = ns.local(name, null);
        if (global) {
            tip.fullyQualified = this.fullyQualified = this;
        }
        locals[i++] = tip;
        if (i != size) {
            throw new ConcurrentModificationException(Errors.format((short)108, "names"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(locals);
    }

    protected DefaultScopedName(GenericName path, GenericName tail) {
        ArgumentChecks.ensureNonNull("path", path);
        ArgumentChecks.ensureNonNull("tail", tail);
        List<? extends LocalName> parsedPath = path.getParsedNames();
        List<? extends LocalName> parsedTail = tail.getParsedNames();
        int index = parsedPath.size();
        LocalName[] locals = new LocalName[index + parsedTail.size()];
        locals = parsedPath.toArray(locals);
        Iterator<? extends LocalName> it = parsedTail.iterator();
        LocalName name = it.next();
        LocalName lastName = locals[index - 1];
        NameSpace lastScope = lastName.scope();
        NameSpace tailScope = name.scope();
        if (tailScope instanceof DefaultNameSpace && ((DefaultNameSpace)tailScope).parent() == lastScope) {
            if (path instanceof LocalName) {
                this.tail = tail;
            }
            while (true) {
                locals[index++] = name;
                if (it.hasNext()) {
                    name = it.next();
                    continue;
                }
                break;
            }
        } else {
            DefaultNameSpace scope = DefaultNameSpace.castOrCopy(lastScope);
            CharSequence label = DefaultScopedName.name(lastName);
            while (true) {
                scope = scope.child(label);
                label = DefaultScopedName.name(name);
                name = new DefaultLocalName(scope, label);
                locals[index++] = name;
                if (!it.hasNext()) break;
                name = it.next();
            }
        }
        if (index != locals.length) {
            throw new ConcurrentModificationException(Errors.format((short)108, "tail"));
        }
        this.parsedNames = UnmodifiableArrayList.wrap(locals);
        if (tail instanceof LocalName) {
            this.path = path;
        }
    }

    private static CharSequence name(GenericName name) {
        if (name instanceof DefaultLocalName) {
            return ((DefaultLocalName)name).name;
        }
        InternationalString label = name.toInternationalString();
        return label != null ? label : name.toString();
    }

    @Override
    final int arraySize() {
        return this.parsedNames.arraySize();
    }

    @Override
    public NameSpace scope() {
        return this.head().scope();
    }

    @Override
    public synchronized GenericName tail() {
        if (this.tail == null) {
            int size = this.parsedNames.size();
            switch (size) {
                default: {
                    this.tail = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(1, size));
                    break;
                }
                case 2: {
                    this.tail = this.parsedNames.get(1);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(size);
                }
            }
        }
        return this.tail;
    }

    @Override
    public synchronized GenericName path() {
        if (this.path == null) {
            int size = this.parsedNames.size();
            switch (size) {
                default: {
                    this.path = new DefaultScopedName((UnmodifiableArrayList<? extends LocalName>)this.parsedNames.subList(0, size - 1));
                    break;
                }
                case 2: {
                    this.path = this.parsedNames.get(0);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(size);
                }
            }
        }
        return this.path;
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.parsedNames;
    }
}

