/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.TypeNames;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public final class Names
extends Static {
    private Names() {
    }

    private static NameSpace createNameSpace(NameFactory factory, CharSequence namespace, String separator) {
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        return factory.createNameSpace(factory.createLocalName(null, namespace), separator == null ? null : Collections.singletonMap("separator.head", separator));
    }

    public static GenericName parseGenericName(CharSequence namespace, String separator, CharSequence scopedName) {
        ArgumentChecks.ensureNonNull("localPart", scopedName);
        ArgumentChecks.ensureNonNull("separator", separator);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.parseGenericName(Names.createNameSpace(factory, namespace, separator), scopedName);
    }

    public static LocalName createLocalName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        ArgumentChecks.ensureNonNull("separator", separator);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createLocalName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static TypeName createTypeName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        ArgumentChecks.ensureNonNull("separator", separator);
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        return factory.createTypeName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static MemberName createMemberName(CharSequence namespace, String separator, CharSequence localPart, Class<?> valueClass) {
        ArgumentChecks.ensureNonNull("localPart", localPart);
        ArgumentChecks.ensureNonNull("separator", separator);
        ArgumentChecks.ensureNonNull("valueClass", valueClass);
        DefaultNameFactory factory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
        return factory.createMemberName(Names.createNameSpace(factory, namespace, separator), localPart, factory.toTypeName(valueClass));
    }

    public static Class<?> toClass(TypeName type) throws UnknownNameException {
        Class<?> c;
        if (type == null) {
            return null;
        }
        if (type instanceof DefaultTypeName) {
            c = ((DefaultTypeName)type).toClass();
        } else {
            try {
                c = TypeNames.toClass(TypeNames.namespace(type.scope()), type.toString());
            }
            catch (ClassNotFoundException e) {
                throw new UnknownNameException(TypeNames.unknown(type), e);
            }
            if (c == null) {
                throw new UnknownNameException(TypeNames.unknown(type));
            }
            if (c == Void.TYPE) {
                c = null;
            }
        }
        return c;
    }

    public static String toExpandedString(GenericName name) {
        if (name == null) {
            return null;
        }
        String localPart = name.toString();
        NameSpace scope = name.scope();
        if (scope == null || scope.isGlobal()) {
            return localPart;
        }
        String ns = scope.name().toString();
        return new StringBuilder(ns.length() + localPart.length() + 2).append('{').append(ns).append('}').append(localPart).toString();
    }
}

